/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.adventure;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.AdventureManager;
import net.momirealms.customnameplates.libraries.adventure.audience.Audience;
import net.momirealms.customnameplates.libraries.adventure.key.Key;
import net.momirealms.customnameplates.libraries.adventure.platform.bukkit.BukkitAudiences;
import net.momirealms.customnameplates.libraries.adventure.sound.Sound;
import net.momirealms.customnameplates.libraries.adventure.text.Component;
import net.momirealms.customnameplates.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.customnameplates.libraries.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.momirealms.customnameplates.libraries.adventure.title.Title;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import net.momirealms.customnameplates.paper.setting.CNLocale;
import net.momirealms.customnameplates.paper.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AdventureManagerImpl
implements AdventureManager {
    private final BukkitAudiences adventure;
    private static AdventureManagerImpl instance;
    private CacheSystem cacheSystem;

    public AdventureManagerImpl(CustomNameplatesPlugin plugin) {
        this.adventure = BukkitAudiences.create((Plugin)plugin);
        instance = this;
    }

    public static AdventureManagerImpl getInstance() {
        return instance;
    }

    public void close() {
        if (this.adventure != null) {
            this.adventure.close();
        }
    }

    public void reload() {
        if (this.cacheSystem != null) {
            this.cacheSystem.destroy();
        }
        this.cacheSystem = new CacheSystem(CNConfig.cacheSize);
    }

    public WrappedChatComponent getWrappedChatComponentFromMiniMessage(String text) {
        return this.cacheSystem.getWrappedChatComponentFromCache(text);
    }

    public Object getIChatComponentFromMiniMessage(String text) {
        return this.cacheSystem.getIChatFromCache(text);
    }

    @Override
    public String stripTags(String text) {
        return MiniMessage.miniMessage().stripTags(text);
    }

    @Override
    public Component getComponentFromMiniMessage(String text) {
        if (text == null) {
            return Component.empty();
        }
        return this.cacheSystem.getComponentFromCache(text);
    }

    @Override
    public void sendMessage(CommandSender sender, String s) {
        if (s == null) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.sendPlayerMessage(player, s);
        } else if (sender instanceof ConsoleCommandSender) {
            this.sendConsoleMessage(s);
        }
    }

    @Override
    public void sendMessageWithPrefix(CommandSender sender, String s) {
        if (s == null || s.equals("")) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.sendPlayerMessage(player, CNLocale.MSG_PREFIX + s);
        } else if (sender instanceof ConsoleCommandSender) {
            this.sendConsoleMessage(CNLocale.MSG_PREFIX + s);
        }
    }

    @Override
    public void sendConsoleMessage(String s) {
        if (s == null) {
            return;
        }
        Audience au = this.adventure.sender((CommandSender)Bukkit.getConsoleSender());
        au.sendMessage(this.getComponentFromMiniMessage(s));
    }

    @Override
    public void sendPlayerMessage(Player player, String s) {
        if (s == null) {
            return;
        }
        Audience au = this.adventure.player(player);
        au.sendMessage(this.getComponentFromMiniMessage(s));
    }

    @Override
    public void sendTitle(Player player, String title, String subtitle, int in, int duration, int out) {
        Audience au = this.adventure.player(player);
        Title.Times times = Title.Times.times(Duration.ofMillis(in), Duration.ofMillis(duration), Duration.ofMillis(out));
        au.showTitle(Title.title(this.getComponentFromMiniMessage(title), this.getComponentFromMiniMessage(subtitle), times));
    }

    @Override
    public void sendTitle(Player player, Component title, Component subtitle, int in, int duration, int out) {
        Audience au = this.adventure.player(player);
        Title.Times times = Title.Times.times(Duration.ofMillis(in), Duration.ofMillis(duration), Duration.ofMillis(out));
        au.showTitle(Title.title(title, subtitle, times));
    }

    @Override
    public void sendActionbar(Player player, String text) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SET_ACTION_BAR_TEXT);
        packet.getModifier().write(0, this.getIChatComponent(this.componentToJson(this.getComponentFromMiniMessage(text).append((Component)Component.score().name("np").objective("ab").build()))));
        PacketManager.getInstance().send(player, packet);
    }

    @Override
    public void sendActionbar(Player player, Component component) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SET_ACTION_BAR_TEXT);
        packet.getModifier().write(0, this.getIChatComponent(this.componentToJson(component)));
        PacketManager.getInstance().send(player, packet);
    }

    @Override
    public void sendSound(Player player, Sound.Source source, Key key, float volume, float pitch) {
        Sound sound = Sound.sound(key, source, volume, pitch);
        Audience au = this.adventure.player(player);
        au.playSound(sound);
    }

    @Override
    public void sendSound(Player player, Sound sound) {
        Audience au = this.adventure.player(player);
        au.playSound(sound);
    }

    @Override
    public String legacyToMiniMessage(String legacy) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = legacy.toCharArray();
        block25: for (int i = 0; i < chars.length; ++i) {
            if (!this.isColorCode(chars[i])) {
                stringBuilder.append(chars[i]);
                continue;
            }
            if (i + 1 >= chars.length) {
                stringBuilder.append(chars[i]);
                continue;
            }
            switch (chars[i + 1]) {
                case '0': {
                    stringBuilder.append("<black>");
                    break;
                }
                case '1': {
                    stringBuilder.append("<dark_blue>");
                    break;
                }
                case '2': {
                    stringBuilder.append("<dark_green>");
                    break;
                }
                case '3': {
                    stringBuilder.append("<dark_aqua>");
                    break;
                }
                case '4': {
                    stringBuilder.append("<dark_red>");
                    break;
                }
                case '5': {
                    stringBuilder.append("<dark_purple>");
                    break;
                }
                case '6': {
                    stringBuilder.append("<gold>");
                    break;
                }
                case '7': {
                    stringBuilder.append("<gray>");
                    break;
                }
                case '8': {
                    stringBuilder.append("<dark_gray>");
                    break;
                }
                case '9': {
                    stringBuilder.append("<blue>");
                    break;
                }
                case 'a': {
                    stringBuilder.append("<green>");
                    break;
                }
                case 'b': {
                    stringBuilder.append("<aqua>");
                    break;
                }
                case 'c': {
                    stringBuilder.append("<red>");
                    break;
                }
                case 'd': {
                    stringBuilder.append("<light_purple>");
                    break;
                }
                case 'e': {
                    stringBuilder.append("<yellow>");
                    break;
                }
                case 'f': {
                    stringBuilder.append("<white>");
                    break;
                }
                case 'r': {
                    stringBuilder.append("<r><!i>");
                    break;
                }
                case 'l': {
                    stringBuilder.append("<b>");
                    break;
                }
                case 'm': {
                    stringBuilder.append("<s>");
                    break;
                }
                case 'o': {
                    stringBuilder.append("<i>");
                    break;
                }
                case 'n': {
                    stringBuilder.append("<u>");
                    break;
                }
                case 'k': {
                    stringBuilder.append("<o>");
                    break;
                }
                case 'x': {
                    if (!(i + 13 < chars.length && this.isColorCode(chars[i + 2]) && this.isColorCode(chars[i + 4]) && this.isColorCode(chars[i + 6]) && this.isColorCode(chars[i + 8]) && this.isColorCode(chars[i + 10]) && this.isColorCode(chars[i + 12]))) {
                        stringBuilder.append(chars[i]);
                        continue block25;
                    }
                    stringBuilder.append("<#").append(chars[i + 3]).append(chars[i + 5]).append(chars[i + 7]).append(chars[i + 9]).append(chars[i + 11]).append(chars[i + 13]).append(">");
                    i += 12;
                    break;
                }
                default: {
                    stringBuilder.append(chars[i]);
                    continue block25;
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isColorCode(char c) {
        return c == '\u00a7' || c == '&';
    }

    @Override
    public int colorToDecimal(ChatColor color) {
        switch (String.valueOf(color.getChar())) {
            case "0": {
                return 0;
            }
            case "c": {
                return 0xFF5555;
            }
            case "6": {
                return 0xFFAA00;
            }
            case "4": {
                return 0xAA0000;
            }
            case "e": {
                return 0xFFFF55;
            }
            case "2": {
                return 43520;
            }
            case "a": {
                return 0x55FF55;
            }
            case "b": {
                return 0x55FFFF;
            }
            case "3": {
                return 43690;
            }
            case "1": {
                return 170;
            }
            case "9": {
                return 0x5555FF;
            }
            case "d": {
                return 0xFF55FF;
            }
            case "5": {
                return 0xAA00AA;
            }
            case "8": {
                return 0x555555;
            }
            case "7": {
                return 0xAAAAAA;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public String componentToLegacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    @Override
    public String componentToJson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    @Override
    public String getMiniMessageFormat(Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    @Override
    public Object getIChatComponent(String json) {
        try {
            return ReflectionUtils.getiChatComponentMethod().invoke(null, json);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            return ReflectionUtils.getEmptyComponent();
        }
    }

    public class CacheSystem {
        private final LoadingCache<String, Object> miniMessageToIChatComponentCache;
        private final LoadingCache<String, Component> miniMessageToComponentCache;
        private final LoadingCache<String, WrappedChatComponent> miniMessageToWrappedChatComponentCache;

        public CacheSystem(int size) {
            this.miniMessageToIChatComponentCache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

                @NotNull
                public Object load(@NotNull String text) {
                    return CacheSystem.this.fetchIChatData(text);
                }
            });
            this.miniMessageToComponentCache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Component>(){

                @NotNull
                public Component load(@NotNull String text) {
                    return CacheSystem.this.fetchComponent(text);
                }
            });
            this.miniMessageToWrappedChatComponentCache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, WrappedChatComponent>(){

                @NotNull
                public WrappedChatComponent load(@NotNull String text) {
                    return CacheSystem.this.fetchWrappedChatComponent(text);
                }
            });
        }

        public void destroy() {
            this.miniMessageToComponentCache.cleanUp();
            this.miniMessageToIChatComponentCache.cleanUp();
        }

        @NotNull
        private Object fetchIChatData(String text) {
            Component component = AdventureManagerImpl.this.getComponentFromMiniMessage(text);
            return AdventureManagerImpl.this.getIChatComponent((String)GsonComponentSerializer.gson().serialize(component));
        }

        @NotNull
        private Component fetchComponent(String text) {
            if (CNConfig.legacyColorSupport) {
                return MiniMessage.miniMessage().deserialize(AdventureManagerImpl.this.legacyToMiniMessage(text));
            }
            return MiniMessage.miniMessage().deserialize(text);
        }

        @NotNull
        private WrappedChatComponent fetchWrappedChatComponent(String text) {
            if (CNConfig.legacyColorSupport) {
                return WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(AdventureManagerImpl.this.legacyToMiniMessage(text)))));
            }
            return WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(text))));
        }

        public Object getIChatFromCache(String text) {
            try {
                return this.miniMessageToIChatComponentCache.get((Object)text);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return ReflectionUtils.getEmptyComponent();
            }
        }

        public Component getComponentFromCache(String text) {
            try {
                return (Component)this.miniMessageToComponentCache.get((Object)text);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return Component.empty();
            }
        }

        public WrappedChatComponent getWrappedChatComponentFromCache(String text) {
            try {
                return (WrappedChatComponent)this.miniMessageToWrappedChatComponentCache.get((Object)text);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return WrappedChatComponent.fromText((String)"");
            }
        }
    }
}

