/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bossbar;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BossBarManager;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.Pair;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BarColor;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BossBar;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BossBarConfig;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BossBarReceiver;
import net.momirealms.customnameplates.paper.mechanic.bossbar.Overlay;
import net.momirealms.customnameplates.paper.mechanic.misc.DisplayController;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import net.momirealms.customnameplates.paper.util.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class BossBarManagerImpl
implements BossBarManager,
Listener {
    private final CustomNameplatesPlugin plugin;
    private final ConcurrentHashMap<UUID, BossBarReceiver> receiverMap;
    private BossBarConfig[] configs;

    public void load() {
        if (!CNConfig.bossBarModule) {
            return;
        }
        this.loadConfigs();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.createBossBarFor(player);
        }
    }

    public void unload() {
        HandlerList.unregisterAll((Listener)this);
        for (BossBarReceiver receiver : this.receiverMap.values()) {
            receiver.cancelTask();
            receiver.destroy();
        }
        this.receiverMap.clear();
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public BossBarManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.receiverMap = new ConcurrentHashMap();
        this.configs = new BossBarConfig[0];
    }

    private void loadConfigs() {
        ArrayList<BossBarConfig> configs = new ArrayList<BossBarConfig>();
        YamlConfiguration config = this.plugin.getConfig("configs" + File.separator + "bossbar.yml");
        for (Map.Entry barEntry : config.getValues(false).entrySet()) {
            Object v = barEntry.getValue();
            if (!(v instanceof ConfigurationSection)) {
                return;
            }
            ConfigurationSection section = (ConfigurationSection)v;
            BossBarConfig barConfig = BossBarConfig.Builder.of().barColor(BarColor.getColor(section.getString("color", "YELLOW"))).overlay(Overlay.getOverlay(section.getString("overlay", "PROGRESS"))).checkFrequency(section.getInt("check-frequency", 10)).requirement(this.plugin.getRequirementManager().getRequirements(section.getConfigurationSection("conditions"))).displayOrder(ConfigUtils.getTimeLimitTexts(section.getConfigurationSection("text-display-order"))).build();
            configs.add(barConfig);
        }
        this.configs = configs.toArray(new BossBarConfig[0]);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (CNConfig.sendDelay == 0) {
            this.createBossBarFor(player);
            return;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> this.createBossBarFor(player), (long)CNConfig.sendDelay * 50L, TimeUnit.MILLISECONDS);
    }

    private void createBossBarFor(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Pair[] pairs = new Pair[this.configs.length];
        for (int i = 0; i < this.configs.length; ++i) {
            BossBarConfig config = this.configs[i];
            pairs[i] = Pair.of(new DisplayController(player, config.getCheckFrequency(), config.getRequirements(), config.getTextDisplayOrder()), new BossBar(player, config.getOverlay(), config.getBarColor()));
        }
        BossBarReceiver bossBarReceiver = new BossBarReceiver(this.plugin, player, pairs);
        bossBarReceiver.arrangeTask();
        this.putReceiverToMap(player.getUniqueId(), bossBarReceiver);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BossBarReceiver receiver = this.receiverMap.remove(event.getPlayer().getUniqueId());
        if (receiver != null) {
            receiver.cancelTask();
        }
    }

    private void putReceiverToMap(UUID uuid, BossBarReceiver bossBarReceiver) {
        BossBarReceiver previous = this.receiverMap.put(uuid, bossBarReceiver);
        if (previous != null) {
            LogUtils.warn("Unexpected error: Duplicated bossbar created");
            previous.cancelTask();
        }
    }

    private BossBarReceiver getReceiver(UUID uuid) {
        return this.receiverMap.get(uuid);
    }
}

