/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.OnlineUser;
import net.momirealms.customnameplates.api.event.BubblesSpawnEvent;
import net.momirealms.customnameplates.api.event.NameplateDataLoadEvent;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.Bubble;
import net.momirealms.customnameplates.api.mechanic.bubble.ChannelMode;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.api.mechanic.character.CharacterArranger;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.EntityTagPlayer;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextTagSetting;
import net.momirealms.customnameplates.api.util.FontUtils;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;
import net.momirealms.customnameplates.paper.mechanic.bubble.image.ImageParser;
import net.momirealms.customnameplates.paper.mechanic.bubble.image.ItemsAdderImageImpl;
import net.momirealms.customnameplates.paper.mechanic.bubble.image.OraxenImageImpl;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.AsyncChatProvider;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.CarbonChatProvider;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.HuskChatProvider;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.PaperAsyncChatProvider;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.TrChatProvider;
import net.momirealms.customnameplates.paper.mechanic.bubble.provider.VentureChatProvider;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class BubbleManagerImpl
implements BubbleManager,
Listener {
    private AbstractChatProvider chatProvider;
    private AbstractChatProvider customProvider;
    private ImageParser imageParser;
    private final HashMap<String, Bubble> bubbleMap;
    private final CustomNameplatesPluginImpl plugin;
    private String defaultBubble;
    private String prefix;
    private String suffix;
    private String startFormat;
    private String endFormat;
    private double lineSpace;
    private double yOffset;
    private int stayTime;
    private int coolDown;
    private int maxCharLength;
    private int lengthPerLine;
    private int subStringIndex;
    private String[] blacklistChannels;
    private ChannelMode channelMode;

    public BubbleManagerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
        this.bubbleMap = new HashMap();
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void load() {
        if (!CNConfig.bubbleModule) {
            return;
        }
        this.loadConfig();
        this.loadBubbles();
        this.registerChatProvider();
        this.registerImageParser();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void unload() {
        this.imageParser = null;
        this.bubbleMap.clear();
        if (this.chatProvider != null) {
            this.chatProvider.unregister();
        }
        HandlerList.unregisterAll((Listener)this);
    }

    private void loadConfig() {
        YamlConfiguration config = this.plugin.getConfig("configs" + File.separator + "bubble.yml");
        this.defaultBubble = config.getString("default-bubbles", "chat");
        this.prefix = config.getString("text-prefix", "");
        this.suffix = config.getString("text-suffix", "");
        this.lineSpace = config.getDouble("line-spacing");
        this.yOffset = config.getDouble("bottom-line-Y-offset");
        this.stayTime = config.getInt("stay-time", 5);
        this.coolDown = (int)(config.getDouble("cool-down", 1.0) * 1000.0);
        this.maxCharLength = config.getInt("max-character-length", 100);
        this.blacklistChannels = config.getStringList("blacklist-channels").toArray(new String[0]);
        this.subStringIndex = config.getInt("sub-string-index", 0);
        this.lengthPerLine = config.getInt("characters-per-line", 30);
        this.startFormat = config.getString("default-format.start", "<gradient:#F5F5F5:#E1FFFF:#F5F5F5><u>");
        this.endFormat = config.getString("default-format.end", "<!u></gradient>");
        this.channelMode = ChannelMode.valueOf(config.getString("channel-mode", "all").toUpperCase(Locale.ENGLISH));
    }

    private void registerImageParser() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (pluginManager.isPluginEnabled("Oraxen")) {
            this.imageParser = new OraxenImageImpl();
        } else if (pluginManager.isPluginEnabled("ItemsAdder")) {
            this.imageParser = new ItemsAdderImageImpl();
        }
    }

    private void registerChatProvider() {
        if (this.customProvider != null) {
            this.chatProvider = this.customProvider;
        } else if (CNConfig.trChatChannel) {
            this.chatProvider = new TrChatProvider(this);
        } else if (CNConfig.ventureChatChannel) {
            this.chatProvider = new VentureChatProvider(this);
        } else if (CNConfig.huskChatChannel) {
            this.chatProvider = new HuskChatProvider(this);
        } else if (CNConfig.carbonChatChannel) {
            this.chatProvider = new CarbonChatProvider(this);
        } else {
            try {
                Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
                this.chatProvider = new PaperAsyncChatProvider(this);
            }
            catch (ClassNotFoundException e) {
                this.chatProvider = new AsyncChatProvider(this);
            }
        }
        this.chatProvider.register();
    }

    @Override
    public boolean setCustomChatProvider(AbstractChatProvider provider) {
        if (this.customProvider != null) {
            return false;
        }
        this.customProvider = provider;
        if (this.chatProvider != null) {
            this.chatProvider.unregister();
        }
        this.registerChatProvider();
        return true;
    }

    @Override
    public boolean removeCustomChatProvider() {
        if (this.customProvider != null) {
            this.customProvider.unregister();
            this.customProvider = null;
            this.registerChatProvider();
            return true;
        }
        return false;
    }

    private void loadBubbles() {
        File[] bbConfigFiles;
        File bubbleFolder = new File(this.plugin.getDataFolder(), "contents" + File.separator + "bubbles");
        if (!bubbleFolder.exists() && bubbleFolder.mkdirs()) {
            this.saveDefaultBubbles();
        }
        if ((bbConfigFiles = bubbleFolder.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(bbConfigFiles, Comparator.comparing(File::getName));
        for (File bbConfigFile : bbConfigFiles) {
            String key = bbConfigFile.getName().substring(0, bbConfigFile.getName().length() - 4);
            if (key.equals("none")) {
                LogUtils.severe("You can't use 'none' as bubble's key");
                continue;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)bbConfigFile);
            if (this.registerBubble(key, Bubble.builder().displayName(config.getString("display-name", key)).startFormat(config.getString("text-format.start", "")).endFormat(config.getString("text-format.end", "")).left(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("left.image", key + "_left")).height(config.getInt("left.height", 16)).ascent(config.getInt("left.ascent", 12)).width(config.getInt("left.width", 16)).build()).right(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("right.image", key + "_right")).height(config.getInt("right.height", 16)).ascent(config.getInt("right.ascent", 12)).width(config.getInt("right.width", 16)).build()).middle(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.image", key + "_middle")).height(config.getInt("middle.height", 16)).ascent(config.getInt("middle.ascent", 12)).width(config.getInt("middle.width", 16)).build()).tail(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("tail.image", key + "_tail")).height(config.getInt("tail.height", 16)).ascent(config.getInt("tail.ascent", 12)).width(config.getInt("tail.width", 16)).build()).build())) continue;
            LogUtils.warn("Found duplicated bubble: " + key);
        }
    }

    @Override
    public boolean registerBubble(String key, Bubble bubble) {
        if (this.bubbleMap.containsKey(key)) {
            return false;
        }
        this.bubbleMap.put(key, bubble);
        return true;
    }

    @Override
    public boolean unregisterBubble(String key) {
        return this.bubbleMap.remove(key) != null;
    }

    @Override
    public void onChat(Player player, String text) {
        this.onChat(player, text, null);
    }

    @Override
    public void onChat(Player player, String text, String channel) {
        Bubble bubbleConfig;
        if (player.getGameMode() == GameMode.SPECTATOR || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || !player.hasPermission("bubbles.use")) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            String finalText = text;
            CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.onChat(player, finalText));
            return;
        }
        Optional<OnlineUser> optionalUser = this.plugin.getStorageManager().getOnlineUser(player.getUniqueId());
        if (optionalUser.isEmpty()) {
            return;
        }
        String bubble = optionalUser.get().getBubbleKey();
        if (text.length() >= this.subStringIndex) {
            text = text.substring(this.subStringIndex);
        }
        text = this.imageParser != null ? this.imageParser.parse(player, text) : text;
        BubblesSpawnEvent bubblesEvent = new BubblesSpawnEvent(player, bubble, text);
        Bukkit.getPluginManager().callEvent((Event)bubblesEvent);
        if (bubblesEvent.isCancelled()) {
            return;
        }
        bubble = bubblesEvent.getBubble();
        if (bubble.equals("none")) {
            bubble = this.defaultBubble;
        }
        if ((bubbleConfig = this.getBubble(bubble)) == null && !bubble.equals("none")) {
            LogUtils.warn("Bubble " + bubble + " doesn't exist");
            return;
        }
        if (this.plugin.getCoolDownManager().isCoolDown(player.getUniqueId(), "bubble", this.coolDown)) {
            return;
        }
        text = AdventureManagerImpl.getInstance().legacyToMiniMessage(bubblesEvent.getText());
        String strippedRawText = MiniMessage.miniMessage().stripTags(text);
        if (strippedRawText.length() > this.maxCharLength) {
            return;
        }
        String[] split = this.splitString(strippedRawText, this.lengthPerLine);
        for (int i = 0; i < split.length; ++i) {
            int finalIndex = i;
            String finalBubble = bubble;
            this.plugin.getScheduler().runTaskAsyncLater(() -> this.sendBubble(player, split[finalIndex], bubbleConfig, finalBubble, channel), (long)i * 250L + 100L, TimeUnit.MILLISECONDS);
        }
    }

    private void sendBubble(Player player, String text, Bubble bubbleConfig, String key, @Nullable String channel) {
        if (key.equals("none")) {
            text = this.startFormat + PlaceholderAPI.setPlaceholders((Player)player, (String)this.prefix) + (String)text + PlaceholderAPI.setPlaceholders((Player)player, (String)this.suffix) + this.endFormat;
        } else {
            text = bubbleConfig.getStartFormat() + PlaceholderAPI.setPlaceholders((Player)player, (String)this.prefix) + (String)text + PlaceholderAPI.setPlaceholders((Player)player, (String)this.suffix) + bubbleConfig.getEndFormat();
            int width = FontUtils.getTextWidth((String)text);
            text = bubbleConfig.getPrefixWithFont(width) + (String)text + bubbleConfig.getSuffixWithFont(width);
        }
        EntityTagPlayer tagPlayer = this.plugin.getNameplateManager().getUnlimitedTagManager().createOrGetTagForPlayer(player);
        if (tagPlayer == null) {
            return;
        }
        StaticTextEntity entity = tagPlayer.addTag(StaticTextTagSetting.builder().leaveRule((p, e) -> true).comeRule((p, e) -> {
            switch (this.channelMode) {
                case ALL: {
                    return true;
                }
                case JOINED: {
                    return channel == null || this.chatProvider.hasJoinedChannel(p, channel);
                }
                case CAN_JOIN: {
                    return channel == null || this.chatProvider.canJoinChannel(p, channel);
                }
            }
            return false;
        }).verticalOffset(this.yOffset).defaultText((String)text).plugin("bubble").build());
        for (StaticTextEntity bubble : tagPlayer.getStaticTags()) {
            if (!bubble.getPlugin().equals("bubble")) continue;
            bubble.setOffset(bubble.getOffset() + this.lineSpace);
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> tagPlayer.removeTag(entity), this.stayTime, TimeUnit.SECONDS);
    }

    private String[] splitString(String str, int len) {
        int size = (int)Math.ceil((double)str.length() / (double)len);
        String[] result = new String[size];
        int index = 0;
        for (int i = 0; i < str.length(); i += len) {
            result[index++] = i + len > str.length() ? str.substring(i) : str.substring(i, i + len);
        }
        return result;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onDataLoaded(NameplateDataLoadEvent event) {
        OnlineUser data = event.getOnlineUser();
        String bubble = data.getBubbleKey();
        if (!bubble.equals("none") && !this.containsBubble(bubble)) {
            if (bubble.equals(this.defaultBubble)) {
                LogUtils.severe("Default nameplate doesn't exist");
                return;
            }
            LogUtils.severe("Bubble " + bubble + " doesn't exist. To prevent bugs, player " + event.getUUID() + " 's bubble data is reset");
            data.setBubble("none");
            this.plugin.getStorageManager().saveOnlinePlayerData(event.getUUID());
        }
    }

    @Override
    public Collection<String> getBubbleKeys() {
        return this.bubbleMap.keySet();
    }

    @Override
    @Nullable
    public Bubble getBubble(String bubble) {
        return this.bubbleMap.get(bubble);
    }

    @Override
    public boolean hasBubble(Player player, String bubble) {
        return player.hasPermission("bubbles.equip." + bubble);
    }

    @Override
    public List<String> getAvailableBubbles(Player player) {
        ArrayList<String> bubbles = new ArrayList<String>();
        for (String nameplate : this.bubbleMap.keySet()) {
            if (!this.hasBubble(player, nameplate)) continue;
            bubbles.add(nameplate);
        }
        return bubbles;
    }

    @Override
    public List<String> getAvailableBubblesDisplayNames(Player player) {
        ArrayList<String> bubbles = new ArrayList<String>();
        for (Map.Entry<String, Bubble> entry : this.bubbleMap.entrySet()) {
            if (!this.hasBubble(player, entry.getKey())) continue;
            bubbles.add(entry.getValue().getDisplayName());
        }
        return bubbles;
    }

    @Override
    public String[] getBlacklistChannels() {
        return this.blacklistChannels;
    }

    @Override
    public Collection<Bubble> getBubbles() {
        return this.bubbleMap.values();
    }

    @Override
    public boolean containsBubble(String key) {
        return this.bubbleMap.containsKey(key);
    }

    @Override
    public boolean equipBubble(Player player, String bubbleKey) {
        Bubble bubble = this.getBubble(bubbleKey);
        if (bubble == null && bubbleKey.equals("none")) {
            return false;
        }
        this.plugin.getStorageManager().getOnlineUser(player.getUniqueId()).ifPresentOrElse(it -> {
            if (it.getBubbleKey().equals(bubbleKey)) {
                return;
            }
            it.setBubble(bubbleKey);
            this.plugin.getStorageManager().saveOnlinePlayerData(player.getUniqueId());
        }, () -> LogUtils.severe("Player " + player.getName() + "'s data is not loaded."));
        return true;
    }

    @Override
    public void unEquipBubble(Player player) {
        this.plugin.getStorageManager().getOnlineUser(player.getUniqueId()).ifPresentOrElse(it -> {
            if (it.getBubbleKey().equals("none")) {
                return;
            }
            it.setNameplate("none");
            this.plugin.getStorageManager().saveOnlinePlayerData(player.getUniqueId());
        }, () -> LogUtils.severe("Player " + player.getName() + "'s data is not loaded."));
    }

    @Override
    public String getDefaultBubble() {
        return this.defaultBubble;
    }

    private void saveDefaultBubbles() {
        String[] png_list = new String[]{"chat"};
        String[] part_list = new String[]{"_left.png", "_middle.png", "_right.png", "_tail.png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "bubbles" + File.separatorChar + name + part, false);
            }
        }
    }
}

