/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble.provider;

import me.arasple.mc.trchat.TrChat;
import me.arasple.mc.trchat.api.event.TrChatEvent;
import me.arasple.mc.trchat.module.display.channel.Channel;
import me.arasple.mc.trchat.module.internal.filter.FilteredObject;
import me.arasple.mc.trchat.taboolib.platform.BukkitAdapter;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.api.util.LogUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TrChatProvider
extends AbstractChatProvider {
    private final BukkitAdapter adapter = new BukkitAdapter();

    public TrChatProvider(BubbleManager chatBubblesManager) {
        super(chatBubblesManager);
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CustomNameplatesPlugin.get());
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public boolean hasJoinedChannel(Player player, String channelID) {
        Object object = TrChat.INSTANCE.api().getChannelManager().getChannel(channelID);
        if (object instanceof Channel) {
            Channel channel = (Channel)object;
            return channel.getListeners().contains(player.getName());
        }
        LogUtils.warn("Channel " + channelID + " doesn't exist.");
        return false;
    }

    @Override
    public boolean canJoinChannel(Player player, String channelID) {
        Object object = TrChat.INSTANCE.api().getChannelManager().getChannel(channelID);
        if (object instanceof Channel) {
            Channel channel = (Channel)object;
            String perm = channel.getSettings().getJoinPermission();
            return player.hasPermission(perm);
        }
        LogUtils.warn("Channel " + channelID + " doesn't exist.");
        return false;
    }

    @EventHandler(ignoreCancelled=true)
    public void onTrChat(TrChatEvent event) {
        if (!event.getForward()) {
            return;
        }
        Channel channel = event.getChannel();
        String channelName = channel.getId();
        for (String black : this.chatBubblesManager.getBlacklistChannels()) {
            if (!channelName.equals(black)) continue;
            return;
        }
        FilteredObject object = TrChat.INSTANCE.api().getFilterManager().filter(event.getMessage(), this.adapter.adaptPlayer((Object)event.getPlayer()), true);
        CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.chatBubblesManager.onChat(event.getSession().getPlayer(), object.getFiltered(), channelName));
    }
}

