/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.image;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.ImageManager;
import net.momirealms.customnameplates.api.mechanic.character.CharacterArranger;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class ImageManagerImpl
implements ImageManager {
    private final HashMap<String, ConfiguredChar> imageMap;
    private final CustomNameplatesPlugin plugin;

    public ImageManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.imageMap = new HashMap();
    }

    public void load() {
        if (!CNConfig.imageModule) {
            return;
        }
        this.loadConfigs();
    }

    public void unload() {
        this.imageMap.clear();
    }

    public void reload() {
        this.unload();
        this.loadConfigs();
    }

    @Override
    public ConfiguredChar getImage(@NotNull String key) {
        return this.imageMap.get(key);
    }

    @Override
    public Collection<ConfiguredChar> getImages() {
        return this.imageMap.values();
    }

    private void loadConfigs() {
        File[] configFiles;
        File imgFolder = new File(this.plugin.getDataFolder(), "contents" + File.separator + "images");
        if (!imgFolder.exists() && imgFolder.mkdirs()) {
            this.saveDefaultImages();
        }
        if ((configFiles = imgFolder.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(configFiles, Comparator.comparing(File::getName));
        for (File configFile : configFiles) {
            String key = configFile.getName().substring(0, configFile.getName().length() - 4);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (this.registerImage(key, ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("image", key)).height(config.getInt("height", 10)).width(config.getInt("width", 10)).ascent(config.getInt("ascent", 8)).build())) continue;
            LogUtils.warn("Found duplicated image: " + key);
        }
    }

    @Override
    public boolean registerImage(@NotNull String key, @NotNull ConfiguredChar configuredChar) {
        if (this.imageMap.containsKey(key)) {
            return false;
        }
        this.imageMap.put(key, configuredChar);
        return true;
    }

    @Override
    public boolean unregisterImage(@NotNull String key) {
        return this.imageMap.remove(key) != null;
    }

    private void saveDefaultImages() {
        String[] png_list = new String[]{"bell", "bubble", "clock", "coin", "compass", "weather", "stamina_0", "stamina_1", "stamina_2"};
        String[] part_list = new String[]{".png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "images" + File.separator + name + part, false);
            }
        }
    }
}

