/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.misc;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class CoolDownManager
implements Listener {
    private final ConcurrentHashMap<UUID, Data> dataMap = new ConcurrentHashMap();
    private final CustomNameplatesPlugin plugin;

    public CoolDownManager(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isCoolDown(UUID uuid, String key, long time) {
        Data data = this.dataMap.computeIfAbsent(uuid, k -> new Data());
        return data.isCoolDown(key, time);
    }

    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void unload() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void disable() {
        this.unload();
        this.dataMap.clear();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.dataMap.remove(event.getPlayer().getUniqueId());
    }

    public static class Data {
        private final HashMap<String, Long> coolDownMap = new HashMap();

        public synchronized boolean isCoolDown(String key, long delay) {
            long time = System.currentTimeMillis();
            long last = this.coolDownMap.getOrDefault(key, time - delay);
            if (last + delay > time) {
                return true;
            }
            this.coolDownMap.put(key, time);
            return false;
        }
    }
}

