/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.OnlineUser;
import net.momirealms.customnameplates.api.event.NameplateDataLoadEvent;
import net.momirealms.customnameplates.api.manager.NameplateManager;
import net.momirealms.customnameplates.api.manager.TeamTagManager;
import net.momirealms.customnameplates.api.manager.UnlimitedTagManager;
import net.momirealms.customnameplates.api.mechanic.character.CharacterArranger;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.nameplate.CachedNameplate;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import net.momirealms.customnameplates.api.mechanic.nameplate.TagMode;
import net.momirealms.customnameplates.api.mechanic.tag.NameplatePlayer;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextTagSetting;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.util.FontUtils;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.EntityDestroyListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.EntityLookListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.EntityMoveListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.EntitySpawnListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.EntityTeleportListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamPlayer;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamTagManagerImpl;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedPlayer;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedTagManagerImpl;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NameplateManagerImpl
implements NameplateManager,
Listener {
    private final CustomNameplatesPlugin plugin;
    private final HashMap<String, Nameplate> nameplateMap;
    private final ConcurrentHashMap<UUID, CachedNameplate> cachedNameplateMap;
    private final ConcurrentHashMap<Integer, Entity> entityID2EntityMap;
    private final ConcurrentHashMap<UUID, NameplatePlayer> nameplatePlayerMap;
    private CancellableTask nameplateRefreshTask;
    private final TeamTagManagerImpl teamTagManager;
    private final UnlimitedTagManagerImpl unlimitedTagManager;
    private final EntityDestroyListener entityDestroyListener;
    private final EntitySpawnListener entitySpawnListener;
    private final EntityMoveListener entityMoveListener;
    private final EntityLookListener entityLookListener;
    private final EntityTeleportListener entityTeleportListener;
    private long teamRefreshFrequency;
    private String teamPrefix;
    private String teamSuffix;
    private boolean fixTab;
    private TagMode tagMode;
    private int previewDuration;
    private String defaultNameplate;
    private String playerName;
    private String prefix;
    private String suffix;
    private long refreshFrequency;
    private final List<DynamicTextTagSetting> tagSettings;

    public NameplateManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.nameplateMap = new HashMap();
        this.tagSettings = new ArrayList<DynamicTextTagSetting>();
        this.cachedNameplateMap = new ConcurrentHashMap();
        this.entityID2EntityMap = new ConcurrentHashMap();
        this.nameplatePlayerMap = new ConcurrentHashMap();
        this.teamTagManager = new TeamTagManagerImpl(this);
        this.unlimitedTagManager = new UnlimitedTagManagerImpl(this);
        this.entityTeleportListener = new EntityTeleportListener(this);
        this.entityDestroyListener = new EntityDestroyListener(this);
        this.entitySpawnListener = new EntitySpawnListener(this);
        this.entityLookListener = new EntityLookListener(this);
        this.entityMoveListener = new EntityMoveListener(this);
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void unload() {
        if (this.nameplateRefreshTask != null && !this.nameplateRefreshTask.isCancelled()) {
            this.nameplateRefreshTask.cancel();
        }
        this.nameplateMap.clear();
        this.tagSettings.clear();
        this.teamTagManager.unload();
        this.unlimitedTagManager.unload();
        HandlerList.unregisterAll((Listener)this);
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.entityDestroyListener);
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.entitySpawnListener);
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.entityLookListener);
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.entityMoveListener);
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.entityTeleportListener);
    }

    public void disable() {
        CNConfig.velocitab = false;
        this.unload();
    }

    public void load() {
        this.unlimitedTagManager.load();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.entityDestroyListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.entitySpawnListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.entityLookListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.entityMoveListener);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.entityTeleportListener);
        if (!CNConfig.nameplateModule) {
            return;
        }
        this.loadConfig();
        this.loadNameplates();
        this.teamTagManager.load(this.teamRefreshFrequency, this.fixTab);
        this.nameplateRefreshTask = this.plugin.getScheduler().runTaskAsyncTimer(() -> {
            for (OnlineUser user : this.plugin.getStorageManager().getOnlineUsers()) {
                this.updateCachedNameplate(user.getPlayer(), user.getNameplate());
            }
        }, this.refreshFrequency * 50L, this.refreshFrequency * 50L, TimeUnit.MILLISECONDS);
        for (Player online : Bukkit.getOnlinePlayers()) {
            this.createNameTag(online);
        }
    }

    private void loadConfig() {
        YamlConfiguration config = this.plugin.getConfig("configs" + File.separator + "nameplate.yml");
        this.tagMode = TagMode.valueOf(config.getString("mode", "TEAM").toUpperCase(Locale.ENGLISH));
        this.previewDuration = config.getInt("preview-duration", 5);
        this.defaultNameplate = config.getString("default-nameplate", "none");
        this.playerName = config.getString("nameplate.player-name", "%player_name%");
        this.prefix = config.getString("nameplate.prefix", "");
        this.suffix = config.getString("nameplate.suffix", "");
        this.refreshFrequency = config.getInt("nameplate.refresh-frequency", 10);
        this.teamPrefix = config.getString("team.prefix", "");
        this.teamSuffix = config.getString("team.suffix", "");
        this.teamRefreshFrequency = config.getInt("team.refresh-frequency", 10);
        this.fixTab = config.getBoolean("team.fix-Tab", false);
        ConfigurationSection unlimitedSection = config.getConfigurationSection("unlimited");
        if (unlimitedSection != null) {
            for (Map.Entry entry : unlimitedSection.getValues(false).entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof ConfigurationSection)) continue;
                ConfigurationSection innerSection = (ConfigurationSection)v;
                this.tagSettings.add(DynamicTextTagSetting.builder().rawText(innerSection.getString("text", "")).refreshFrequency(innerSection.getInt("refresh-frequency", 20)).checkFrequency(innerSection.getInt("check-frequency", 20)).verticalOffset(innerSection.getDouble("vertical-offset", -1.0)).ownerRequirements(this.plugin.getRequirementManager().getRequirements(innerSection.getConfigurationSection("owner-conditions"))).viewerRequirements(this.plugin.getRequirementManager().getRequirements(innerSection.getConfigurationSection("viewer-conditions"))).build());
            }
        }
    }

    private void loadNameplates() {
        File[] npConfigFiles;
        File npFolder = new File(this.plugin.getDataFolder(), "contents" + File.separator + "nameplates");
        if (!npFolder.exists() && npFolder.mkdirs()) {
            this.saveDefaultNameplates();
        }
        if ((npConfigFiles = npFolder.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(npConfigFiles, Comparator.comparing(File::getName));
        for (File npConfigFile : npConfigFiles) {
            String key = npConfigFile.getName().substring(0, npConfigFile.getName().length() - 4);
            if (key.equals("none")) {
                LogUtils.severe("You can't use 'none' as nameplate's key");
                continue;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)npConfigFile);
            if (this.registerNameplate(key, Nameplate.builder().displayName(config.getString("display-name", key)).teamColor(TeamColor.valueOf(config.getString("name-color", "none").toUpperCase(Locale.ENGLISH))).namePrefix(config.getString("name-prefix", "")).nameSuffix(config.getString("name-suffix", "")).left(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("left.image", key + "_left")).height(config.getInt("left.height", 16)).ascent(config.getInt("left.ascent", 12)).width(config.getInt("left.width", 16)).build()).right(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("right.image", key + "_right")).height(config.getInt("right.height", 16)).ascent(config.getInt("right.ascent", 12)).width(config.getInt("right.width", 16)).build()).middle(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.image", key + "_middle")).height(config.getInt("middle.height", 16)).ascent(config.getInt("middle.ascent", 12)).width(config.getInt("middle.width", 16)).build()).build())) continue;
            LogUtils.warn("Found duplicated nameplate: " + key);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onDataLoaded(NameplateDataLoadEvent event) {
        if (!CNConfig.nameplateModule) {
            return;
        }
        OnlineUser data = event.getOnlineUser();
        String nameplate = data.getNameplateKey();
        if (nameplate.equals("none")) {
            nameplate = this.defaultNameplate;
        }
        if (!nameplate.equals("none") && !this.containsNameplate(nameplate)) {
            if (nameplate.equals(this.defaultNameplate)) {
                LogUtils.severe("Default nameplate doesn't exist");
                return;
            }
            LogUtils.severe("Nameplate " + nameplate + " doesn't exist. To prevent bugs, player " + event.getUUID() + " 's nameplate data is reset");
            data.setNameplate("none");
            this.plugin.getStorageManager().saveOnlinePlayerData(event.getUUID());
            return;
        }
        Nameplate np = this.getNameplate(nameplate);
        CachedNameplate cachedNameplate = new CachedNameplate();
        this.putCachedNameplateToMap(event.getUUID(), cachedNameplate);
        this.updateCachedNameplate(cachedNameplate, data.getPlayer(), np);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.putEntityIDToMap(player.getEntityId(), (Entity)player);
        if (CNConfig.nameplateModule) {
            if (!CNConfig.isOtherTeamPluginHooked() && !this.isProxyMode()) {
                this.plugin.getTeamManager().createTeam(player);
            }
            this.plugin.getScheduler().runTaskAsyncLater(() -> {
                if (player.isOnline()) {
                    this.createNameTag(player);
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeEntityIDFromMap(player.getEntityId());
        this.teamTagManager.handlePlayerQuit(player);
        this.unlimitedTagManager.handlePlayerQuit(player);
        if (CNConfig.nameplateModule) {
            this.removeCachedNameplateFromMap(player.getUniqueId());
            if (!CNConfig.isOtherTeamPluginHooked() && !this.isProxyMode()) {
                this.plugin.getTeamManager().removeTeam(player);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        this.unlimitedTagManager.handlePlayerSneak(player, event.isSneaking(), player.isFlying());
    }

    @EventHandler(ignoreCancelled=true)
    public void onChangePose(EntityPoseChangeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.unlimitedTagManager.handlePlayerPose(player, event.getPose());
        }
    }

    @Override
    public boolean putEntityIDToMap(int entityID, @NotNull Entity entity) {
        if (this.entityID2EntityMap.containsKey(entityID)) {
            return false;
        }
        this.entityID2EntityMap.put(entityID, entity);
        return true;
    }

    @Override
    public Entity removeEntityIDFromMap(int entityID) {
        return this.entityID2EntityMap.remove(entityID);
    }

    @Override
    public boolean putCachedNameplateToMap(@NotNull UUID uuid, @NotNull CachedNameplate nameplate) {
        if (this.cachedNameplateMap.containsKey(uuid)) {
            return false;
        }
        this.cachedNameplateMap.put(uuid, nameplate);
        return true;
    }

    @Override
    public CachedNameplate removeCachedNameplateFromMap(@NotNull UUID uuid) {
        return this.cachedNameplateMap.remove(uuid);
    }

    @Override
    public Player getPlayerByEntityID(int id) {
        Entity entity = this.entityID2EntityMap.get(id);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    @Override
    public Entity getEntityByEntityID(int id) {
        return this.entityID2EntityMap.get(id);
    }

    @Override
    public boolean updateCachedNameplate(@NotNull Player player) {
        Optional<OnlineUser> onlineUser = this.plugin.getStorageManager().getOnlineUser(player.getUniqueId());
        if (onlineUser.isEmpty()) {
            return false;
        }
        Nameplate nameplate = onlineUser.get().getNameplate();
        return this.updateCachedNameplate(player, nameplate);
    }

    @Override
    public boolean updateCachedNameplate(@NotNull Player player, Nameplate nameplate) {
        CachedNameplate cachedNameplate = this.cachedNameplateMap.get(player.getUniqueId());
        if (cachedNameplate == null) {
            return false;
        }
        return this.updateCachedNameplate(cachedNameplate, player, nameplate);
    }

    @Override
    public CachedNameplate getCacheNameplate(@NotNull Player player) {
        return this.cachedNameplateMap.get(player.getUniqueId());
    }

    @Override
    public NameplatePlayer createNameTag(@NotNull Player player) {
        if (this.tagMode == TagMode.TEAM) {
            TeamPlayer nameplatePlayer = this.teamTagManager.createTagForPlayer(player, this.teamPrefix, this.teamSuffix);
            this.putNameplatePlayerToMap(nameplatePlayer);
            this.unlimitedTagManager.createOrGetTagForPlayer(player);
            return nameplatePlayer;
        }
        if (this.tagMode == TagMode.UNLIMITED) {
            UnlimitedPlayer tagPlayer = this.unlimitedTagManager.createOrGetTagForPlayer(player);
            for (DynamicTextTagSetting setting : this.tagSettings) {
                tagPlayer.addTag(setting);
            }
            this.putNameplatePlayerToMap(tagPlayer);
            return tagPlayer;
        }
        this.unlimitedTagManager.createOrGetTagForPlayer(player);
        return null;
    }

    @Override
    public void putNameplatePlayerToMap(@NotNull NameplatePlayer player) {
        this.nameplatePlayerMap.put(player.getPlayer().getUniqueId(), player);
    }

    @Override
    public NameplatePlayer getNameplatePlayer(@NotNull UUID uuid) {
        return this.nameplatePlayerMap.get(uuid);
    }

    @Override
    public NameplatePlayer removeNameplatePlayerFromMap(@NotNull UUID uuid) {
        return this.nameplatePlayerMap.remove(uuid);
    }

    private boolean updateCachedNameplate(CachedNameplate cachedNameplate, Player player, Nameplate nameplate) {
        String parsePrefix = PlaceholderAPI.setPlaceholders((Player)player, (String)this.prefix);
        String parseName = PlaceholderAPI.setPlaceholders((Player)player, (String)this.playerName);
        String parseSuffix = PlaceholderAPI.setPlaceholders((Player)player, (String)this.suffix);
        if (nameplate != null) {
            int width = FontUtils.getTextWidth(parsePrefix + nameplate.getNamePrefix() + parseName + nameplate.getNameSuffix() + parseSuffix);
            cachedNameplate.setTeamColor(nameplate.getTeamColor());
            cachedNameplate.setNamePrefix(nameplate.getNamePrefix());
            cachedNameplate.setNameSuffix(nameplate.getNameSuffix());
            cachedNameplate.setTagSuffix(parseSuffix + nameplate.getSuffixWithFont(width));
            cachedNameplate.setTagPrefix(nameplate.getPrefixWithFont(width) + parsePrefix);
        } else {
            cachedNameplate.setTeamColor(TeamColor.WHITE);
            cachedNameplate.setNamePrefix("");
            cachedNameplate.setNameSuffix("");
            cachedNameplate.setTagPrefix(parsePrefix);
            cachedNameplate.setTagSuffix(parseSuffix);
        }
        cachedNameplate.setPlayerName(parseName);
        return true;
    }

    @Override
    @NotNull
    public String getNameplatePrefix(@NotNull Player player) {
        CachedNameplate cachedNameplate = this.cachedNameplateMap.get(player.getUniqueId());
        if (cachedNameplate == null) {
            return "";
        }
        return cachedNameplate.getTagPrefix();
    }

    @Override
    @NotNull
    public String getNameplateSuffix(@NotNull Player player) {
        CachedNameplate cachedNameplate = this.cachedNameplateMap.get(player.getUniqueId());
        if (cachedNameplate == null) {
            return "";
        }
        return cachedNameplate.getTagSuffix();
    }

    @Override
    @NotNull
    public String getFullNameTag(@NotNull Player player) {
        CachedNameplate cachedNameplate = this.cachedNameplateMap.get(player.getUniqueId());
        if (cachedNameplate == null) {
            return player.getName();
        }
        return cachedNameplate.getNamePrefix() + cachedNameplate.getTagPrefix() + cachedNameplate.getPlayerName() + cachedNameplate.getTagSuffix() + cachedNameplate.getNameSuffix();
    }

    @Override
    @NotNull
    public List<String> getAvailableNameplates(@NotNull Player player) {
        ArrayList<String> nameplates = new ArrayList<String>();
        for (String nameplate : this.nameplateMap.keySet()) {
            if (!this.hasNameplate(player, nameplate)) continue;
            nameplates.add(nameplate);
        }
        return nameplates;
    }

    @Override
    @NotNull
    public List<String> getAvailableNameplateDisplayNames(@NotNull Player player) {
        ArrayList<String> nameplates = new ArrayList<String>();
        for (Map.Entry<String, Nameplate> entry : this.nameplateMap.entrySet()) {
            if (!this.hasNameplate(player, entry.getKey())) continue;
            nameplates.add(entry.getValue().getDisplayName());
        }
        return nameplates;
    }

    @Override
    public boolean equipNameplate(@NotNull Player player, @NotNull String nameplateKey, boolean temp) {
        Nameplate nameplate = this.getNameplate(nameplateKey);
        if (nameplate == null && nameplateKey.equals("none")) {
            return false;
        }
        this.plugin.getStorageManager().getOnlineUser(player.getUniqueId()).ifPresentOrElse(it -> {
            if (it.getNameplateKey().equals(nameplateKey)) {
                return;
            }
            it.setNameplate(nameplateKey);
            this.updateCachedNameplate(player, nameplate);
            NameplatePlayer nameplatePlayer = this.getNameplatePlayer(player.getUniqueId());
            if (nameplatePlayer != null) {
                nameplatePlayer.updateText();
            }
            if (!temp) {
                this.plugin.getStorageManager().saveOnlinePlayerData(player.getUniqueId());
            }
        }, () -> LogUtils.severe("Player " + player.getName() + "'s data is not loaded."));
        return true;
    }

    @Override
    public void unEquipNameplate(Player player, boolean temp) {
        this.plugin.getStorageManager().getOnlineUser(player.getUniqueId()).ifPresentOrElse(it -> {
            if (it.getNameplateKey().equals("none")) {
                return;
            }
            it.setNameplate("none");
            this.updateCachedNameplate(player, this.getNameplate(this.getDefaultNameplate()));
            NameplatePlayer nameplatePlayer = this.getNameplatePlayer(player.getUniqueId());
            if (nameplatePlayer != null) {
                nameplatePlayer.updateText();
            }
            if (!temp) {
                this.plugin.getStorageManager().saveOnlinePlayerData(player.getUniqueId());
            }
        }, () -> LogUtils.severe("Player " + player.getName() + "'s data is not loaded."));
    }

    private void saveDefaultNameplates() {
        String[] png_list = new String[]{"cat", "egg", "cheems", "wither", "xmas", "halloween", "hutao", "starsky", "trident", "rabbit"};
        String[] part_list = new String[]{"_left.png", "_middle.png", "_right.png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "nameplates" + File.separator + name + part, false);
            }
        }
    }

    @Override
    public boolean registerNameplate(@NotNull String key, @NotNull Nameplate nameplate) {
        if (this.nameplateMap.containsKey(key)) {
            return false;
        }
        this.nameplateMap.put(key, nameplate);
        return true;
    }

    @Override
    public boolean unregisterNameplate(@NotNull String key) {
        return this.nameplateMap.remove(key) != null;
    }

    @Override
    public boolean isProxyMode() {
        return CNConfig.velocitab;
    }

    @Override
    public int getPreviewDuration() {
        return this.previewDuration;
    }

    @Override
    @NotNull
    public TagMode getTagMode() {
        return this.tagMode;
    }

    @Override
    @NotNull
    public Nameplate getNameplate(@NotNull String key) {
        return this.nameplateMap.get(key);
    }

    @Override
    @NotNull
    public Collection<Nameplate> getNameplates() {
        return this.nameplateMap.values();
    }

    @Override
    @NotNull
    public Collection<String> getNameplateKeys() {
        return this.nameplateMap.keySet();
    }

    @Override
    public boolean containsNameplate(@NotNull String key) {
        return this.nameplateMap.containsKey(key);
    }

    @Override
    public boolean hasNameplate(@NotNull Player player, @NotNull String nameplate) {
        return player.hasPermission("nameplates.equip." + nameplate);
    }

    @Override
    @NotNull
    public TeamColor getTeamColor(@NotNull Player player) {
        CachedNameplate nameplate = this.getCacheNameplate(player);
        return nameplate == null ? TeamColor.WHITE : nameplate.getTeamColor();
    }

    @Override
    @NotNull
    public String getDefaultNameplate() {
        return this.defaultNameplate;
    }

    @Override
    @NotNull
    public TeamTagManager getTeamTagManager() {
        return this.teamTagManager;
    }

    @Override
    @NotNull
    public UnlimitedTagManager getUnlimitedTagManager() {
        return this.unlimitedTagManager;
    }

    public void onEntityMove(Player receiver, int entityID, short x, short y, short z, boolean onGround) {
        this.unlimitedTagManager.handleEntityMovePacket(receiver, entityID, x, y, z, onGround);
    }

    public void onEntityDestroy(Player receiver, List<Integer> list) {
        this.teamTagManager.handleEntityDestroyPacket(receiver, list);
        this.unlimitedTagManager.handleEntityDestroyPacket(receiver, list);
    }

    public void onEntitySpawn(Player receiver, int entityID) {
        this.teamTagManager.handleEntitySpawnPacket(receiver, entityID);
        this.unlimitedTagManager.handleEntitySpawnPacket(receiver, entityID);
    }

    public void onEntityTeleport(Player receiver, int entityID, double x, double y, double z, boolean onGround) {
        this.unlimitedTagManager.handleEntityTeleportPacket(receiver, entityID, x, y, z, onGround);
    }
}

