/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamTagManagerImpl;
import org.bukkit.plugin.Plugin;

public class PlayerInfoListener
extends PacketAdapter {
    private final TeamTagManagerImpl manager;

    public PlayerInfoListener(TeamTagManagerImpl manager) {
        super((Plugin)CustomNameplatesPlugin.getInstance(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.PLAYER_INFO});
        this.manager = manager;
    }

    public void onPacketSending(PacketEvent event) {
        PacketContainer packet = event.getPacket();
        Set actions = (Set)packet.getPlayerInfoActions().read(0);
        if (!actions.contains(EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME)) {
            return;
        }
        List list = (List)packet.getModifier().read(1);
        ArrayList<Object> newList = new ArrayList<Object>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object dataHandle = list.get(i);
            if (dataHandle == null) continue;
            PlayerInfoData data = (PlayerInfoData)PlayerInfoData.getConverter().getSpecific(dataHandle);
            WrappedGameProfile profile = data.getProfile();
            PlayerInfoData newData = new PlayerInfoData(profile, data.getLatency(), data.getGameMode(), WrappedChatComponent.fromJson((String)String.format("{\"text\":\"%s\"}", profile.getName())));
            newList.add(PlayerInfoData.getConverter().getGeneric((Object)newData));
        }
        packet.getModifier().write(1, newList);
    }
}

