/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team;

import java.util.Vector;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.TeamTagManager;
import net.momirealms.customnameplates.api.mechanic.misc.ViewerText;
import net.momirealms.customnameplates.api.mechanic.tag.team.TeamTagPlayer;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamPreviewSimpleEntity;
import org.bukkit.entity.Player;

public class TeamPlayer
implements TeamTagPlayer {
    private final TeamTagManager manager;
    private final Player owner;
    private ViewerText prefix;
    private ViewerText suffix;
    private final Vector<Player> nearbyPlayers;
    private boolean isPreviewing;
    private final TeamPreviewSimpleEntity previewEntity;

    public TeamPlayer(TeamTagManager manager, Player owner, String prefix, String suffix) {
        this.manager = manager;
        this.owner = owner;
        this.prefix = new ViewerText(owner, prefix);
        this.suffix = new ViewerText(owner, suffix);
        this.nearbyPlayers = new Vector();
        this.prefix.updateForOwner();
        this.suffix.updateForOwner();
        this.previewEntity = new TeamPreviewSimpleEntity(this);
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = new ViewerText(this.owner, prefix);
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = new ViewerText(this.owner, suffix);
    }

    @Override
    public ViewerText getPrefix() {
        return this.prefix;
    }

    @Override
    public ViewerText getSuffix() {
        return this.suffix;
    }

    public void updateForNearbyPlayers(boolean force) {
        this.prefix.updateForOwner();
        this.suffix.updateForOwner();
        for (Player viewer : this.nearbyPlayers) {
            this.updateForOne(viewer, force);
        }
        if (this.isPreviewing) {
            this.previewEntity.update();
        }
    }

    public void removeNearbyPlayer(Player player) {
        if (!this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.remove(player);
        this.removeForOne(player);
        this.prefix.removeViewer(player);
        this.suffix.removeViewer(player);
    }

    public void addNearbyPlayer(Player player) {
        if (this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.add(player);
        this.updateForOne(player, false);
    }

    @Override
    public void destroy() {
        this.manager.removeTeamPlayerFromMap(this.owner.getUniqueId());
        for (Player viewer : this.nearbyPlayers) {
            this.removeForOne(viewer);
        }
        this.nearbyPlayers.clear();
        this.previewEntity.destroy();
    }

    private void updateForOne(Player viewer, boolean force) {
        try {
            if (this.prefix.updateForViewer(viewer) | this.suffix.updateForViewer(viewer) || force) {
                CustomNameplatesPlugin.get().getTeamManager().updateTeam(this.owner, viewer, this.prefix.getLatestValue(viewer), this.suffix.getLatestValue(viewer), CustomNameplatesPlugin.get().getNameplateManager().getTeamColor(this.owner), TeamTagVisibility.ALWAYS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeForOne(Player viewer) {
        CustomNameplatesPlugin.get().getTeamManager().updateTeam(this.owner, viewer, "", "", TeamColor.WHITE, TeamTagVisibility.ALWAYS);
    }

    @Override
    public void setPreview(boolean preview) {
        if (this.isPreviewing == preview) {
            return;
        }
        this.isPreviewing = preview;
        if (this.isPreviewing) {
            this.previewEntity.spawn();
        } else {
            this.previewEntity.destroy();
        }
    }

    @Override
    public boolean isPreviewing() {
        return this.isPreviewing;
    }

    @Override
    public Player getPlayer() {
        return this.owner;
    }

    @Override
    public void updateText() {
        this.updateForNearbyPlayers(false);
        if (this.isPreviewing) {
            this.previewEntity.update();
        }
    }
}

