/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.RequirementManager;
import net.momirealms.customnameplates.api.mechanic.misc.ViewerText;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextEntity;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedPlayer;
import net.momirealms.customnameplates.paper.util.FakeEntityUtils;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class DynamicTextEntityImpl
implements DynamicTextEntity {
    private final UUID uuid = UUID.randomUUID();
    private final UnlimitedPlayer owner;
    private double yOffset;
    private final int entityId = FakeEntityUtils.getAndIncrease();
    private final ViewerText viewerText;
    private final Requirement[] ownerRequirements;
    private final Requirement[] viewerRequirements;
    private final Vector<Player> viewers;
    private final int refreshFrequency;
    private final int checkFrequency;
    private int checkTimer;
    private int refreshTimer;
    private boolean ownerCanShow;
    private final PacketContainer destroyPacket;

    public DynamicTextEntityImpl(UnlimitedPlayer unlimitedPlayer, ViewerText text, int refreshFrequency, int checkFrequency, double yOffset, Requirement[] ownerRequirements, Requirement[] viewerRequirements) {
        this.owner = unlimitedPlayer;
        this.yOffset = yOffset;
        this.viewerText = text;
        this.ownerRequirements = ownerRequirements;
        this.viewerRequirements = viewerRequirements;
        this.checkFrequency = checkFrequency;
        this.refreshFrequency = refreshFrequency;
        this.viewers = new Vector();
        this.ownerCanShow = RequirementManager.isRequirementMet(new Condition((OfflinePlayer)this.owner.getPlayer()), ownerRequirements);
        this.destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        this.destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(this.entityId)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicTextEntityImpl that = (DynamicTextEntityImpl)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean canShow() {
        return this.ownerCanShow;
    }

    @Override
    public boolean isShownTo(Player viewer) {
        return this.viewers.contains(viewer);
    }

    @Override
    public boolean canSee(Player viewer) {
        Condition condition = new Condition((OfflinePlayer)viewer);
        return RequirementManager.isRequirementMet(condition, this.viewerRequirements);
    }

    @Override
    public void timer() {
        if (this.owner.isPreviewing()) {
            Location location = this.owner.getPlayer().getLocation();
            this.teleport(this.owner.getPlayer(), location.getX(), location.getY(), location.getZ(), false);
        }
        ++this.checkTimer;
        if (this.checkTimer >= this.checkFrequency) {
            this.checkTimer = 0;
            if (!RequirementManager.isRequirementMet(new Condition((OfflinePlayer)this.owner.getPlayer()), this.ownerRequirements)) {
                this.ownerCanShow = false;
                for (Player all : this.owner.getNearbyPlayers()) {
                    this.removePlayerFromViewers(all);
                }
            } else {
                this.ownerCanShow = true;
                for (Player all : this.owner.getNearbyPlayers()) {
                    if (this.canSee(all)) {
                        this.addPlayerToViewers(all);
                        continue;
                    }
                    this.removePlayerFromViewers(all);
                }
            }
        }
        ++this.refreshTimer;
        if (this.refreshTimer >= this.refreshFrequency) {
            this.refreshTimer = 0;
            this.viewerText.updateForOwner();
            this.updateText();
        }
    }

    @Override
    public void removePlayerFromViewers(Player player) {
        if (!this.viewers.contains(player)) {
            return;
        }
        this.viewers.remove(player);
        this.destroy(player);
    }

    @Override
    public void addPlayerToViewers(Player player) {
        if (this.viewers.contains(player)) {
            return;
        }
        this.viewers.add(player);
        this.spawn(player, this.owner.getPlayer().getPose());
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, this.getTeleportPacket(0.0));
        }
    }

    @Override
    public ViewerText getViewerText() {
        return this.viewerText;
    }

    @Override
    public void spawn(Player viewer, Pose pose) {
        if (this.viewerText.updateForViewer(viewer)) {
            PacketManager.getInstance().send(viewer, this.getSpawnPackets(this.viewerText.getLatestValue(viewer), pose));
        }
    }

    @Override
    public void spawn(Pose pose) {
        for (Player all : this.viewers) {
            this.spawn(all, pose);
        }
    }

    @Override
    public void destroy() {
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, this.destroyPacket);
        }
        this.viewerText.clear();
        this.viewers.clear();
    }

    @Override
    public void destroy(Player viewer) {
        PacketManager.getInstance().send(viewer, this.destroyPacket);
        this.viewerText.removeViewer(viewer);
    }

    @Override
    public void teleport(double x, double y, double z, boolean onGround) {
        PacketContainer packet = this.getTeleportPacket(x, y, z, onGround);
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, packet);
        }
    }

    @Override
    public void teleport() {
        PacketContainer packet = this.getTeleportPacket(this.getCorrection(this.owner.getPlayer().getPose()));
        for (Player viewer : this.viewers) {
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public void teleport(Player viewer, double x, double y, double z, boolean onGround) {
        if (this.viewers.contains(viewer)) {
            PacketManager.getInstance().send(viewer, this.getTeleportPacket(x, y, z, onGround));
        }
    }

    @Override
    public void setSneak(boolean isSneaking, boolean onGround) {
        if (!onGround) {
            for (Player viewer : this.viewers) {
                PacketManager.getInstance().send(viewer, FakeEntityUtils.getMetaPacket(this.entityId, this.viewerText.getLatestValue(viewer), isSneaking));
            }
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void move(short x, short y, short z, boolean onGround) {
        PacketContainer packet = this.getMovePacket(x, y, z, onGround);
        for (Player viewer : this.viewers) {
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public void move(Player viewer, short x, short y, short z, boolean onGround) {
        if (this.viewers.contains(viewer)) {
            PacketContainer packet = this.getMovePacket(x, y, z, onGround);
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public void respawn(Player viewer, Pose pose) {
        this.destroy(viewer);
        this.spawn(viewer, pose);
    }

    @Override
    public void respawn(Pose pose) {
        for (Player viewer : this.viewers) {
            this.respawn(viewer, pose);
        }
    }

    @Override
    public void updateText() {
        for (Player viewer : this.viewers) {
            this.updateText(viewer);
        }
    }

    @Override
    public void updateText(Player viewer) {
        if (this.viewerText.updateForViewer(viewer)) {
            PacketManager.getInstance().send(viewer, FakeEntityUtils.getMetaPacket(this.entityId, this.viewerText.getLatestValue(viewer), this.owner.getPlayer().isSneaking()));
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void handlePose(Pose previous, Pose pose) {
        CustomNameplatesPlugin.get().getScheduler().runTaskAsyncLater(() -> {
            for (Player viewer : this.viewers) {
                this.respawn(viewer, pose);
            }
        }, 20L, TimeUnit.MILLISECONDS);
    }

    public PacketContainer getMovePacket(short x, short y, short z, boolean onGround) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
        packet.getIntegers().write(0, (Object)this.entityId);
        packet.getShorts().write(0, (Object)x);
        packet.getShorts().write(1, (Object)y);
        packet.getShorts().write(2, (Object)z);
        packet.getBooleans().write(0, (Object)onGround);
        return packet;
    }

    public PacketContainer getTeleportPacket(double x, double y, double z, boolean onGround) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        packet.getDoubles().write(0, (Object)x);
        packet.getDoubles().write(1, (Object)(y + this.owner.getHatOffset() + this.getCorrection(this.owner.getPlayer().getPose()) + this.yOffset));
        packet.getDoubles().write(2, (Object)z);
        packet.getBooleans().write(0, (Object)onGround);
        return packet;
    }

    public PacketContainer getTeleportPacket(double correction) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        Location location = this.getEntityLocation(correction);
        packet.getDoubles().write(0, (Object)location.getX());
        packet.getDoubles().write(1, (Object)location.getY());
        packet.getDoubles().write(2, (Object)location.getZ());
        return packet;
    }

    private Location getEntityLocation(double correction) {
        Player player = this.owner.getPlayer();
        double x = player.getLocation().getX();
        double y = player.getLocation().getY();
        double z = player.getLocation().getZ();
        y += this.yOffset;
        y += this.owner.getHatOffset();
        return new Location(null, x, y += correction, z);
    }

    private PacketContainer[] getSpawnPackets(String text, Pose pose) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)this.entityId);
        entityPacket.getModifier().write(1, (Object)this.uuid);
        entityPacket.getEntityTypeModifier().write(0, (Object)EntityType.ARMOR_STAND);
        Location location = this.getEntityLocation(this.getCorrection(pose));
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)location.getY());
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        PacketContainer metaPacket = FakeEntityUtils.getMetaPacket(this.entityId, text, pose == Pose.SNEAKING);
        return new PacketContainer[]{entityPacket, metaPacket};
    }

    private double getCorrection(Pose pose) {
        return switch (pose) {
            case Pose.STANDING -> 1.8;
            case Pose.SNEAKING -> 1.5;
            case Pose.SLEEPING -> 0.2;
            case Pose.SWIMMING, Pose.FALL_FLYING, Pose.SPIN_ATTACK -> 0.55;
            default -> 0.0;
        };
    }
}

