/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.NearbyRule;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextEntity;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedEntity;
import net.momirealms.customnameplates.paper.util.FakeEntityUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class StaticTextEntityImpl
implements StaticTextEntity {
    private final UUID uuid = UUID.randomUUID();
    private final UnlimitedEntity owner;
    private double yOffset;
    private final int entityId = FakeEntityUtils.getAndIncrease();
    private final Vector<Player> viewers;
    private final ConcurrentHashMap<UUID, String> textCache;
    private final NearbyRule comeRule;
    private final NearbyRule leaveRule;
    private String defaultText;
    private final String plugin;
    private final PacketContainer destroyPacket;

    public StaticTextEntityImpl(UnlimitedEntity owner, double yOffset, NearbyRule comeRule, NearbyRule leaveRule, String defaultText, String plugin) {
        this.owner = owner;
        this.yOffset = yOffset;
        this.viewers = new Vector();
        this.textCache = new ConcurrentHashMap();
        this.comeRule = comeRule;
        this.leaveRule = leaveRule;
        this.defaultText = defaultText;
        this.plugin = plugin;
        this.destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        this.destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(this.entityId)));
    }

    @Override
    public String getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticTextEntityImpl that = (StaticTextEntityImpl)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean isShownTo(Player viewer) {
        return this.viewers.contains(viewer);
    }

    @Override
    public NearbyRule getComeRule() {
        return this.comeRule;
    }

    @Override
    public NearbyRule getLeaveRule() {
        return this.leaveRule;
    }

    @Override
    public void removePlayerFromViewers(Player player) {
        if (!this.viewers.contains(player)) {
            return;
        }
        this.viewers.remove(player);
        this.destroy(player);
    }

    @Override
    public void addPlayerToViewers(Player player) {
        if (this.viewers.contains(player)) {
            return;
        }
        this.viewers.add(player);
        this.spawn(player, this.owner.getEntity().getPose());
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, this.getTeleportPacket());
        }
    }

    @Override
    public void setText(String text) {
        if (text.equals(this.defaultText)) {
            return;
        }
        this.defaultText = text;
        for (Player viewer : this.viewers) {
            PacketManager.getInstance().send(viewer, FakeEntityUtils.getMetaPacket(this.entityId, this.getText(viewer), this.owner.getEntity().isSneaking()));
        }
    }

    @Override
    public String getText(Player viewer) {
        return this.textCache.getOrDefault(viewer.getUniqueId(), this.defaultText);
    }

    @Override
    public void setText(Player viewer, String text) {
        String previous = this.textCache.put(viewer.getUniqueId(), text);
        if (previous != null && previous.equals(text)) {
            return;
        }
        PacketManager.getInstance().send(viewer, FakeEntityUtils.getMetaPacket(this.entityId, text, this.owner.getEntity().isSneaking()));
    }

    @Override
    public void removeText(Player viewer) {
        String previous = this.textCache.remove(viewer.getUniqueId());
        if (previous != null && previous.equals(this.defaultText)) {
            return;
        }
        PacketManager.getInstance().send(viewer, FakeEntityUtils.getMetaPacket(this.entityId, this.defaultText, this.owner.getEntity().isSneaking()));
    }

    @Override
    public void spawn(Player viewer, Pose pose) {
        PacketManager.getInstance().send(viewer, this.getSpawnPackets(this.getText(viewer), pose));
    }

    @Override
    public void destroy() {
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, this.destroyPacket);
        }
        this.viewers.clear();
        this.textCache.clear();
    }

    @Override
    public void destroy(Player viewer) {
        PacketManager.getInstance().send(viewer, this.destroyPacket);
        this.textCache.remove(viewer.getUniqueId());
    }

    @Override
    public void teleport(double x, double y, double z, boolean onGround) {
        PacketContainer packet = this.getTeleportPacket(x, y, z, onGround);
        for (Player all : this.viewers) {
            PacketManager.getInstance().send(all, packet);
        }
    }

    @Override
    public void teleport(Player viewer, double x, double y, double z, boolean onGround) {
        if (this.viewers.contains(viewer)) {
            PacketManager.getInstance().send(viewer, this.getTeleportPacket(x, y, z, onGround));
        }
    }

    @Override
    public void teleport() {
        PacketContainer packet = this.getTeleportPacket();
        for (Player viewer : this.viewers) {
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void move(short x, short y, short z, boolean onGround) {
        PacketContainer packet = this.getMovePacket(x, y, z, onGround);
        for (Player viewer : this.viewers) {
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public void move(Player viewer, short x, short y, short z, boolean onGround) {
        if (this.viewers.contains(viewer)) {
            PacketContainer packet = this.getMovePacket(x, y, z, onGround);
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    @Override
    public void respawn(Player viewer, Pose pose) {
        this.destroy(viewer);
        this.spawn(viewer, pose);
    }

    @Override
    public void respawn(Pose pose) {
        for (Player viewer : this.viewers) {
            this.respawn(viewer, pose);
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void handlePose(Pose previous, Pose pose) {
        CustomNameplatesPlugin.get().getScheduler().runTaskAsyncLater(() -> {
            for (Player viewer : this.viewers) {
                this.respawn(viewer, pose);
            }
        }, 20L, TimeUnit.MILLISECONDS);
    }

    public PacketContainer getMovePacket(short x, short y, short z, boolean onGround) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
        packet.getIntegers().write(0, (Object)this.entityId);
        packet.getShorts().write(0, (Object)x);
        packet.getShorts().write(1, (Object)y);
        packet.getShorts().write(2, (Object)z);
        packet.getBooleans().write(0, (Object)onGround);
        return packet;
    }

    public PacketContainer getTeleportPacket(double x, double y, double z, boolean onGround) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        packet.getDoubles().write(0, (Object)x);
        packet.getDoubles().write(1, (Object)(y + this.yOffset));
        packet.getDoubles().write(2, (Object)z);
        packet.getBooleans().write(0, (Object)onGround);
        return packet;
    }

    public PacketContainer getTeleportPacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        Location location = this.getEntityLocation();
        packet.getDoubles().write(0, (Object)location.getX());
        packet.getDoubles().write(1, (Object)location.getY());
        packet.getDoubles().write(2, (Object)location.getZ());
        return packet;
    }

    private Location getEntityLocation() {
        Entity entity = this.owner.getEntity();
        double x = entity.getLocation().getX();
        double y = entity.getLocation().getY();
        double z = entity.getLocation().getZ();
        return new Location(null, x, y += this.yOffset, z);
    }

    private PacketContainer[] getSpawnPackets(String text, Pose pose) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)this.entityId);
        entityPacket.getModifier().write(1, (Object)this.uuid);
        entityPacket.getEntityTypeModifier().write(0, (Object)EntityType.ARMOR_STAND);
        Location location = this.getEntityLocation();
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)(location.getY() + (pose == Pose.SNEAKING ? -0.3 : 0.0)));
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        PacketContainer metaPacket = FakeEntityUtils.getMetaPacket(this.entityId, text, pose == Pose.SNEAKING);
        return new PacketContainer[]{entityPacket, metaPacket};
    }
}

