/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.api.data.DataStorageInterface;
import net.momirealms.customnameplates.api.data.OnlineUser;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.event.NameplateDataLoadEvent;
import net.momirealms.customnameplates.api.manager.StorageManager;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.storage.method.database.nosql.MongoDBImpl;
import net.momirealms.customnameplates.paper.storage.method.database.nosql.RedisManager;
import net.momirealms.customnameplates.paper.storage.method.database.sql.H2Impl;
import net.momirealms.customnameplates.paper.storage.method.database.sql.MariaDBImpl;
import net.momirealms.customnameplates.paper.storage.method.database.sql.MySQLImpl;
import net.momirealms.customnameplates.paper.storage.method.database.sql.SQLiteImpl;
import net.momirealms.customnameplates.paper.storage.method.file.JsonImpl;
import net.momirealms.customnameplates.paper.storage.method.file.YAMLImpl;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageManagerImpl
implements Listener,
StorageManager {
    private final CustomNameplatesPluginImpl plugin;
    private DataStorageInterface dataSource;
    private StorageType previousType;
    private boolean hasRedis;
    private RedisManager redisManager;
    private final Gson gson;
    private final ConcurrentHashMap<UUID, OnlineUser> onlineUserMap;

    public StorageManagerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().create();
        this.onlineUserMap = new ConcurrentHashMap(64);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.getPlayerData(uuid).thenAccept(optData -> {
            if (optData.isPresent()) {
                PlayerData playerData = (PlayerData)optData.get();
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null || !player.isOnline()) {
                    return;
                }
                OnlineUser onlineUser = new OnlineUser(player, playerData);
                this.putOnlineUserInMap(onlineUser);
                NameplateDataLoadEvent syncEvent = new NameplateDataLoadEvent(uuid, onlineUser);
                this.plugin.getServer().getPluginManager().callEvent((Event)syncEvent);
            }
        });
    }

    @Override
    public Collection<OnlineUser> getOnlineUsers() {
        return this.onlineUserMap.values();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeOnlineUserFromMap(event.getPlayer().getUniqueId());
    }

    public void putOnlineUserInMap(OnlineUser onlineUser) {
        this.onlineUserMap.put(onlineUser.getUUID(), onlineUser);
    }

    public void removeOnlineUserFromMap(UUID uuid) {
        this.onlineUserMap.remove(uuid);
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        OnlineUser onlineUser = this.onlineUserMap.get(uuid);
        if (onlineUser != null) {
            return CompletableFuture.completedFuture(Optional.of(onlineUser.toPlayerData()));
        }
        if (this.hasRedis) {
            return this.redisManager.getPlayerData(uuid).thenCompose(result -> {
                if (result.isEmpty()) {
                    return this.dataSource.getPlayerData(uuid);
                }
                return CompletableFuture.completedFuture(result);
            });
        }
        return this.dataSource.getPlayerData(uuid);
    }

    @Override
    public CompletableFuture<Boolean> saveOnlinePlayerData(UUID uuid) {
        OnlineUser onlineUser = this.onlineUserMap.get(uuid);
        if (onlineUser == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.savePlayerData(uuid, onlineUser.toPlayerData());
    }

    @Override
    public CompletableFuture<Boolean> savePlayerData(UUID uuid, PlayerData playerData) {
        if (this.hasRedis) {
            return this.redisManager.updatePlayerData(uuid, playerData).thenCompose(result -> {
                if (!result.booleanValue()) {
                    return CompletableFuture.completedFuture(false);
                }
                return this.dataSource.updatePlayerData(uuid, playerData);
            });
        }
        return this.dataSource.updatePlayerData(uuid, playerData);
    }

    @Override
    public Optional<OnlineUser> getOnlineUser(UUID uuid) {
        return Optional.ofNullable(this.onlineUserMap.get(uuid));
    }

    public void reload() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        StorageType storageType = StorageType.valueOf(config.getString("data-storage-method", "H2"));
        if (storageType != this.previousType) {
            if (this.dataSource != null) {
                this.dataSource.disable();
            }
            this.previousType = storageType;
            switch (storageType) {
                case H2: {
                    this.dataSource = new H2Impl(this.plugin);
                    break;
                }
                case JSON: {
                    this.dataSource = new JsonImpl(this.plugin);
                    break;
                }
                case YAML: {
                    this.dataSource = new YAMLImpl(this.plugin);
                    break;
                }
                case SQLite: {
                    this.dataSource = new SQLiteImpl(this.plugin);
                    break;
                }
                case MySQL: {
                    this.dataSource = new MySQLImpl(this.plugin);
                    break;
                }
                case MariaDB: {
                    this.dataSource = new MariaDBImpl(this.plugin);
                    break;
                }
                case MongoDB: {
                    this.dataSource = new MongoDBImpl(this.plugin);
                }
            }
            if (this.dataSource != null) {
                this.dataSource.initialize();
            } else {
                LogUtils.severe("No storage type is set.");
            }
        }
        if (!this.hasRedis && config.getBoolean("Redis.enable", false)) {
            this.hasRedis = true;
            this.redisManager = new RedisManager(this.plugin);
            this.redisManager.initialize();
        }
        if (this.hasRedis && !config.getBoolean("Redis.enable", false) && this.redisManager != null) {
            this.redisManager.disable();
            this.redisManager = null;
        }
    }

    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.dataSource != null) {
            this.dataSource.disable();
        }
        if (this.redisManager != null) {
            this.redisManager.disable();
        }
    }

    public boolean isRedisEnabled() {
        return this.hasRedis;
    }

    @Nullable
    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    @Override
    @NotNull
    public PlayerData fromJson(String json) {
        return (PlayerData)this.gson.fromJson(json, PlayerData.class);
    }

    @Override
    public PlayerData fromBytes(byte[] data) {
        try {
            return (PlayerData)this.gson.fromJson(new String(data, StandardCharsets.UTF_8), PlayerData.class);
        }
        catch (JsonSyntaxException e) {
            throw new DataSerializationException("Failed to get PlayerData from bytes", e);
        }
    }

    @Override
    public byte[] toBytes(PlayerData playerData) {
        return this.toJson(playerData).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    @NotNull
    public String toJson(@NotNull PlayerData playerData) {
        return this.gson.toJson((Object)playerData);
    }

    @Override
    public DataStorageInterface getDataSource() {
        return this.dataSource;
    }

    public static class DataSerializationException
    extends RuntimeException {
        protected DataSerializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

