/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.nosql;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.storage.method.AbstractStorage;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public class RedisManager
extends AbstractStorage {
    private static RedisManager instance;
    private JedisPool jedisPool;
    private String password;
    private int port;
    private String host;
    private boolean useSSL;

    public RedisManager(CustomNameplatesPluginImpl plugin) {
        super(plugin);
        instance = this;
    }

    public static RedisManager getInstance() {
        return instance;
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    @Override
    public Set<UUID> getUniqueUsers(boolean legacy) {
        return new HashSet<UUID>();
    }

    @Override
    public void initialize() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        ConfigurationSection section = config.getConfigurationSection("Redis");
        if (section == null) {
            LogUtils.warn("Failed to load database config. It seems that your config is broken. Please regenerate a new one.");
            return;
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setTestWhileIdle(true);
        jedisPoolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(30000L));
        jedisPoolConfig.setNumTestsPerEvictionRun(-1);
        jedisPoolConfig.setMinEvictableIdleDuration(Duration.ofMillis(section.getInt("MinEvictableIdleTimeMillis", 1800000)));
        jedisPoolConfig.setMaxTotal(section.getInt("MaxTotal", 8));
        jedisPoolConfig.setMaxIdle(section.getInt("MaxIdle", 8));
        jedisPoolConfig.setMinIdle(section.getInt("MinIdle", 1));
        jedisPoolConfig.setMaxWait(Duration.ofMillis(section.getInt("MaxWaitMillis")));
        this.password = section.getString("password", "");
        this.port = section.getInt("port", 6379);
        this.host = section.getString("host", "localhost");
        this.useSSL = section.getBoolean("use-ssl", false);
        this.jedisPool = this.password.isBlank() ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, 0, this.useSSL) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, 0, this.password, this.useSSL);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.ping();
            LogUtils.info("Redis server connected.");
        }
        catch (JedisException e) {
            LogUtils.warn("Failed to connect redis.");
        }
    }

    @Override
    public void disable() {
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            this.jedisPool.close();
        }
    }

    public void sendRedisMessage(@NotNull String channel, @NotNull String message) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.publish(channel, message);
            this.plugin.debug("Sent Redis message: " + message);
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.Redis;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        CompletableFuture<Optional<PlayerData>> future = new CompletableFuture<Optional<PlayerData>>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                byte[] key = this.getRedisKey("cn_data", uuid);
                byte[] data = jedis.get(key);
                if (data != null) {
                    future.complete(Optional.of(this.plugin.getStorageManager().fromBytes(data)));
                    this.plugin.debug("Redis data retrieved for " + uuid + "; normal data");
                } else {
                    future.complete(Optional.empty());
                    this.plugin.debug("Redis data retrieved for " + uuid + "; empty data");
                }
            }
            catch (Exception e) {
                future.complete(Optional.empty());
                LogUtils.warn("Failed to get redis data for " + uuid, e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.setex(this.getRedisKey("cn_data", uuid), 600L, this.plugin.getStorageManager().toBytes(playerData));
                future.complete(true);
                this.plugin.debug("Redis data set for " + uuid);
            }
            catch (Exception e) {
                future.complete(false);
                LogUtils.warn("Failed to set redis data for player " + uuid, e);
            }
        });
        return future;
    }

    private byte[] getRedisKey(String key, @NotNull UUID uuid) {
        return (key + ":" + uuid).getBytes(StandardCharsets.UTF_8);
    }
}

