/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.LegacyDataStorageInterface;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.storage.method.database.sql.AbstractSQLDatabase;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractHikariDatabase
extends AbstractSQLDatabase
implements LegacyDataStorageInterface {
    private HikariDataSource dataSource;
    private final String driverClass;
    private final String sqlBrand;

    public AbstractHikariDatabase(CustomNameplatesPlugin plugin) {
        block5: {
            super(plugin);
            this.driverClass = this.getStorageType() == StorageType.MariaDB ? "org.mariadb.jdbc.Driver" : "com.mysql.cj.jdbc.Driver";
            this.sqlBrand = this.getStorageType() == StorageType.MariaDB ? "MariaDB" : "MySQL";
            try {
                Class.forName(this.driverClass);
            }
            catch (ClassNotFoundException e1) {
                if (this.getStorageType() == StorageType.MariaDB) {
                    LogUtils.warn("No MariaDB driver is found");
                }
                if (this.getStorageType() != StorageType.MySQL) break block5;
                try {
                    Class.forName("com.mysql.jdbc.Driver");
                }
                catch (ClassNotFoundException e2) {
                    LogUtils.warn("No MySQL driver is found");
                }
            }
        }
    }

    @Override
    public void initialize() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        ConfigurationSection section = config.getConfigurationSection(this.sqlBrand);
        if (section == null) {
            LogUtils.warn("Failed to load database config. It seems that your config is broken. Please regenerate a new one.");
            return;
        }
        this.tablePrefix = section.getString("table-prefix", "customfishing");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setUsername(section.getString("user", "root"));
        hikariConfig.setPassword(section.getString("password", "pa55w0rd"));
        hikariConfig.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s%s", this.sqlBrand.toLowerCase(Locale.ENGLISH), section.getString("host", "localhost"), section.getString("port", "3306"), section.getString("database", "minecraft"), section.getString("connection-parameters")));
        hikariConfig.setDriverClassName(this.driverClass);
        hikariConfig.setMaximumPoolSize(section.getInt("Pool-Settings.max-pool-size", 10));
        hikariConfig.setMinimumIdle(section.getInt("Pool-Settings.min-idle", 10));
        hikariConfig.setMaxLifetime(section.getLong("Pool-Settings.max-lifetime", 180000L));
        hikariConfig.setConnectionTimeout(section.getLong("Pool-Settings.time-out", 20000L));
        hikariConfig.setPoolName("CustomNameplatesHikariPool");
        try {
            hikariConfig.setKeepaliveTime(section.getLong("Pool-Settings.keep-alive-time", 60000L));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        Properties properties = new Properties();
        properties.putAll(Map.of("cachePrepStmts", "true", "prepStmtCacheSize", "250", "prepStmtCacheSqlLimit", "2048", "useServerPrepStmts", "true", "useLocalSessionState", "true", "useLocalTransactionState", "true"));
        properties.putAll(Map.of("rewriteBatchedStatements", "true", "cacheResultSetMetadata", "true", "cacheServerConfiguration", "true", "elideSetAutoCommits", "true", "maintainTimeStats", "false"));
        hikariConfig.setDataSourceProperties(properties);
        this.dataSource = new HikariDataSource(hikariConfig);
        super.createTableIfNotExist();
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getLegacyPlayerData(UUID uuid) {
        CompletableFuture<Optional<PlayerData>> future = new CompletableFuture<Optional<PlayerData>>();
        String sql = String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.getTableName("data"));
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String nameplate = rs.getString(2);
                String bubbles = rs.getString(3);
                future.complete(Optional.of(PlayerData.builder().setBubble(bubbles).setNameplate(nameplate).build()));
            } else {
                future.complete(Optional.empty());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return future;
    }

    @Override
    public void disable() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

