/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.sql;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.storage.method.database.sql.AbstractSQLDatabase;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.sqlite.SQLiteConfig;

public class SQLiteImpl
extends AbstractSQLDatabase {
    private Connection connection;
    private File databaseFile;

    public SQLiteImpl(CustomNameplatesPlugin plugin) {
        super(plugin);
    }

    @Override
    public void initialize() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        this.databaseFile = new File(this.plugin.getDataFolder(), config.getString("SQLite.file", "data") + ".db");
        this.tablePrefix = config.getString("SQLite.table-prefix", "customfishing");
        super.createTableIfNotExist();
    }

    @Override
    public void disable() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("UPDATE `%s` SET `data` = ? WHERE `uuid` = ?", this.getTableName("data")));){
                statement.setBytes(1, this.plugin.getStorageManager().toBytes(playerData));
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
                future.complete(true);
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to update " + uuid + "'s data.", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        CompletableFuture<Optional<PlayerData>> future = new CompletableFuture<Optional<PlayerData>>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.getTableName("data")));){
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    byte[] dataByteArray = rs.getBytes("data");
                    future.complete(Optional.of(this.plugin.getStorageManager().fromBytes(dataByteArray)));
                } else if (Bukkit.getPlayer((UUID)uuid) != null) {
                    PlayerData data = PlayerData.empty();
                    this.insertPlayerData(uuid, data);
                    future.complete(Optional.of(data));
                } else {
                    future.complete(Optional.empty());
                }
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to get " + uuid + "'s data.", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public void insertPlayerData(UUID uuid, PlayerData playerData) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format("INSERT INTO `%s`(`uuid`, `data`) VALUES(?, ?)", this.getTableName("data")));){
            statement.setString(1, uuid.toString());
            statement.setBytes(2, this.plugin.getStorageManager().toBytes(playerData));
            statement.execute();
        }
        catch (SQLException e) {
            LogUtils.warn("Failed to insert " + uuid + "'s data.", e);
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.SQLite;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.setConnection();
        }
        return this.connection;
    }

    private void setConnection() {
        try {
            if (!this.databaseFile.exists()) {
                this.databaseFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            config.setEncoding(SQLiteConfig.Encoding.UTF8);
            config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", this.databaseFile.getAbsolutePath()), config.toProperties());
        }
        catch (IOException e) {
            LogUtils.warn("Failed to create the SQLite database.");
        }
        catch (SQLException e) {
            LogUtils.warn("Failed to initialize SQLite database.");
        }
        catch (ClassNotFoundException e) {
            LogUtils.warn("Failed to find SQLite driver.");
        }
    }
}

