/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.file;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.LegacyDataStorageInterface;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.storage.method.AbstractStorage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLImpl
extends AbstractStorage
implements LegacyDataStorageInterface {
    public YAMLImpl(CustomNameplatesPlugin plugin) {
        super(plugin);
        File folder = new File(plugin.getDataFolder(), "data");
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.YAML;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        File dataFile = this.getPlayerDataFile(uuid);
        if (!dataFile.exists()) {
            if (Bukkit.getPlayer((UUID)uuid) != null) {
                return CompletableFuture.completedFuture(Optional.of(PlayerData.empty()));
            }
            return CompletableFuture.completedFuture(Optional.empty());
        }
        YamlConfiguration data = this.readData(dataFile);
        PlayerData playerData = new PlayerData.Builder().setBubble(data.getString("bubble", "")).setNameplate(data.getString("nameplate", "")).build();
        return CompletableFuture.completedFuture(Optional.of(playerData));
    }

    public File getPlayerDataFile(UUID uuid) {
        return new File(this.plugin.getDataFolder(), "data" + File.separator + uuid + ".yml");
    }

    public YamlConfiguration readData(File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtils.warn("Failed to generate data files!</red>");
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        YamlConfiguration data = new YamlConfiguration();
        data.set("bubble", (Object)playerData.getBubble());
        data.set("nameplate", (Object)playerData.getNameplate());
        try {
            data.save(this.getPlayerDataFile(uuid));
        }
        catch (IOException e) {
            LogUtils.warn("Failed to save player data", e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Set<UUID> getUniqueUsers(boolean legacy) {
        File[] files;
        File folder = legacy ? new File(this.plugin.getDataFolder(), "player_data") : new File(this.plugin.getDataFolder(), "data");
        HashSet<UUID> uuids = new HashSet<UUID>();
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                uuids.add(UUID.fromString(file.getName().substring(0, file.getName().length() - 4)));
            }
        }
        return uuids;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getLegacyPlayerData(UUID uuid) {
        File dataFile = new File(this.plugin.getDataFolder(), "player_data" + File.separator + uuid + ".yml");
        YamlConfiguration data = this.readData(dataFile);
        PlayerData playerData = new PlayerData.Builder().setBubble(data.getString("bubbles", "")).setNameplate(data.getString("nameplate", "")).build();
        return CompletableFuture.completedFuture(Optional.of(playerData));
    }
}

