/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.Pair;
import net.momirealms.customnameplates.paper.mechanic.misc.TimeLimitText;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static ArrayList<String> stringListArgs(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        if (object instanceof String) {
            String member = (String)object;
            list.add(member);
        } else if (object instanceof List) {
            List members = (List)object;
            list.addAll(members);
        } else if (object instanceof String[]) {
            String[] strings = (String[])object;
            list.addAll(List.of(strings));
        }
        return list;
    }

    public static Pair<Integer, Integer> splitStringIntegerArgs(String value, String regex) {
        String[] split = value.split(regex);
        return Pair.of(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    public static double getDoubleValue(Object arg) {
        if (arg instanceof Double) {
            Double d = (Double)arg;
            return d;
        }
        if (arg instanceof Integer) {
            Integer i = (Integer)arg;
            return i.intValue();
        }
        return 0.0;
    }

    public static TimeLimitText[] getTimeLimitTexts(ConfigurationSection section) {
        TreeMap<Integer, TimeLimitText> map = new TreeMap<Integer, TimeLimitText>();
        if (section == null) {
            LogUtils.warn("No text display order set, this might cause bugs!");
            map.put(1, new TimeLimitText(100, -1, "", new Requirement[0]));
            return ConfigUtils.getOrderedTexts(map);
        }
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            int order;
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection textSection = (ConfigurationSection)v;
            TimeLimitText text = TimeLimitText.Builder.of().text(textSection.getString("text", "")).refreshFrequency(textSection.getInt("refresh-frequency", -1)).duration(textSection.getInt("duration", 200)).requirement(CustomNameplatesPlugin.get().getRequirementManager().getRequirements(textSection.getConfigurationSection("conditions"))).build();
            try {
                order = Integer.parseInt((String)entry.getKey());
            }
            catch (NumberFormatException e) {
                LogUtils.warn("Invalid order format: " + (String)entry.getKey());
                continue;
            }
            map.put(order, text);
        }
        return ConfigUtils.getOrderedTexts(map);
    }

    private static TimeLimitText[] getOrderedTexts(TreeMap<Integer, TimeLimitText> map) {
        return map.values().toArray(new TimeLimitText[0]);
    }

    public static void saveResource(@NotNull String resourcePath) {
        if (resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = ConfigUtils.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            return;
        }
        File outFile = new File(CustomNameplatesPlugin.get().getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(CustomNameplatesPlugin.get().getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            LogUtils.warn("Could not save " + outFile.getName() + " to " + outFile);
        }
    }

    @Nullable
    public static InputStream getResource(@NotNull String filename) {
        try {
            URL url = ((Object)((Object)CustomNameplatesPlugin.get())).getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String native2ascii(char c) {
        StringBuilder stringBuilder_1 = new StringBuilder("\\u");
        StringBuilder stringBuilder_2 = new StringBuilder(Integer.toHexString(c));
        stringBuilder_2.reverse();
        int n = 4 - stringBuilder_2.length();
        for (int i = 0; i < n; ++i) {
            stringBuilder_2.append('0');
        }
        for (int j = 0; j < 4; ++j) {
            stringBuilder_1.append(stringBuilder_2.charAt(3 - j));
        }
        return stringBuilder_1.toString();
    }

    public static char[] convertUnicodeStringToChars(String unicodeString) {
        String processedString = unicodeString.replace("\\u", "");
        int length = processedString.length() / 4;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int codePoint = Integer.parseInt(processedString.substring(i * 4, i * 4 + 4), 16);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                chars[i] = Character.highSurrogate(codePoint);
                chars[++i] = Character.lowSurrogate(codePoint);
                continue;
            }
            chars[i] = (char)codePoint;
        }
        return chars;
    }
}

