/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.util.LogUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class Migration {
    public static boolean check() {
        File readMe = new File(CustomNameplatesPlugin.get().getDataFolder(), "README.text");
        if (readMe.exists()) {
            return true;
        }
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "config.yml");
        if (!file.exists()) {
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        boolean version = config.contains("other-settings.default-character-width");
        if (!version) {
            return false;
        }
        config.set("other-settings.default-character-width", null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CustomNameplatesPlugin.get().saveResource("README.txt", true);
        Migration.updateBossBar();
        Migration.updateActionBar();
        Migration.updateBubble();
        Migration.updateNameplate();
        Migration.updateCustomPlaceholders();
        Migration.updateLanguages();
        Migration.deleteFiles();
        return true;
    }

    private static void updateLanguages() {
        File messageFolder = new File(CustomNameplatesPlugin.get().getDataFolder(), "messages");
        if (messageFolder.exists()) {
            File[] files = messageFolder.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                ConfigurationSection messageSection = config.getConfigurationSection("messages");
                if (messageSection != null) {
                    for (String key : messageSection.getKeys(false)) {
                        String original = messageSection.getString(key);
                        if (original == null || !original.contains("{Bubbles}")) continue;
                        messageSection.set(key, (Object)original.replace("{Bubbles}", "{Bubble}"));
                    }
                }
                try {
                    config.save(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void deleteFiles() {
        try {
            FileUtils.delete((File)new File(CustomNameplatesPlugin.get().getDataFolder(), "database.yml"));
            FileUtils.deleteDirectory((File)new File(CustomNameplatesPlugin.get().getDataFolder(), "unicodes"));
            FileUtils.deleteDirectory((File)new File(CustomNameplatesPlugin.get().getDataFolder(), "templates"));
            FileUtils.deleteDirectory((File)new File(CustomNameplatesPlugin.get().getDataFolder(), "ResourcePack"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateBossBar() {
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "configs" + File.separator + "bossbar.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Map.Entry entry : config.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection section = (ConfigurationSection)v;
            section.set("check-frequency", (Object)1);
            int refresh = section.getInt("refresh-rate");
            if (section.contains("text")) {
                String text = section.getString("text");
                section.set("text-display-order.1.duration", (Object)1000);
                section.set("text-display-order.1.refresh-frequency", (Object)refresh);
                section.set("text-display-order.1.text", (Object)text);
            } else if (section.contains("dynamic-text")) {
                int switchInt = section.getInt("switch-interval", 15) * 20;
                int i = 0;
                for (String text : section.getStringList("dynamic-text")) {
                    section.set("text-display-order." + ++i + ".duration", (Object)switchInt);
                    section.set("text-display-order." + i + ".refresh-frequency", (Object)refresh);
                    section.set("text-display-order." + i + ".text", (Object)text);
                }
            }
            section.set("switch-interval", null);
            section.set("dynamic-text", null);
            section.set("refresh-rate", null);
            section.set("text", null);
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateActionBar() {
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "configs" + File.separator + "actionbar.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Map.Entry entry : config.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection section = (ConfigurationSection)v;
            String text = section.getString("text", "");
            section.set("text", null);
            section.set("check-frequency", (Object)1);
            section.set("text-display-order.1.text", (Object)text);
            section.set("text-display-order.1.refresh-frequency", (Object)1);
            section.set("text-display-order.1.duration", (Object)1000);
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateBubble() {
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "configs" + File.separator + "bubble.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("mode", null);
        config.set("text-display-options", null);
        config.set("default-bubble", (Object)config.getString("default-bubbles", "none"));
        config.set("default-bubbles", null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateNameplate() {
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "configs" + File.separator + "nameplate.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String mode = config.getString("mode", "");
        if (!mode.equalsIgnoreCase("team")) {
            config.set("mode", (Object)"Unlimited");
        }
        config.set("nameplate.player-name", (Object)config.getString("player-name", "%player_name%"));
        config.set("nameplate.refresh-frequency", (Object)10);
        config.set("nameplate.prefix", (Object)config.getString("prefix", ""));
        config.set("nameplate.prefix", (Object)config.getString("suffix", ""));
        if (mode.equalsIgnoreCase("team")) {
            config.createSection("unlimited");
            ConfigurationSection section = config.createSection("team");
            section.set("refresh-frequency", (Object)20);
            section.set("prefix", (Object)"");
            section.set("suffix", (Object)"");
        } else {
            ConfigurationSection old;
            if (mode.equalsIgnoreCase("armor_stand")) {
                old = config.getConfigurationSection("armor_stand");
            } else if (mode.equalsIgnoreCase("text_display")) {
                old = config.getConfigurationSection("text_display");
            } else {
                LogUtils.severe("No mode is set for nameplate. Failed to migrate!");
                return;
            }
            ConfigurationSection newSection = config.createSection("unlimited", old.getValues(false));
            for (Map.Entry entry : newSection.getValues(false).entrySet()) {
                ConfigurationSection inner;
                ConfigurationSection conditions;
                Object v = entry.getValue();
                if (!(v instanceof ConfigurationSection) || (conditions = (inner = (ConfigurationSection)v).getConfigurationSection("conditions")) == null) continue;
                inner.createSection("owner-conditions", conditions.getValues(false));
                inner.createSection("viewer-conditions");
            }
        }
        try {
            config.set("player-name", null);
            config.set("prefix", null);
            config.set("suffix", null);
            config.set("hide-prefix-when-equipping-nameplate", null);
            config.set("hide-suffix-when-equipping-nameplate", null);
            config.set("create-fake-team", null);
            config.set("text_display", null);
            config.set("armor_stand", null);
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateCustomPlaceholders() {
        File file = new File(CustomNameplatesPlugin.get().getDataFolder(), "configs" + File.separator + "custom-placeholders.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.createSection("switch-text");
        ConfigurationSection descentTSection = config.getConfigurationSection("descent-text");
        ConfigurationSection descentUSection = config.getConfigurationSection("descent-unicode");
        if (descentTSection != null && descentUSection != null) {
            for (Map.Entry entry : descentUSection.getValues(false).entrySet()) {
                ConfigurationSection newSection;
                Object v = entry.getValue();
                if (!(v instanceof ConfigurationSection)) continue;
                ConfigurationSection inner = (ConfigurationSection)v;
                String text = inner.getString("text");
                int descent = inner.getInt("descent");
                if (descentTSection.contains((String)entry.getKey())) {
                    newSection = descentTSection.createSection((String)entry.getKey() + "_");
                    LogUtils.warn("Duplicated key '" + (String)entry.getKey() + "' found during migration. Please manually fix that.");
                } else {
                    newSection = descentTSection.createSection((String)entry.getKey());
                }
                newSection.set("text", (Object)text);
                newSection.set("descent", (Object)descent);
                newSection.set("is-unicode", (Object)true);
            }
        }
        config.set("descent-unicode", null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

