/*
 * Decompiled with CFR 0.152.
 */
package com.valorin;

import com.valorin.arenas.ArenaCreatorHandler;
import com.valorin.arenas.ArenaManager;
import com.valorin.arenas.FinishGame;
import com.valorin.caches.CacheHandler;
import com.valorin.commands.CommandHandler;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.DataFile;
import com.valorin.configuration.languagefile.LanguageFileLoader;
import com.valorin.configuration.languagefile.SymbolLoader;
import com.valorin.configuration.update.ConfigUpdate;
import com.valorin.dan.DanHandler;
import com.valorin.data.MySQL;
import com.valorin.event.TheEventRegister;
import com.valorin.network.Update;
import com.valorin.papi.RegPAPI;
import com.valorin.queue.MatchingHandler;
import com.valorin.ranking.RankingData;
import com.valorin.ranking.hologram.HologramManager;
import com.valorin.ranking.sign.SignManager;
import com.valorin.ranking.skull.SkullManager;
import com.valorin.request.RequestsHandler;
import com.valorin.stats.Stats;
import com.valorin.stats.data.SingleLineChartData;
import com.valorin.task.GlobalGameTimes;
import com.valorin.task.VersionChecker;
import com.valorin.timetable.Timetable;
import com.valorin.util.ViaVersion;
import java.lang.reflect.Method;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static String version;
    private static Main instance;
    private CommandHandler commandsHandler;
    private ArenaManager arenaManager;
    private ArenaCreatorHandler arenaCreatorHandler;
    private Timetable timeTable;
    private RequestsHandler requestHandler;
    private RankingData rankingData;
    private HologramManager hologramManager;
    private DanHandler danHandler;
    private SymbolLoader symbolLoader;
    private MatchingHandler matchingHandler;
    private LanguageFileLoader languageFileLoader;
    private SingleLineChartData singleLineChartData;
    private MySQL mysql;
    private CacheHandler cacheHandler;
    private GlobalGameTimes globalGameTimes;
    private ConfigManager configManager;
    private RegPAPI regPAPI;
    private String serverVersion;
    private Update update;
    private int serverVersionType;

    public static String getVersion() {
        return version;
    }

    public static Main getInstance() {
        return instance;
    }

    public CommandHandler getCommandHandler() {
        return this.commandsHandler;
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public ArenaCreatorHandler getACS() {
        return this.arenaCreatorHandler;
    }

    public Timetable getTimeTable() {
        return this.timeTable;
    }

    public void reloadTimeTable() {
        this.timeTable.close();
        this.timeTable = new Timetable();
    }

    public RequestsHandler getRequestsHandler() {
        return this.requestHandler;
    }

    public RankingData getRanking() {
        return this.rankingData;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public DanHandler getDanHandler() {
        return this.danHandler;
    }

    public SymbolLoader getSymbolLoader() {
        return this.symbolLoader;
    }

    public MatchingHandler getMatchingHandler() {
        return this.matchingHandler;
    }

    public LanguageFileLoader getLanguageFileLoader() {
        return this.languageFileLoader;
    }

    public void reloadLanguageFileLoad() {
        this.languageFileLoader.close();
        this.languageFileLoader = new LanguageFileLoader();
    }

    public SingleLineChartData getSingleLineChartData() {
        return this.singleLineChartData;
    }

    public MySQL getMySQL() {
        return this.mysql;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public GlobalGameTimes getGlobalGameTimes() {
        return this.globalGameTimes;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getServerVersionType() {
        return this.serverVersionType;
    }

    public Update getUpdate() {
        return this.update;
    }

    public void onEnable() {
        instance = this;
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        version = this.getDescription().getVersion();
        console.sendMessage("\u00a7b\u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557");
        console.sendMessage("\u00a7b\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u255a\u2550\u2550\u2588\u2588\u2554\u2550\u2550\u255d");
        console.sendMessage("\u00a7b\u2588\u2588\u2551  \u2588\u2588\u2551   \u2588\u2588\u2551   ");
        console.sendMessage("\u00a7b\u2588\u2588\u2551  \u2588\u2588\u2551   \u2588\u2588\u2551   ");
        console.sendMessage("\u00a7b\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d   \u2588\u2588\u2551   ");
        console.sendMessage("\u00a7b\u255a\u2550\u2550\u2550\u2550\u2550\u255d    \u255a\u2550\u255d\u00a7eEnabling...");
        console.sendMessage("\u00a7fThis is Dantiao-EX " + version + " developed by Valorin");
        console.sendMessage("\u00a7f\u795d\u60a8\u4f7f\u7528\u6109\u5feb :D");
        DataFile.loadData();
        DataFile.saveAreas();
        DataFile.saveBlackList();
        DataFile.savePlayerData();
        DataFile.saveRanking();
        DataFile.saveRecords();
        DataFile.saveShop();
        DataFile.saveSymbols();
        new SymbolLoader();
        ConfigUpdate.execute();
        this.configManager = new ConfigManager();
        this.mysql = new MySQL();
        this.mysql.connect();
        this.cacheHandler = new CacheHandler(() -> {
            this.languageFileLoader = new LanguageFileLoader();
            this.symbolLoader = new SymbolLoader();
            this.arenaCreatorHandler = new ArenaCreatorHandler();
            this.arenaManager = new ArenaManager();
            this.timeTable = new Timetable();
            this.requestHandler = new RequestsHandler();
            this.rankingData = new RankingData();
            try {
                this.hologramManager = new HologramManager();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.danHandler = new DanHandler();
            this.matchingHandler = new MatchingHandler();
            this.commandsHandler = new CommandHandler();
            this.singleLineChartData = new SingleLineChartData();
            SkullManager.initialize();
            SignManager.initialize();
            TheEventRegister.registerEvents();
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                if (!PlaceholderAPI.isRegistered((String)"dantiao")) {
                    this.regPAPI = new RegPAPI();
                    this.regPAPI.register();
                }
            } else {
                console.sendMessage("\u00a78\u00a7l[\u00a7bDantiao\u00a78\u00a7l]");
                console.sendMessage("\u00a7f- \u00a7c\u672a\u53d1\u73b0PlaceholderAPI\u53d8\u91cf\u63d2\u4ef6\uff0c\u5c06\u65e0\u6cd5\u4f7f\u7528PAPI\u7684\u76f8\u5173\u529f\u80fd\uff0c\u82e5\u60a8\u521a\u5b89\u88c5\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u542f\u670d\u52a1\u5668");
                console.sendMessage("\u00a7f- \u00a7cPlugin PlaceholderAPI is not found!");
            }
        });
        this.update = new Update();
        new VersionChecker().runTaskLaterAsynchronously((Plugin)instance, 200L);
        this.globalGameTimes = new GlobalGameTimes();
        this.globalGameTimes.runTaskTimerAsynchronously((Plugin)instance, 200L, 36000L);
        new Stats();
        this.serverVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            int serverVersionInt = Integer.parseInt(this.serverVersion.split("_")[1]);
            if (serverVersionInt <= 7) {
                this.serverVersionType = 0;
            }
            if (serverVersionInt >= 8 && serverVersionInt <= 9) {
                this.serverVersionType = 1;
            }
            if (serverVersionInt >= 10 && serverVersionInt <= 16) {
                this.serverVersionType = 2;
            }
            if (serverVersionInt >= 17) {
                this.serverVersionType = 3;
            }
        }
        catch (NumberFormatException e) {
            this.serverVersionType = 0;
            e.printStackTrace();
        }
        ViaVersion.getAllClass();
    }

    public void onDisable() {
        this.globalGameTimes.cancel();
        for (String editName : ArenaManager.busyArenasName) {
            FinishGame.compulsoryEnd(editName, null, FinishGame.CompulsoryEndCause.RELOAD_PLUGIN);
        }
        this.hologramManager.disable();
        this.languageFileLoader.close();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && PlaceholderAPI.isRegistered((String)"dantiao")) {
            this.unRegisterPAPI();
        }
        this.cacheHandler.unload();
        Bukkit.getScheduler().cancelTasks((Plugin)instance);
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage("\u00a78\u00a7l[\u00a7bDantiao\u00a78\u00a7l]");
        console.sendMessage("\u00a7f- \u00a77\u5355\u6311\u63d2\u4ef6EX\u5df2\u5173\u95ed\uff0c\u611f\u8c22\u4f60\u7684\u4f7f\u7528:D");
        console.sendMessage("\u00a7f- \u00a77Dantiao-EX by:Valorin");
    }

    public void unRegisterPAPI() {
        try {
            this.regPAPI.unregister();
        }
        catch (Exception e) {
            try {
                Method method = Class.forName("me.clip.placeholderapi.PlaceholderAPI").getMethod("unregisterExpansion", new Class[0]);
                method.invoke((Object)this.regPAPI, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

