/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.api;

import com.valorin.Main;
import com.valorin.caches.EnergyCache;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DanHandler;
import com.valorin.ranking.RankingData;
import java.math.BigDecimal;
import org.bukkit.entity.Player;

public class DantiaoAPI {
    public static double getPlayerPoints(Player p) {
        return Main.getInstance().getCacheHandler().getPoint().get(p.getName());
    }

    public static void setPlayerPoints(Player p, double value) {
        Main.getInstance().getCacheHandler().getPoint().set(p.getName(), value);
    }

    public static int getPlayerExp(Player p) {
        return Main.getInstance().getCacheHandler().getDan().get(p.getName());
    }

    public static void setPlayerExp(Player p, int value) {
        Main.getInstance().getCacheHandler().getDan().set(p.getName(), value);
    }

    public static int getPlayerWin(Player p) {
        return Main.getInstance().getCacheHandler().getRecord().getWins(p.getName());
    }

    public static int getPlayerLose(Player p) {
        return Main.getInstance().getCacheHandler().getRecord().getLoses(p.getName());
    }

    public static int getPlayerDraw(Player p) {
        return Main.getInstance().getCacheHandler().getRecord().getDraws(p.getName());
    }

    public static double getPlayerEnergy(Player p) {
        EnergyCache energyCache = Main.getInstance().getCacheHandler().getEnergy();
        if (energyCache.isEnable()) {
            BigDecimal bg = BigDecimal.valueOf(energyCache.get(p.getName()));
            return bg.setScale(2, 4).doubleValue();
        }
        return -1.0;
    }

    public static double getMaxEnergy() {
        EnergyCache energyCache = Main.getInstance().getCacheHandler().getEnergy();
        if (energyCache.isEnable()) {
            return energyCache.getMaxEnergy();
        }
        return -1.0;
    }

    public static double getPlayerKD(Player p) {
        int wins = Main.getInstance().getCacheHandler().getRecord().getWins(p.getName());
        int loses = Main.getInstance().getCacheHandler().getRecord().getLoses(p.getName());
        double kd = (double)loses != 0.0 ? (double)wins / (double)loses : (double)wins;
        BigDecimal bg = new BigDecimal(kd);
        return bg.setScale(2, 4).doubleValue();
    }

    public static int getPlayerWinRank(Player p) {
        RankingData rankingData = Main.getInstance().getRanking();
        return rankingData.getWinRank(p.getName());
    }

    public static int getPlayerKDRank(Player p) {
        RankingData rankingData = Main.getInstance().getRanking();
        return rankingData.getKDRank(p.getName());
    }

    public static String getPlayerDanName(Player p) {
        DanHandler dan = Main.getInstance().getDanHandler();
        if (dan != null) {
            return dan.getPlayerDan(p.getName()).getDisplayName();
        }
        return Main.getInstance().getConfigManager().getInitialDanName();
    }

    public static CustomDan getPlayerDan(Player p) {
        DanHandler dan = Main.getInstance().getDanHandler();
        return dan.getPlayerDan(p.getName());
    }

    public static DanHandler getDanHandler() {
        return Main.getInstance().getDanHandler();
    }
}

