/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.arenas;

import com.valorin.Main;
import com.valorin.api.event.ArenaEventAbs;
import com.valorin.api.event.arena.ArenaDrawFinishEvent;
import com.valorin.api.event.arena.ArenaFinishEvent;
import com.valorin.arenas.Arena;
import com.valorin.arenas.ArenaManager;
import com.valorin.caches.EnergyCache;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.data.encapsulation.ArenaInfo;
import com.valorin.effect.WinFirework;
import com.valorin.event.game.EventCompulsoryTeleport;
import com.valorin.task.SettleEnd;
import com.valorin.teleport.ToLobby;
import com.valorin.teleport.ToLogLocation;
import com.valorin.util.Debug;
import com.valorin.util.ItemTaker;
import com.valorin.util.ViaVersion;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class FinishGame {
    public static void normalEnd(String name, String winnerName, String loserName, boolean isDraw) {
        Arena arena = Main.getInstance().getArenaManager().getArena(name);
        if (arena == null) {
            return;
        }
        if (!arena.getEnable()) {
            return;
        }
        Player winner = Bukkit.getPlayerExact((String)winnerName);
        Player loser = Bukkit.getPlayerExact((String)loserName);
        ArenaInfo arenaInfo = Main.getInstance().getCacheHandler().getArenaInfo().get(name);
        if (arenaInfo.isKitMode()) {
            int i;
            winner.closeInventory();
            ItemTaker.cleanInventory(winner);
            loser.closeInventory();
            ItemTaker.cleanInventory(loser);
            for (i = 0; i < arena.getPlayerInventoryItems(arena.isp1(winnerName)).size(); ++i) {
                winner.getInventory().setItem(i, arena.getPlayerInventoryItems(arena.isp1(winnerName)).get(i));
            }
            for (i = 0; i < arena.getPlayerInventoryItems(arena.isp1(loserName)).size(); ++i) {
                loser.getInventory().setItem(i, arena.getPlayerInventoryItems(arena.isp1(loserName)).get(i));
            }
            winner.getInventory().setItem(36, arena.getPlayerHelmet(arena.isp1(winnerName)));
            loser.getInventory().setItem(36, arena.getPlayerHelmet(arena.isp1(loserName)));
            winner.getInventory().setItem(37, arena.getPlayerChestPlate(arena.isp1(winnerName)));
            loser.getInventory().setItem(37, arena.getPlayerChestPlate(arena.isp1(loserName)));
            winner.getInventory().setItem(38, arena.getPlayerLeggings(arena.isp1(winnerName)));
            loser.getInventory().setItem(38, arena.getPlayerLeggings(arena.isp1(loserName)));
            winner.getInventory().setItem(39, arena.getPlayerBoots(arena.isp1(winnerName)));
            loser.getInventory().setItem(39, arena.getPlayerBoots(arena.isp1(loserName)));
            if (ViaVersion.isHasOffHandMethod()) {
                ViaVersion.setItemInOffHand(winner, arena.getPlayerOffHandItem(arena.isp1(winnerName)));
                ViaVersion.setItemInOffHand(loser, arena.getPlayerOffHandItem(arena.isp1(loserName)));
            }
        }
        System.out.println(winner.getMaxHealth() + "  " + loser.getMaxHealth());
        ConfigManager configManager = Main.getInstance().getConfigManager();
        ConfigManager.AutoRespawnWay autoRespawnWay = configManager.getAutoRespawnWay();
        if (winner != null) {
            try {
                if (winner.isDead()) {
                    if (configManager.isAutoRespawnEnable()) {
                        if (autoRespawnWay.equals((Object)ConfigManager.AutoRespawnWay.SPIGOT)) {
                            winner.spigot().respawn();
                        }
                        if (autoRespawnWay.equals((Object)ConfigManager.AutoRespawnWay.SETHEALTH)) {
                            winner.setHealth(winner.getMaxHealth());
                            EventCompulsoryTeleport.players.put(winnerName, arena.getLocation(arena.isp1(winnerName)));
                            EventCompulsoryTeleport.back(winner);
                        }
                    } else {
                        EventCompulsoryTeleport.players.put(winnerName, arena.getLocation(arena.isp1(winnerName)));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                EventCompulsoryTeleport.players.put(winnerName, arena.getLocation(arena.isp1(winnerName)));
            }
        }
        if (loser != null) {
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> loser.getWorld().strikeLightningEffect(loser.getLocation()));
            try {
                if (loser.isDead()) {
                    if (configManager.isAutoRespawnEnable()) {
                        if (autoRespawnWay.equals((Object)ConfigManager.AutoRespawnWay.SPIGOT)) {
                            loser.spigot().respawn();
                        }
                        if (autoRespawnWay.equals((Object)ConfigManager.AutoRespawnWay.SETHEALTH)) {
                            loser.setHealth(loser.getMaxHealth());
                            EventCompulsoryTeleport.players.put(loserName, arena.getLocation(arena.isp1(winnerName)));
                            EventCompulsoryTeleport.back(loser);
                        }
                    } else {
                        EventCompulsoryTeleport.players.put(loserName, arena.getLocation(arena.isp1(winnerName)));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                EventCompulsoryTeleport.players.put(loserName, arena.getLocation(arena.isp1(loserName)));
            }
        }
        try {
            winner.setHealth(winner.getMaxHealth());
            winner.setFoodLevel(20);
            if (loser != null && !loser.isDead()) {
                loser.setHealth(loser.getMaxHealth());
                loser.setFoodLevel(20);
            }
            ViaVersion.sendTitle(winner, MessageSender.gm("&a&l\u80dc\u5229", winner), MessageSender.gm("&f\u4f60\u4ee5 &f&l{time} &f\u79d2\u51fb\u8d25\u4e86 &f&l{player}", winner, "time player", new String[]{arena.getTime() + "", loserName}), 20, 60, 0);
            EnergyCache energyCache = Main.getInstance().getCacheHandler().getEnergy();
            if (energyCache.isEnable()) {
                double energyNeeded = energyCache.getEnergyNeeded();
                energyCache.set(winnerName, energyCache.get(winnerName) - energyNeeded);
                energyCache.set(loserName, energyCache.get(loserName) - energyNeeded);
            }
            arena.setCanTeleport(true);
            arena.setWatchersTeleport(true);
            List<String> watchers = arena.getWatchers();
            Location lobbyLocation = Main.getInstance().getCacheHandler().getArea().getLobby();
            if (lobbyLocation != null) {
                ToLobby.to(winner, false);
                ToLobby.to(loser, true);
                MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", winner);
                if (loser != null) {
                    MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", loser);
                }
                for (String watcher : watchers) {
                    if (Bukkit.getPlayerExact((String)watcher) == null) continue;
                    ToLobby.to(Bukkit.getPlayerExact((String)watcher), true);
                    MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", loser);
                }
            } else {
                Location winnerLocation = arena.getLocation(arena.isp1(winnerName));
                Location loserLocation = arena.getLocation(arena.isp1(loserName));
                ToLogLocation.to(winner, loser, winnerLocation, loserLocation, false);
                for (String watcher : watchers) {
                    if (Bukkit.getPlayerExact((String)watcher) == null) continue;
                    MessageSender.sm("&b[\u62a5\u544a] &7\u4f60\u6240\u89c2\u6218\u7684\u7ade\u6280\u573a\u4e0a\u7684\u6bd4\u8d5b\u5df2\u7ed3\u675f\uff0c\u8bf7\u81ea\u884c\u4f20\u9001\u56de\u5bb6...", Bukkit.getPlayerExact((String)watcher), false);
                }
            }
            boolean isFirework = false;
            int startWay = arena.getStartWay();
            if (startWay == 1) {
                isFirework = configManager.isFireworkAwardedByPanel();
            }
            if (startWay == 2) {
                isFirework = configManager.isFireworkAwardedByInviting();
            }
            if (startWay == 3) {
                isFirework = configManager.isFireworkAwardedByCompulsion();
            }
            if (isFirework) {
                WinFirework.setFirework(winner.getLocation());
                MessageSender.sm("&a[v]WOW\uff01\u670d\u52a1\u5668\u4e13\u95e8\u4e3a\u4f60\u7684\u83b7\u80dc\u653e\u4e86\u4e00\u6735\u70df\u82b1~", winner);
            }
            ArenaManager.busyArenasName.remove(arena.getName());
            Main.getInstance().getSingleLineChartData().addGameTimes();
            ArenaEventAbs event = isDraw ? new ArenaDrawFinishEvent(winner, loser, arena) : new ArenaFinishEvent(winner, loser, arena);
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> Bukkit.getServer().getPluginManager().callEvent((Event)event));
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
                try {
                    SettleEnd.settle(arena, winner, loser, isDraw);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                arena.finish();
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ArenaManager.busyArenasName.remove(arena.getName());
            arena.finish();
            Debug.send("\u00a7c\u6bd4\u8d5b\u7ed3\u675f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01\u8bf7\u5c06\u62a5\u9519\u4fe1\u606f\u622a\u56fe\u53cd\u9988\u7ed9\u672c\u63d2\u4ef6\u4f5c\u8005", "Some errors occurred when the game finished!");
        }
    }

    public static void compulsoryEnd(String name, Player finisher, CompulsoryEndCause cause) {
        Arena arena = Main.getInstance().getArenaManager().getArena(name);
        if (arena == null) {
            MessageSender.sm("&c[x]\u4e0d\u5b58\u5728\u7684\u7ade\u6280\u573a\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165", finisher);
            return;
        }
        if (!arena.getEnable()) {
            MessageSender.sm("&c[x]\u8fd9\u4e2a\u7ade\u6280\u573a\u8fd8\u6ca1\u6709\u6bd4\u8d5b\u5462\uff01", finisher);
            return;
        }
        Player player1 = Bukkit.getPlayerExact((String)arena.getp1());
        String playerName1 = player1.getName();
        Player player2 = Bukkit.getPlayerExact((String)arena.getp2());
        String playerName2 = player2.getName();
        ArenaInfo arenaInfo = Main.getInstance().getCacheHandler().getArenaInfo().get(name);
        if (arenaInfo.isKitMode()) {
            int i;
            ItemTaker.cleanInventory(player1);
            ItemTaker.cleanInventory(player2);
            for (i = 0; i < arena.getPlayerInventoryItems(arena.isp1(playerName1)).size(); ++i) {
                player1.getInventory().setItem(i, arena.getPlayerInventoryItems(arena.isp1(playerName1)).get(i));
            }
            for (i = 0; i < arena.getPlayerInventoryItems(arena.isp1(playerName2)).size(); ++i) {
                player2.getInventory().setItem(i, arena.getPlayerInventoryItems(arena.isp1(playerName2)).get(i));
            }
            player1.getInventory().setItem(36, arena.getPlayerHelmet(arena.isp1(playerName1)));
            player2.getInventory().setItem(36, arena.getPlayerHelmet(arena.isp1(playerName2)));
            player1.getInventory().setItem(37, arena.getPlayerChestPlate(arena.isp1(playerName1)));
            player2.getInventory().setItem(37, arena.getPlayerChestPlate(arena.isp1(playerName2)));
            player1.getInventory().setItem(38, arena.getPlayerLeggings(arena.isp1(playerName1)));
            player2.getInventory().setItem(38, arena.getPlayerLeggings(arena.isp1(playerName2)));
            player1.getInventory().setItem(39, arena.getPlayerBoots(arena.isp1(playerName1)));
            player2.getInventory().setItem(39, arena.getPlayerBoots(arena.isp1(playerName2)));
            if (ViaVersion.isHasOffHandMethod()) {
                ViaVersion.setItemInOffHand(player1, arena.getPlayerOffHandItem(arena.isp1(playerName1)));
                ViaVersion.setItemInOffHand(player2, arena.getPlayerOffHandItem(arena.isp1(playerName2)));
            }
        }
        arena.setWatchersTeleport(true);
        List<String> watchers = arena.getWatchers();
        Location lobbyLocation = Main.getInstance().getCacheHandler().getArea().getLobby();
        if (lobbyLocation != null) {
            ToLobby.to(player1, true);
            MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", player1);
            ToLobby.to(player2, true);
            MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", player2);
            for (String watcher : watchers) {
                if (Bukkit.getPlayerExact((String)watcher) == null) continue;
                ToLobby.to(Bukkit.getPlayerExact((String)watcher), true);
                MessageSender.sm("&b\u5df2\u5c06\u4f60\u5e26\u56de\u5355\u6311\u5927\u5385\uff01", player2);
            }
        } else {
            Location winnerLocation = arena.getLocation(arena.isp1(player1.getName()));
            Location loserLocation = arena.getLocation(arena.isp1(player2.getName()));
            ToLogLocation.to(player1, player2, winnerLocation, loserLocation, true);
            for (String watcher : watchers) {
                if (Bukkit.getPlayerExact((String)watcher) == null) continue;
                MessageSender.sm("&b[\u62a5\u544a] &7\u4f60\u6240\u89c2\u6218\u7684\u7ade\u6280\u573a\u4e0a\u7684\u6bd4\u8d5b\u5df2\u7ed3\u675f\uff0c\u8bf7\u81ea\u884c\u4f20\u9001\u56de\u5bb6...", Bukkit.getPlayerExact((String)watcher));
            }
        }
        arena.finish();
        ArenaManager.busyArenasName.remove(arena.getName());
        switch (cause) {
            case COMMAND_STOP: {
                MessageSender.sm("&a[v]\u5df2\u5f3a\u5236\u505c\u6b62", finisher);
                MessageSender.sm("&b&l\u6bd4\u8d5b\u88ab\u7ba1\u7406\u5458\u5f3a\u5236\u7ed3\u675f\uff01\u672c\u5c40\u6bd4\u8d5b\u4e0d\u4f1a\u88ab\u8bb0\u5f55\uff01", player1, player2);
                break;
            }
            case COMMAND_STOP_ALL: {
                MessageSender.sm("&b&l\u6bd4\u8d5b\u88ab\u7ba1\u7406\u5458\u5f3a\u5236\u7ed3\u675f\uff01\u672c\u5c40\u6bd4\u8d5b\u4e0d\u4f1a\u88ab\u8bb0\u5f55\uff01", player1, player2);
                break;
            }
            case RELOAD_CONFIG: {
                MessageSender.sm("&a\u7531\u4e8e\u91cd\u8f7d\uff0c\u5f3a\u5236\u7ed3\u675f\u4e86\u7ade\u6280\u573a &2{editname} &a\u4e0a\u6b63\u5728\u8fdb\u884c\u7684\u6bd4\u8d5b", finisher, "editname", new String[]{arena.getName()});
                MessageSender.sm("&b&l\u6bd4\u8d5b\u56e0\u4e3a\u63d2\u4ef6\u914d\u7f6e\u6587\u4ef6\u7684\u91cd\u8f7d\u800c\u5f3a\u5236\u7ed3\u675f\uff01\u672c\u5c40\u6bd4\u8d5b\u4e0d\u4f1a\u88ab\u8bb0\u5f55\uff01", player1, player2);
                break;
            }
            case RELOAD_PLUGIN: {
                MessageSender.sm("&a\u7531\u4e8e\u63d2\u4ef6\u505c\u6b62\u8fd0\u884c\uff0c\u5f3a\u5236\u7ed3\u675f\u4e86\u7ade\u6280\u573a &2{editname} &a\u4e0a\u6b63\u5728\u8fdb\u884c\u7684\u6bd4\u8d5b", finisher, "editname", new String[]{arena.getName()});
                MessageSender.sm("&b&l\u6bd4\u8d5b\u56e0\u4e3a\u63d2\u4ef6\u505c\u6b62\u8fd0\u884c\u800c\u5f3a\u5236\u7ed3\u675f\uff01\u672c\u5c40\u6bd4\u8d5b\u4e0d\u4f1a\u88ab\u8bb0\u5f55\uff01", player1, player2);
            }
        }
    }

    public static enum CompulsoryEndCause {
        COMMAND_STOP,
        COMMAND_STOP_ALL,
        RELOAD_CONFIG,
        RELOAD_PLUGIN;

    }
}

