/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.data.encapsulation.RankingSign;
import com.valorin.data.encapsulation.RankingSkull;
import com.valorin.util.Debug;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class AreaCache {
    private Location lobbyLocation;
    private Location winRankingLocation;
    private Location KDRankingLocation;
    private List<RankingSkull> rankingSkullList;
    private List<RankingSign> rankingSignList;

    public AreaCache() {
        try {
            this.lobbyLocation = Data.getLobbyLocation();
            this.winRankingLocation = Data.getHologramLocation(0);
            this.KDRankingLocation = Data.getHologramLocation(1);
            this.rankingSkullList = Data.getRankingSkullList();
            this.rankingSignList = Data.getRankingSignList();
            Debug.send("\u5927\u5385\u3001\u5168\u606f\u56fe\u3001\u6392\u884c\u5934\u9885\u3001\u6392\u884c\u6728\u724c\u4f4d\u7f6e\u7f13\u5b58\u5df2\u5c31\u7eea", "The caches of location of the lobby,hologram,skull for ranking and signs for ranking have been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u5927\u5385\u3001\u5168\u606f\u56fe\u3001\u6392\u884c\u5934\u9885\u3001\u6392\u884c\u6728\u724c\u4f4d\u7f6e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe caches of location of the lobby,hologram,skull for ranking and signs for ranking failed to initialize");
            e.printStackTrace();
        }
    }

    public Location getLobby() {
        return this.lobbyLocation;
    }

    public void setLobby(Location location) {
        this.lobbyLocation = location;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.setLobbyLocation(location));
    }

    public Location getWinRankingLocation() {
        return this.winRankingLocation;
    }

    public Location getKDRankingLocation() {
        return this.KDRankingLocation;
    }

    public void setWinRanking(Location location) {
        this.winRankingLocation = location;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.setHologramLocation(0, location));
    }

    public void setKDRanking(Location location) {
        this.KDRankingLocation = location;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.setHologramLocation(1, location));
    }

    public List<RankingSkull> getRankingSkullList() {
        return this.rankingSkullList;
    }

    public void addRankingSkull(String editName, String rankingType, int ranking, Location location) {
        this.rankingSkullList.add(new RankingSkull(editName, rankingType, ranking, location));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.addRankingSkull(editName, rankingType, ranking, location));
    }

    public void removeRankingSkull(String editName) {
        RankingSkull rankingSkullSelected = null;
        for (RankingSkull rankingSkull : this.rankingSkullList) {
            if (!rankingSkull.getEditName().equals(editName)) continue;
            rankingSkullSelected = rankingSkull;
            break;
        }
        if (rankingSkullSelected == null) {
            return;
        }
        this.rankingSkullList.remove(rankingSkullSelected);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.removeRankingSkull(editName));
    }

    public List<RankingSign> getRankingSignList() {
        return this.rankingSignList;
    }

    public void addRankingSign(String editName, String rankingType, int ranking, Location location, List<String> text) {
        this.rankingSignList.add(new RankingSign(editName, rankingType, ranking, location, text));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.addRankingSign(editName, rankingType, ranking, location, text));
    }

    public void removeRankingSign(String editName) {
        RankingSign rankingSignSelected = null;
        for (RankingSign rankingSign : this.rankingSignList) {
            if (!rankingSign.getEditName().equals(editName)) continue;
            rankingSignSelected = rankingSign;
            break;
        }
        if (rankingSignSelected == null) {
            return;
        }
        this.rankingSignList.remove(rankingSignSelected);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> Data.removeRankingSign(editName));
    }
}

