/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.data.encapsulation.ArenaInfo;
import com.valorin.util.Debug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class ArenaInfoCache {
    private final List<ArenaInfo> arenaInfoList = new ArrayList<ArenaInfo>();

    public ArenaInfoCache() {
        try {
            List<String> arenaNameList = Data.getArenas();
            for (String editName : arenaNameList) {
                String displayName = Data.getArenaDisplayName(editName);
                Location pointA = Data.getArenaPointA(editName);
                Location pointB = Data.getArenaPointB(editName);
                List<String> commandList = Data.getArenaCommands(editName);
                Location watchingPoint = Data.getArenaWatchingPoint(editName);
                boolean isKitMode = Data.isArenaKitEnable(editName);
                List<ItemStack> kit = null;
                if (isKitMode) {
                    kit = Data.getArenaKit(editName);
                }
                ArenaInfo arenaInfo = new ArenaInfo(editName, displayName, pointA, pointB, commandList, watchingPoint, kit);
                this.arenaInfoList.add(arenaInfo);
            }
            Debug.send("\u7ade\u6280\u573a\u4fe1\u606f\u7f13\u5b58\u5df2\u5c31\u7eea", "The Arena info cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u7ade\u6280\u573a\u4fe1\u606f\u7f13\u5b58\u52a0\u8f7d\u5931\u8d25", "\u00a7cThe Arena info cache failed to initialize");
            e.printStackTrace();
        }
    }

    public void saveArena(String editName, String displayName, Location pointA, Location pointB) {
        ArenaInfo arenaInfo = new ArenaInfo(editName, displayName, pointA, pointB, null, null, null);
        this.arenaInfoList.add(arenaInfo);
        Main.getInstance().getMatchingHandler().addMatching(arenaInfo);
        Data.saveArena(editName, displayName, pointA, pointB);
    }

    public void deleteArena(String editName) {
        ArenaInfo arenaInfo = this.get(editName);
        if (arenaInfo != null) {
            this.arenaInfoList.remove(arenaInfo);
            Main.getInstance().getMatchingHandler().removeMatching(arenaInfo);
            Data.deleteArena(arenaInfo.getEditName());
        }
    }

    public ArenaInfo get(String editName) {
        for (ArenaInfo arenaInfo : this.arenaInfoList) {
            if (!arenaInfo.getEditName().equals(editName)) continue;
            return arenaInfo;
        }
        return null;
    }

    public int size() {
        return this.arenaInfoList.size();
    }

    public void setCommandList(String editName, List<String> commandList) {
        int index = -1;
        for (ArenaInfo arenaInfo : this.arenaInfoList) {
            ++index;
            if (!arenaInfo.getEditName().equals(editName)) continue;
            break;
        }
        if (index != -1) {
            List<String> list = commandList;
            if (list == null) {
                list = new ArrayList<String>();
            }
            this.arenaInfoList.get(index).setCommandList(list);
            Data.setArenaCommands(editName, list);
        }
    }

    public void setWatchingPoint(String editName, Location watchingPoint) {
        int index = -1;
        for (ArenaInfo arenaInfo : this.arenaInfoList) {
            ++index;
            if (!arenaInfo.getEditName().equals(editName)) continue;
            break;
        }
        if (index != -1) {
            this.arenaInfoList.get(index).setWatchingPoint(watchingPoint);
            Data.setArenaWatchingPoint(editName, watchingPoint);
        }
    }

    public void setKit(String editName, List<ItemStack> kit) {
        int index = -1;
        for (ArenaInfo arenaInfo : this.arenaInfoList) {
            ++index;
            if (!arenaInfo.getEditName().equals(editName)) continue;
            break;
        }
        if (index != -1) {
            this.arenaInfoList.get(index).setKit(kit);
            Data.setArenaKit(editName, kit);
        }
    }

    public void setKitEnable(String editName, boolean enable) {
        int index = -1;
        for (ArenaInfo arenaInfo : this.arenaInfoList) {
            ++index;
            if (!arenaInfo.getEditName().equals(editName)) continue;
            break;
        }
        if (index != -1) {
            this.arenaInfoList.get(index).setKitMode(enable);
            Data.setArenaKitEnable(editName, enable);
        }
    }

    public List<ArenaInfo> getArenaInfoList() {
        return this.arenaInfoList;
    }
}

