/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.caches.AreaCache;
import com.valorin.caches.ArenaInfoCache;
import com.valorin.caches.BlacklistCache;
import com.valorin.caches.DanCache;
import com.valorin.caches.EnergyCache;
import com.valorin.caches.LanguageFileCache;
import com.valorin.caches.PointCache;
import com.valorin.caches.RankingCache;
import com.valorin.caches.RecordCache;
import com.valorin.caches.ShopCache;
import com.valorin.util.Debug;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CacheHandler {
    private AreaCache areaCache;
    private ArenaInfoCache arenaInfoCache;
    private BlacklistCache blacklistCache;
    private DanCache danCache;
    private EnergyCache energyCache;
    private LanguageFileCache languageFileCache;
    private PointCache pointCache;
    private RankingCache rankingCache;
    private RecordCache recordCache;
    private ShopCache shopCache;
    private int taskId = -1;

    public CacheHandler(Action action) {
        this.load(action);
    }

    public void load(Action action) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            long start = System.currentTimeMillis();
            Debug.send("\u5f00\u59cb\u8f7d\u5165\u7f13\u5b58", "The Caches loading...");
            this.areaCache = new AreaCache();
            this.arenaInfoCache = new ArenaInfoCache();
            this.blacklistCache = new BlacklistCache();
            this.danCache = new DanCache();
            this.energyCache = new EnergyCache();
            this.languageFileCache = new LanguageFileCache();
            this.pointCache = new PointCache();
            this.rankingCache = new RankingCache();
            this.recordCache = new RecordCache();
            this.shopCache = new ShopCache();
            long end = System.currentTimeMillis();
            Debug.send("\u6240\u6709\u7f13\u5b58\u5df2\u5c31\u7eea\uff0c\u8017\u65f6" + (end - start) + "ms", "All the caches was loaded successfully in " + (end - start) + "ms");
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), action::run);
        });
        int interval = Main.getInstance().getConfigManager().getAutoSaveCachesTime();
        interval = interval <= 10 ? 200 : (interval *= 20);
        new BukkitRunnable(){

            public void run() {
                if (CacheHandler.this.taskId == -1) {
                    CacheHandler.this.taskId = this.getTaskId();
                } else {
                    CacheHandler.this.energyCache.save(true);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 0L, (long)interval);
    }

    public void unload() {
        try {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
            this.energyCache.cancelTimer();
            this.energyCache.save(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AreaCache getArea() {
        return this.areaCache;
    }

    public ArenaInfoCache getArenaInfo() {
        return this.arenaInfoCache;
    }

    public BlacklistCache getBlacklist() {
        return this.blacklistCache;
    }

    public DanCache getDan() {
        return this.danCache;
    }

    public EnergyCache getEnergy() {
        return this.energyCache;
    }

    public LanguageFileCache getLanguageFile() {
        return this.languageFileCache;
    }

    public PointCache getPoint() {
        return this.pointCache;
    }

    public RankingCache getRanking() {
        return this.rankingCache;
    }

    public RecordCache getRecord() {
        return this.recordCache;
    }

    public ShopCache getShop() {
        return this.shopCache;
    }

    public void reloadCache(CacheType cacheType) {
        Debug.send("\u5f00\u59cb\u91cd\u8f7d\u7f13\u5b58\u6a21\u5757\uff1a" + (Object)((Object)cacheType), "Reloading the cache " + (Object)((Object)cacheType));
        switch (cacheType) {
            case AREA: {
                this.areaCache = new AreaCache();
                break;
            }
            case ARENA_INFO: {
                this.arenaInfoCache = new ArenaInfoCache();
                break;
            }
            case BLACKLIST: {
                this.blacklistCache = new BlacklistCache();
                break;
            }
            case DAN: {
                this.danCache = new DanCache();
                break;
            }
            case ENERGY: {
                this.unload();
                this.energyCache = new EnergyCache();
                break;
            }
            case LANGUAGE_FILE: {
                this.languageFileCache = new LanguageFileCache();
                break;
            }
            case POINT: {
                this.pointCache = new PointCache();
                break;
            }
            case RANKING: {
                this.rankingCache = new RankingCache();
                break;
            }
            case RECORD: {
                this.recordCache = new RecordCache();
                break;
            }
            case SHOP: {
                this.shopCache = new ShopCache();
            }
        }
    }

    public static interface Action {
        public void run();
    }

    public static enum CacheType {
        AREA,
        ARENA_INFO,
        BLACKLIST,
        DAN,
        ENERGY,
        LANGUAGE_FILE,
        POINT,
        RANKING,
        RECORD,
        SHOP;

    }
}

