/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.api.event.EnergyChangedEvent;
import com.valorin.configuration.DataFile;
import com.valorin.data.Data;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EnergyCache {
    private final Map<String, Double> map = new HashMap<String, Double>();
    private BukkitTask timer;
    private double maxEnergy;
    private double energyNeeded;
    private double energyResumePerSecond;
    private final boolean isEnable = Main.getInstance().getConfigManager().isEnergyEnabled();

    public EnergyCache() {
        if (!this.isEnable) {
            return;
        }
        try {
            for (Player player : ViaVersion.getOnlinePlayers()) {
                this.load(player.getName());
            }
            if (!Data.energyB) {
                Debug.send("\u5f00\u59cb\u68c0\u6d4b\u591a\u4f59\u7684\u79bb\u7ebf\u73a9\u5bb6\u7cbe\u529b\u503c\u6570\u636e", "Detecting the redundant energy data of offline players");
                Set playerNames = DataFile.playerData.getKeys(false);
                int number = 0;
                for (String playerName : playerNames) {
                    if (DataFile.playerData.contains(playerName + ".Exp") || DataFile.playerData.getDouble(playerName + ".Energy") != Main.getInstance().getConfigManager().getMaxEnergy()) continue;
                    DataFile.playerData.set(playerName, null);
                    ++number;
                }
                if (number != 0) {
                    DataFile.savePlayerData();
                    Debug.send("\u6e05\u9664\u4e86" + number + "\u4e2a\u591a\u4f59\u7684\u7cbe\u529b\u503c\u6570\u636e", number + " redundant data of energy was cleared");
                } else {
                    Debug.send("\u5f88\u597d\uff01\u6ca1\u6709\u53d1\u73b0\u591a\u4f59\u7684\u7cbe\u529b\u503c\u6570\u636e", "Good!No redundant data of energy was found!");
                }
            }
            Debug.send("\u7cbe\u529b\u503c\u6570\u636e\u7f13\u5b58\u5df2\u5c31\u7eea", "The energy cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u7cbe\u529b\u503c\u6570\u636e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe energy cache failed to initialize");
            e.printStackTrace();
        }
        this.maxEnergy = Main.getInstance().getConfigManager().getMaxEnergy();
        if (this.maxEnergy <= 0.0) {
            this.maxEnergy = 300.0;
        }
        this.energyNeeded = Main.getInstance().getConfigManager().getEnergyNeeded();
        if (this.energyNeeded <= 0.0) {
            this.energyNeeded = 90.0;
        }
        this.energyResumePerSecond = Main.getInstance().getConfigManager().getEnergyResumePerSecond();
        if (this.energyResumePerSecond <= 0.0) {
            this.energyResumePerSecond = 0.5;
        }
        this.timer = new BukkitRunnable(){

            public void run() {
                for (String name : new HashMap(EnergyCache.this.map).keySet()) {
                    if (!EnergyCache.this.map.containsKey(name)) {
                        EnergyCache.this.map.put(name, EnergyCache.this.maxEnergy);
                    }
                    double energyNow = (Double)EnergyCache.this.map.get(name);
                    if (EnergyCache.this.maxEnergy - energyNow <= EnergyCache.this.energyResumePerSecond) {
                        EnergyCache.this.map.put(name, EnergyCache.this.maxEnergy);
                        continue;
                    }
                    EnergyCache.this.map.put(name, energyNow + EnergyCache.this.energyResumePerSecond);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 20L, 20L);
    }

    public double get(String name) {
        try {
            return this.map.get(name);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void load(String name) {
        if (!this.map.containsKey(name)) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> this.map.put(name, Main.getInstance().getConfigManager().getMaxEnergy()));
        }
    }

    public void save(boolean isAsynchronously) {
        if (!this.isEnable) {
            return;
        }
        for (String name : this.map.keySet()) {
            Data.setEnergy(name, this.map.get(name), isAsynchronously);
        }
        Debug.send("\u7cbe\u529b\u503c\u6570\u636e\u5df2\u81ea\u52a8\u4fdd\u5b58", "The energy data saved automatically");
    }

    public void set(String name, double energy) {
        if (!this.map.containsKey(name)) {
            this.map.put(name, 0.0);
        }
        double log = this.map.get(name);
        this.map.put(name, energy);
        if (Bukkit.getPlayer((String)name) != null && Bukkit.getPlayer((String)name).isOnline()) {
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                EnergyChangedEvent event = new EnergyChangedEvent(Bukkit.getPlayer((String)name), log, energy);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            });
        }
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public double getEnergyNeeded() {
        return this.energyNeeded;
    }

    public double getEnergyResumePerSecond() {
        return this.energyResumePerSecond;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void cancelTimer() {
        if (!this.isEnable) {
            return;
        }
        this.timer.cancel();
    }
}

