/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PointCache {
    private final Map<String, Double> map = new HashMap<String, Double>();

    public PointCache() {
        try {
            for (Player player : ViaVersion.getOnlinePlayers()) {
                this.load(player.getName());
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                this.load(player.getName());
            }
            Debug.send("\u79ef\u5206\u6570\u636e\u7f13\u5b58\u5df2\u5c31\u7eea", "The points cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u79ef\u5206\u6570\u636e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe points cache failed to initialize");
            e.printStackTrace();
        }
    }

    public double get(String name) {
        try {
            return this.map.get(name);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void load(String name) {
        if (!this.map.containsKey(name)) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
                double points = Data.getPoint(name);
                this.map.put(name, points);
            });
        }
    }

    public void set(String name, double points) {
        this.map.put(name, points);
        Data.setPoint(name, this.map.get(name), true);
    }
}

