/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.data.encapsulation.Record;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RecordCache {
    private final Map<String, List<Record>> recordMap = new HashMap<String, List<Record>>();
    private final Map<String, Integer> winsMap = new HashMap<String, Integer>();
    private final Map<String, Integer> losesMap = new HashMap<String, Integer>();
    private final Map<String, Integer> drawsMap = new HashMap<String, Integer>();
    private final Map<String, Integer> winningStreakTimesMap = new HashMap<String, Integer>();
    private final Map<String, Integer> maxWinningStreakTimesMap = new HashMap<String, Integer>();
    private int serverTotalGameTimes = -1;

    public RecordCache() {
        try {
            for (Player player : ViaVersion.getOnlinePlayers()) {
                this.load(player.getName(), null);
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
                int serverTotalGameTimes = 0;
                for (Player player : ViaVersion.getOnlinePlayers()) {
                    String name = player.getName();
                    int wins = Data.getWins(name);
                    int loses = Data.getLoses(name);
                    int draws = Data.getDraws(name);
                    int playerTotalGameTime = wins + loses + draws;
                    serverTotalGameTimes += playerTotalGameTime;
                }
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    String name = player.getName();
                    boolean b = false;
                    for (Player onlinePlayer : ViaVersion.getOnlinePlayers()) {
                        if (!onlinePlayer.getName().equals(name)) continue;
                        b = true;
                        break;
                    }
                    if (b) continue;
                    int wins = Data.getWins(name);
                    int loses = Data.getLoses(name);
                    int draws = Data.getDraws(name);
                    int playerTotalGameTime = wins + loses + draws;
                    serverTotalGameTimes += playerTotalGameTime;
                }
                this.serverTotalGameTimes = serverTotalGameTimes / 2;
            });
            Debug.send("\u6bd4\u8d5b\u8bb0\u5f55\u6570\u636e\u7f13\u5b58\u5df2\u5c31\u7eea", "The record cache has been initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
            Debug.send("\u00a7c\u6bd4\u8d5b\u8bb0\u5f55\u6570\u636e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe record cache failed to initialize");
        }
    }

    public List<Record> getRecords(String name) {
        return this.recordMap.get(name);
    }

    public int getWins(String name) {
        return this.winsMap.getOrDefault(name, 0);
    }

    public int getLoses(String name) {
        return this.losesMap.getOrDefault(name, 0);
    }

    public int getDraws(String name) {
        return this.drawsMap.getOrDefault(name, 0);
    }

    public int getGameTimes(String name) {
        try {
            return this.recordMap.get(name).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getWinningStreakTimes(String name) {
        return this.winningStreakTimesMap.getOrDefault(name, 0);
    }

    public int getMaxWinningStreakTimes(String name) {
        return this.maxWinningStreakTimesMap.getOrDefault(name, 0);
    }

    public Record getLast(String name) {
        try {
            if (this.getGameTimes(name) == 0) {
                return null;
            }
            return this.recordMap.get(name).get(this.getGameTimes(name) - 1);
        }
        catch (Exception e) {
            return new Record("Loading...", "Loading...", "Loading...", "Loading...", 0, 0.0, 0.0, 0, 0, 0, "Loading...");
        }
    }

    public void addWins(String name) {
        int value = this.getWins(name) + 1;
        this.winsMap.put(name, value);
        Data.setWins(name, value);
    }

    public void addLoses(String name) {
        int value = this.getLoses(name) + 1;
        this.losesMap.put(name, value);
        Data.setLoses(name, value);
    }

    public void addDraws(String name) {
        int value = this.getDraws(name) + 1;
        this.drawsMap.put(name, value);
        Data.setDraws(name, value);
    }

    public void addWinningStreakTimes(String name) {
        int value = this.getWinningStreakTimes(name) + 1;
        this.winningStreakTimesMap.put(name, value);
        Data.setWinningStreakTimes(name, value);
    }

    public void addMaxWinningStreakTimes(String name) {
        int value = this.getMaxWinningStreakTimes(name) + 1;
        this.maxWinningStreakTimesMap.put(name, value);
        Data.setMaxWinningStreakTimes(name, value);
    }

    public void clearWinningStreakTimes(String name) {
        this.winningStreakTimesMap.put(name, 0);
        Data.setWinningStreakTimes(name, 0);
    }

    public void load(String name, Action action) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            if (!this.recordMap.containsKey(name)) {
                List<Record> recordList = Data.getRecordList(name);
                int wins = Data.getWins(name);
                int loses = Data.getLoses(name);
                int draws = Data.getDraws(name);
                int winningStreakTimes = Data.getWinningStreakTimes(name);
                int maxWinningStreakTimes = Data.getMaxWinningStreakTimes(name);
                this.recordMap.put(name, recordList);
                this.winsMap.put(name, wins);
                this.losesMap.put(name, loses);
                this.drawsMap.put(name, draws);
                this.winningStreakTimesMap.put(name, winningStreakTimes);
                this.maxWinningStreakTimesMap.put(name, maxWinningStreakTimes);
                Data.initialRecordData(name);
            }
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                if (action == null) {
                    return;
                }
                action.run();
            });
        });
    }

    public void unload(String name) {
        this.recordMap.remove(name);
        this.winsMap.remove(name);
        this.losesMap.remove(name);
        this.drawsMap.remove(name);
        this.winningStreakTimesMap.remove(name);
        this.maxWinningStreakTimesMap.remove(name);
    }

    public void add(String name, String date, String opponent, String server, int time, double damage, double maxDamage, int result, int startWay, int expChange, String arenaEditName) {
        if (this.recordMap.containsKey(name)) {
            this.recordMap.get(name).add(new Record(name, date, opponent, server, time, damage, maxDamage, result, startWay, expChange, arenaEditName));
            Data.addRecord(name, date, opponent, server, time, damage, maxDamage, result, startWay, expChange, arenaEditName);
        }
    }

    public int getServerTotalGameTimes() {
        return this.serverTotalGameTimes;
    }

    public void refreshServerTotalGameTimes() {
        ++this.serverTotalGameTimes;
    }

    public static interface Action {
        public void run();
    }
}

