/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.commands;

public class SimilarityComparer {
    public static final String[] SUBCOMMANDS = new String[]{"help", "start", "timetable", "ainfo", "send", "accept", "deny", "quit", "shop", "records", "points", "rank", "lobby", "dan", "energy", "watch", "changelang", "arena", "hd", "stop", "game", "reload", "checkv", "sendall", "transfer", "rankingskull", "rankingsign", "stopall"};

    public static float getSubCommandSimilarity(String enter, String subcommand) {
        int j;
        int i;
        int n = enter.length();
        int m = subcommand.length();
        if (n == 0 || m == 0) {
            return 0.0f;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char ch1 = enter.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char ch2 = subcommand.charAt(j - 1);
                int temp = ch1 == ch2 || ch1 + 32 == ch2 || ch2 + 32 == ch1 ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + temp);
            }
        }
        return (1.0f - (float)d[n][m] / (float)Math.max(enter.length(), subcommand.length())) * 100.0f;
    }

    public static String getMostSimilarSubCommand(String enter) {
        String mostSimilarSubCommand = null;
        float similarity = 0.0f;
        for (String subCommand : SUBCOMMANDS) {
            float t = SimilarityComparer.getSubCommandSimilarity(enter, subCommand);
            if (!(t > similarity)) continue;
            similarity = t;
            mostSimilarSubCommand = subCommand;
        }
        return mostSimilarSubCommand;
    }
}

