/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.configuration;

import com.google.common.base.Charsets;
import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.util.ViaVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    public FileConfiguration config;
    public List<String> loreLimitedList;
    public List<String> displayNameLimitedList;

    public ConfigManager() {
        this.reload();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void reload() {
        try {
            YamlConfiguration config = new YamlConfiguration();
            File file = new File(Main.getInstance().getDataFolder(), "config.yml");
            if (!file.exists()) {
                Main.getInstance().saveResource("config.yml", false);
            }
            try {
                config.load((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), Charsets.UTF_8)));
            }
            catch (Exception e) {
                config.load((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]))));
            }
            this.config = config;
            List rawLoreLimitedList = config.getStringList("Game.Start.ItemLimit.Lore");
            ArrayList<String> loreLimitedList = new ArrayList<String>();
            for (String rawLoreLimited : rawLoreLimitedList) {
                loreLimitedList.add(rawLoreLimited.replace("&", "\u00a7"));
            }
            this.loreLimitedList = loreLimitedList;
            List rawDisplayNameLimitedList = config.getStringList("Game.Start.ItemLimit.DisplayName");
            ArrayList<String> displayNameLimitedList = new ArrayList<String>();
            for (String rawDisplayNameLimited : rawDisplayNameLimitedList) {
                displayNameLimitedList.add(rawDisplayNameLimited.replace("&", "\u00a7"));
            }
            this.displayNameLimitedList = displayNameLimitedList;
            YamlConfiguration symbols = new YamlConfiguration();
            File file2 = new File(Main.getInstance().getDataFolder(), "symbols.yml");
            if (!file2.exists()) {
                Main.getInstance().saveResource("symbols.yml", false);
            }
            if (ViaVersion.isHasItemFlagMethod()) {
                symbols.load((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]), Charsets.UTF_8)));
            } else {
                symbols.load((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Data.initialB(this);
    }

    public int getConfigVersion() {
        return this.config.getInt("ConfigVersion");
    }

    public boolean isCheckVersion() {
        return this.config.getBoolean("CheckVersion");
    }

    public String getServerName() {
        String s = this.config.getString("ServerName");
        if (s != null) {
            s = s.replace("&", "\u00a7");
        }
        return s;
    }

    public boolean isDebug() {
        return this.config.getBoolean("Debug");
    }

    public int getAutoSaveCachesTime() {
        return this.config.getInt("AutoSaveCachesTime");
    }

    public String getPrefix() {
        return this.config.getString("Message.Prefix").replace("&", "\u00a7");
    }

    public String getDefaultLanguage() {
        return this.config.getString("Message.Lang");
    }

    public boolean isUseMySQL() {
        return this.config.getBoolean("MySQL.Enable");
    }

    public String getMySQLURL() {
        return this.config.getString("MySQL.URL");
    }

    public String getMySQLUser() {
        return this.config.getString("MySQL.User");
    }

    public String getMySQLPassword() {
        return this.config.getString("MySQL.Password");
    }

    public boolean isAreaUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Area");
    }

    public boolean isBlacklistUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Blacklist");
    }

    public boolean isDanUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Dan");
    }

    public boolean isEnergyUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Energy");
    }

    public boolean isLanguageFileUseMySQL() {
        return this.config.getBoolean("MySQL.Function.LanguageFile");
    }

    public boolean isPointUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Point");
    }

    public boolean isPointShopUseMySQL() {
        return this.config.getBoolean("MySQL.Function.PointShop");
    }

    public boolean isRecordUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Record");
    }

    public boolean isSeasonUseMySQL() {
        return this.config.getBoolean("MySQL.Function.Season");
    }

    public boolean isEnergyEnabled() {
        return this.config.getBoolean("Energy.Enable");
    }

    public double getEnergyNeeded() {
        return this.config.getDouble("Energy.Need");
    }

    public double getMaxEnergy() {
        return this.config.getDouble("Energy.Max");
    }

    public double getEnergyResumePerSecond() {
        return this.config.getDouble("Energy.PerSecond");
    }

    public boolean isWorldWhitelistEnabled() {
        return this.config.getBoolean("WorldWhitelist.Enable");
    }

    public List<String> getWorldWhitelist() {
        return this.config.getStringList("WorldWhitelist.Worlds");
    }

    public String getHologramPluginUsed() {
        return this.config.getString("Hologram.Plugin");
    }

    public int getHologramRefreshInterval() {
        return this.config.getInt("Hologram.RefreshInterval");
    }

    public String getArenaCreatingToolMaterial() {
        return this.config.getString("Game.ArenaCreating.CreatingToolMaterial");
    }

    public List<String> getSearchingTimeTable() {
        return this.config.getStringList("Game.Start.Timetable.Searching");
    }

    public List<String> getInviteTimeTable() {
        return this.config.getStringList("Game.Start.Timetable.Invite");
    }

    public boolean isClickPlayerToSendRequestAllowed() {
        return this.config.getBoolean("Game.Start.ClickPlayerToSendRequest");
    }

    public List<String> getItemLimitByMaterial() {
        return this.config.getStringList("Game.Start.ItemLimit.Material");
    }

    public List<String> getItemLimitByLore() {
        return this.loreLimitedList;
    }

    public List<String> getItemLimitByDisplayName() {
        return this.displayNameLimitedList;
    }

    public int getBroadcastWinningStreakTimes() {
        return this.config.getInt("Game.Finish.BroadcastWinningStreakTimes");
    }

    public int getProtectionExp() {
        return this.config.getInt("Game.Finish.ProtectionExp");
    }

    public double getPointsAwardedByPanel() {
        return this.config.getDouble("Game.Rewards.Panel.Points");
    }

    public int getExpAwardedByPanel() {
        return this.config.getInt("Game.Rewards.Panel.WinExp");
    }

    public int getMaxExpAwardedByPanel() {
        return this.config.getInt("Game.Rewards.Panel.MaxExp");
    }

    public int getDrawExpAwardedByPanel() {
        return this.config.getInt("Game.Rewards.Panel.DrawExp");
    }

    public boolean isFireworkAwardedByPanel() {
        return this.config.getBoolean("Game.Rewards.Panel.Firework");
    }

    public boolean isBroadcastByPanel() {
        return this.config.getBoolean("Game.Rewards.Panel.Broadcast");
    }

    public double getPointsAwardedByInviting() {
        return this.config.getDouble("Game.Rewards.Inviting.Points");
    }

    public int getExpAwardedByInviting() {
        return this.config.getInt("Game.Rewards.Inviting.WinExp");
    }

    public int getMaxExpAwardedByInviting() {
        return this.config.getInt("Game.Rewards.Inviting.MaxExp");
    }

    public int getDrawExpAwardedByInviting() {
        return this.config.getInt("Game.Rewards.Inviting.DrawExp");
    }

    public boolean isFireworkAwardedByInviting() {
        return this.config.getBoolean("Game.Rewards.Inviting.Firework");
    }

    public boolean isBroadcastByInviting() {
        return this.config.getBoolean("Game.Rewards.Inviting.Broadcast");
    }

    public double getPointsAwardedByCompulsion() {
        return this.config.getDouble("Game.Rewards.Compulsion.Points");
    }

    public int getExpAwardedByCompulsion() {
        return this.config.getInt("Game.Rewards.Compulsion.WinExp");
    }

    public int getMaxExpAwardedByCompulsion() {
        return this.config.getInt("Game.Rewards.Compulsion.MaxExp");
    }

    public int getDrawExpAwardedByCompulsion() {
        return this.config.getInt("Game.Rewards.Compulsion.DrawExp");
    }

    public boolean isFireworkAwardedByCompulsion() {
        return this.config.getBoolean("Game.Rewards.Compulsion.Firework");
    }

    public boolean isBroadcastByCompulsion() {
        return this.config.getBoolean("Game.Rewards.Compulsion.Broadcast");
    }

    public boolean isDanShowed() {
        return this.config.getBoolean("Dan.Settings.Show");
    }

    public boolean isChangeGameModeWhenGameStarts() {
        return this.config.getBoolean("Game.Start.ChangeGameMode");
    }

    public String getInitialDanName() {
        String str = this.config.getString("Dan.Settings.InitialDanName");
        if (str != null) {
            str = str.replace("&", "\u00a7");
        }
        return str;
    }

    public int getTeleportCountDown() {
        return this.config.getInt("Game.Finish.TeleportCountDown");
    }

    public int getPointsDeductedByPanel() {
        return this.config.getInt("Game.Rewards.Panel.PointsDeducted");
    }

    public int getPointsDeductedByInviting() {
        return this.config.getInt("Game.Rewards.Inviting.PointsDeducted");
    }

    public int getPointsDeductedByCompulsion() {
        return this.config.getInt("Game.Rewards.Compulsion.PointsDeducted");
    }

    public boolean isOpeningChestAllowed() {
        return this.config.getBoolean("Game.Process.IsOpeningChestAllowed");
    }

    public boolean isOpeningEnderChestAllowed() {
        return this.config.getBoolean("Game.Process.IsOpeningEnderChestAllowed");
    }

    public boolean isProjectileProtectionEnabled() {
        return this.config.getBoolean("Game.Process.EnableProjectileProtection");
    }

    public boolean isAutoRespawnEnable() {
        return this.config.getBoolean("Game.Finish.AutoRespawn.Enable");
    }

    public AutoRespawnWay getAutoRespawnWay() {
        AutoRespawnWay way = AutoRespawnWay.SPIGOT;
        String configWay = this.config.getString("Game.Finish.AutoRespawn.Way");
        if (configWay.equalsIgnoreCase("SETHEALTH")) {
            way = AutoRespawnWay.SETHEALTH;
        }
        return way;
    }

    public int getGameTimeOut() {
        int time = this.config.getInt("Game.Process.TimeOut");
        time = Math.max(time, 5);
        return time;
    }

    public boolean isTimeOutHandlingSchemeEnabled() {
        return this.config.getBoolean("Game.Finish.TimeOutHandlingScheme.Enable");
    }

    public TimeOutHandlingScheme getTimeOutHandlingScheme() {
        TimeOutHandlingScheme scheme = TimeOutHandlingScheme.COMPARE_HEALTH_VALUE;
        String configScheme = this.config.getString("Game.Finish.TimeOutHandlingScheme.Scheme");
        if (configScheme.equalsIgnoreCase("COMPARE_HEALTH_PERCENTAGE")) {
            scheme = TimeOutHandlingScheme.COMPARE_HEALTH_PERCENTAGE;
        }
        return scheme;
    }

    public List<String> getCommandWhitelist() {
        return this.config.getStringList("Game.Process.CommandWhitelist");
    }

    public int getSkullRefreshInterval() {
        return this.config.getInt("Skull.RefreshInterval");
    }

    public int getSignRefreshInterval() {
        return this.config.getInt("Sign.RefreshInterval");
    }

    public boolean isTeleportationTriggeredByOtherPluginAllowed() {
        return this.config.getBoolean("Game.Process.IsTeleportationTriggeredByOtherPluginAllowed");
    }

    public static enum AutoRespawnWay {
        SPIGOT,
        SETHEALTH;

    }

    public static enum TimeOutHandlingScheme {
        COMPARE_HEALTH_VALUE,
        COMPARE_HEALTH_PERCENTAGE;

    }
}

