/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.event.game;

import com.valorin.Main;
import com.valorin.arenas.Arena;
import com.valorin.arenas.ArenaManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public class EventProtection
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void routineProtection(EntityDamageByEntityEvent e) {
        if (e.getEntity() instanceof Player && e.getDamager() instanceof Player) {
            Player bearer = (Player)e.getEntity();
            Player attacker = (Player)e.getDamager();
            String bearerName = bearer.getName();
            ArenaManager arenaManager = Main.getInstance().getArenaManager();
            if (!arenaManager.isPlayerBusy(bearerName)) {
                if (arenaManager.isPlayerBusy(attacker.getName())) {
                    e.setCancelled(true);
                }
            } else {
                Arena arena = arenaManager.getArena(arenaManager.getPlayerOfArena(bearerName));
                String theOther = arena.getTheOtherPlayer(bearerName);
                if (attacker.getName().equals(theOther)) {
                    if (arena.getStage() == 0) {
                        MessageSender.sm("&7\u6218\u6597\u672a\u5f00\u59cb...", attacker);
                        e.setCancelled(true);
                    }
                } else if (Main.getInstance().getConfigManager().isDebug()) {
                    Debug.send("routineProtection\uff1a" + attacker.getName() + " " + theOther + " " + bearerName + " " + arenaManager.getArena(arenaManager.getPlayerOfArena(bearerName)).getName() + " " + arenaManager.getArena(arenaManager.getPlayerOfArena(attacker.getName())).getName(), null);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void projectileProtection(EntityDamageByEntityEvent e) {
        Arena arena;
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player bearer = (Player)e.getEntity();
        String bearerName = bearer.getName();
        ArenaManager arenaManager = Main.getInstance().getArenaManager();
        if (!Main.getInstance().getConfigManager().isProjectileProtectionEnabled() && arenaManager.isPlayerBusy(bearerName) && (arena = arenaManager.getArena(arenaManager.getPlayerOfArena(bearerName))).getStage() == 1) {
            return;
        }
        ProjectileSource shooter = null;
        Entity projectileEntity = e.getDamager();
        if (projectileEntity instanceof Arrow) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "Arrow");
        } else if (projectileEntity instanceof FishHook) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "FishHook");
        } else if (projectileEntity instanceof Snowball) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "Snowball");
        } else if (projectileEntity instanceof Fireball) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "Fireball");
        } else if (projectileEntity.toString().equals("CraftSplashPotion")) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "ThrownPotion");
        } else if (projectileEntity.toString().equals("CraftTrident")) {
            shooter = ViaVersion.getProjectileSource(projectileEntity, "Trident");
        }
        if (shooter == null) {
            return;
        }
        if (!arenaManager.isPlayerBusy(bearerName)) {
            Player shooterPlayer;
            String shooterPlayerName;
            if (shooter instanceof Player && arenaManager.isPlayerBusy(shooterPlayerName = (shooterPlayer = (Player)shooter).getName())) {
                e.setCancelled(true);
            }
        } else if (!(shooter instanceof Player)) {
            e.setCancelled(true);
        } else {
            Arena arena2 = arenaManager.getArena(arenaManager.getPlayerOfArena(bearerName));
            String theOther = arena2.getTheOtherPlayer(bearerName);
            Player shooterPlayer = (Player)shooter;
            if (shooterPlayer.getName().equals(theOther)) {
                if (arena2.getStage() == 0) {
                    MessageSender.sm("&7\u6218\u6597\u672a\u5f00\u59cb...", shooterPlayer);
                    e.setCancelled(true);
                }
            } else if (!shooterPlayer.getName().equals(bearerName) && Main.getInstance().getConfigManager().isDebug()) {
                Debug.send("projectileProtection\uff1a" + shooterPlayer.getName() + " " + theOther + " " + bearerName + " " + arenaManager.getArena(arenaManager.getPlayerOfArena(bearerName)).getName() + " " + arenaManager.getArena(arenaManager.getPlayerOfArena(shooterPlayer.getName())).getName(), null);
            }
        }
    }
}

