/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.event.gui;

import com.valorin.Main;
import com.valorin.api.event.ShopEvent;
import com.valorin.caches.PointCache;
import com.valorin.caches.ShopCache;
import com.valorin.commands.sub.CMDShop;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DanHandler;
import com.valorin.data.encapsulation.Good;
import com.valorin.inventory.INVShop;
import com.valorin.util.ItemGiver;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EventShopGUI
implements Listener {
    public static void executeGoodCommands(final Good good, final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (good.getCommands() != null && good.getCommands().size() != 0) {
                    List<String> commands = good.getCommands();
                    for (String command : commands) {
                        String way = command.split("\\|")[0];
                        String c = command.split("\\|")[1];
                        if (way.equalsIgnoreCase("op")) {
                            try {
                                if (player.isOp()) {
                                    Bukkit.dispatchCommand((CommandSender)player, (String)c.replace("{player}", player.getName()));
                                } else {
                                    player.setOp(true);
                                    Bukkit.dispatchCommand((CommandSender)player, (String)c.replace("{player}", player.getName()));
                                    player.setOp(false);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                MessageSender.sm("&c[x]\u6267\u884c&eOP&c\u8eab\u4efd\u7684\u8d2d\u4e70\u5546\u54c1\u540e\u89e6\u53d1\u7684\u6307\u4ee4\u65f6\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u7ba1\u7406\u5458\u6dfb\u52a0\u7684\u6307\u4ee4\u4e0d\u59a5\uff0c\u8bf7\u622a\u6b64\u56fe\u8054\u7cfb\u7ba1\u7406\u5458", player);
                            }
                        }
                        if (way.equalsIgnoreCase("player")) {
                            try {
                                Bukkit.dispatchCommand((CommandSender)player, (String)c.replace("{player}", player.getName()));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                MessageSender.sm("&c[x]\u6267\u884c&e\u73a9\u5bb6&c\u8eab\u4efd\u7684\u8d2d\u4e70\u5546\u54c1\u540e\u89e6\u53d1\u7684\u6307\u4ee4\u65f6\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u7ba1\u7406\u5458\u6dfb\u52a0\u7684\u6307\u4ee4\u4e0d\u59a5\uff0c\u8bf7\u622a\u6b64\u56fe\u8054\u7cfb\u7ba1\u7406\u5458", player);
                            }
                        }
                        if (!way.equalsIgnoreCase("console")) continue;
                        try {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)c.replace("{player}", player.getName()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageSender.sm("&c[x]\u6267\u884c&e\u540e\u53f0&c\u8eab\u4efd\u7684\u8d2d\u4e70\u5546\u54c1\u540e\u89e6\u53d1\u7684\u6307\u4ee4\u65f6\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u7ba1\u7406\u5458\u6dfb\u52a0\u7684\u6307\u4ee4\u4e0d\u59a5\uff0c\u8bf7\u622a\u6b64\u56fe\u8054\u7cfb\u7ba1\u7406\u5458", player);
                        }
                    }
                }
            }
        }.runTask((Plugin)Main.getInstance());
    }

    @EventHandler
    public void page(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        String pn = p.getName();
        Inventory inv = e.getInventory();
        if (inv == null) {
            return;
        }
        if (e.getView().getTitle().equals(MessageSender.gm("&0&l\u79ef\u5206\u5546\u57ce &9&l[right]", p))) {
            int page;
            e.setCancelled(true);
            if (e.getRawSlot() == 49) {
                page = INVShop.pages.get(pn);
                int maxPage = INVShop.getMaxPage();
                if (e.getClick().equals((Object)ClickType.LEFT) && page != maxPage) {
                    INVShop.loadItem(inv, pn, page + 1);
                    INVShop.pages.put(pn, page + 1);
                    INVShop.loadPageItem(inv, pn, page + 1);
                }
                if (e.getClick().equals((Object)ClickType.RIGHT) && page != 1) {
                    INVShop.loadItem(inv, pn, page - 1);
                    INVShop.pages.put(pn, page - 1);
                    INVShop.loadPageItem(inv, pn, page - 1);
                }
            }
            if (e.getRawSlot() > 8 && e.getRawSlot() < 45) {
                if (inv.getItem(e.getRawSlot()) == null) {
                    return;
                }
                page = INVShop.pages.get(pn);
                int row = (e.getRawSlot() + 1) % 9 == 0 ? (e.getRawSlot() + 1 - 9) / 9 : (e.getRawSlot() + 1 - 9) / 9 + 1;
                int column = (e.getRawSlot() + 1) % 9 == 0 ? 9 : e.getRawSlot() - 9 - (row - 1) * 9 + 1;
                int index = CMDShop.getNum(page, row, column);
                ShopCache shopCache = Main.getInstance().getCacheHandler().getShop();
                Good good = shopCache.getList().get(index);
                DanHandler dh = Main.getInstance().getDanHandler();
                if (good.getDan() != null && dh.getDanByName(good.getDan()) != null) {
                    CustomDan danNeeded = dh.getDanByName(good.getDan());
                    CustomDan playerDan = dh.getPlayerDan(p.getName());
                    if (playerDan == null || playerDan.getNum() < danNeeded.getNum()) {
                        MessageSender.sm("&c[x]\u8bf7\u5148\u8fbe\u5230 {dan} &c\u6bb5\u4f4d\u518d\u5151\u6362\u8fd9\u4e2a\u5956\u52b1", p, "dan", new String[]{danNeeded.getDisplayName().replace("&", "\u00a7")});
                        return;
                    }
                }
                PointCache pointCache = Main.getInstance().getCacheHandler().getPoint();
                double price = good.getPrice();
                double points = pointCache.get(pn);
                if (points < price) {
                    MessageSender.sm("&c[x]\u79ef\u5206\u4f59\u989d\u4e0d\u8db3\uff01\u8be5\u5546\u54c1\u9700\u8981&e{price}&c\u79ef\u5206\uff0c\u800c\u4f60\u53ea\u6709&e{points}&c\u79ef\u5206", p, "price points", new String[]{"" + price, "" + points});
                    return;
                }
                ItemStack item = good.getItemStack();
                ShopEvent event = new ShopEvent(p, page, row, column, item);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                ItemGiver ig = new ItemGiver(p, item);
                if (ig.getHasReceived()) {
                    pointCache.set(pn, points - price);
                    MessageSender.sml("&7========================================|&a[v]\u606d\u559c\u8d2d\u4e70\u6210\u529f\uff0c\u73b0\u5728\u4f60\u83b7\u5f97\u4e86\u8fd9\u4e2a\u9053\u5177|&7========================================", p);
                    if (good.getBroadcast() != null) {
                        Bukkit.broadcastMessage((String)good.getBroadcast().replace("&", "\u00a7").replace("_", " ").replace("{player}", p.getName()));
                    }
                    int num = shopCache.getNumByIndex(index);
                    shopCache.updateSalesVolume(num);
                    INVShop.loadInv(pn, inv);
                    EventShopGUI.executeGoodCommands(good, p);
                }
            }
        }
    }
}

