/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.papi;

import com.valorin.Main;
import com.valorin.caches.ArenaInfoCache;
import com.valorin.caches.CacheHandler;
import com.valorin.caches.DanCache;
import com.valorin.caches.EnergyCache;
import com.valorin.caches.PointCache;
import com.valorin.caches.RecordCache;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DanHandler;
import com.valorin.data.encapsulation.Record;
import com.valorin.ranking.RankingData;
import com.valorin.request.RequestsHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class RegPAPI
extends PlaceholderExpansion {
    public String getAuthor() {
        return "Valorin";
    }

    public String getIdentifier() {
        return "dantiao";
    }

    public String getVersion() {
        return Main.getInstance().getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String i) {
        List<String> bar;
        if (player == null) {
            return null;
        }
        CacheHandler cacheHandler = Main.getInstance().getCacheHandler();
        RankingData rankingData = Main.getInstance().getRanking();
        ArenaInfoCache arenaInfoCache = cacheHandler.getArenaInfo();
        EnergyCache energyCache = cacheHandler.getEnergy();
        PointCache pointCache = cacheHandler.getPoint();
        RecordCache recordCache = cacheHandler.getRecord();
        String playerName = player.getName();
        if (i.equalsIgnoreCase("points")) {
            return "" + pointCache.get(playerName);
        }
        if (i.equalsIgnoreCase("win")) {
            return "" + recordCache.getWins(playerName);
        }
        if (i.equalsIgnoreCase("lose")) {
            return "" + recordCache.getLoses(playerName);
        }
        if (i.equalsIgnoreCase("draw")) {
            return "" + recordCache.getDraws(playerName);
        }
        if (i.equalsIgnoreCase("total")) {
            int winTime = recordCache.getWins(playerName);
            int loseTime = recordCache.getLoses(playerName);
            int drawTime = recordCache.getDraws(playerName);
            int totalTime = winTime + loseTime + drawTime;
            return "" + totalTime;
        }
        if (i.equalsIgnoreCase("isWin")) {
            int times = recordCache.getGameTimes(playerName);
            if (times == 0) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            try {
                Record record = recordCache.getRecords(playerName).get(times - 1);
                if (record.getResult() == 0) {
                    return MessageSender.gm("&a[v]\u80dc\u5229", player);
                }
                if (record.getResult() == 1) {
                    return MessageSender.gm("&c[x]\u8d25\u5317", player);
                }
                if (record.getResult() == 2) {
                    return MessageSender.gm("&6[=]\u5e73\u5c40", player);
                }
            }
            catch (Exception e) {
                return "Loading...";
            }
        }
        if (i.equalsIgnoreCase("energy") && energyCache.isEnable()) {
            BigDecimal bg = BigDecimal.valueOf(energyCache.get(playerName));
            double value = bg.setScale(2, 4).doubleValue();
            return "" + value;
        }
        if (i.equalsIgnoreCase("maxenergy") && energyCache.isEnable()) {
            return "" + energyCache.getMaxEnergy();
        }
        if (i.equalsIgnoreCase("kd")) {
            int wins = recordCache.getWins(playerName);
            int loses = recordCache.getLoses(playerName);
            if (loses == 0) {
                return "" + wins;
            }
            BigDecimal bg = BigDecimal.valueOf((double)wins / (double)loses);
            double value = bg.setScale(2, 4).doubleValue();
            return "" + value;
        }
        if (i.equalsIgnoreCase("winrank")) {
            return "" + rankingData.getWinRank(playerName);
        }
        if (i.equalsIgnoreCase("kdrank")) {
            return "" + rankingData.getKDRank(playerName);
        }
        if (i.equalsIgnoreCase("isInvited")) {
            RequestsHandler request = Main.getInstance().getRequestsHandler();
            if (!request.getSenders(player.getName()).isEmpty()) {
                return MessageSender.gm("&a{amount}\u6761", player, "amount", new String[]{request.getSenders(player.getName()).size() + ""});
            }
            return MessageSender.gm("&7\u6682\u65e0", player);
        }
        DanHandler dh = Main.getInstance().getDanHandler();
        if (i.equalsIgnoreCase("duanwei")) {
            String danDisplayName = dh.getPlayerDan(player.getName()) == null ? Main.getInstance().getConfigManager().getInitialDanName() : dh.getPlayerDan(player.getName()).getDisplayName();
            return danDisplayName;
        }
        if (i.equalsIgnoreCase("exptolevelup")) {
            return "" + dh.getNeedExpToLevelUp(player.getName());
        }
        Record lastRecord = recordCache.getLast(playerName);
        if (i.equalsIgnoreCase("lastdamage")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            if (lastRecord.getDamage() == 0.0) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            BigDecimal bg = new BigDecimal(lastRecord.getDamage());
            double value = bg.setScale(1, 4).doubleValue();
            return "" + value;
        }
        if (i.equalsIgnoreCase("lastmaxdamage")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            if (lastRecord.getMaxDamage() == 0.0) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            BigDecimal bg = BigDecimal.valueOf(lastRecord.getMaxDamage());
            double value = bg.setScale(1, 4).doubleValue();
            return "" + value;
        }
        if (i.equalsIgnoreCase("lastopponent")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            if (lastRecord.getOpponentName() == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return lastRecord.getOpponentName();
        }
        if (i.equalsIgnoreCase("lasttime")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return "" + lastRecord.getTime();
        }
        if (i.equalsIgnoreCase("lastdate")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            if (lastRecord.getDate() == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return lastRecord.getDate();
        }
        if (i.equalsIgnoreCase("lastserver")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            if (lastRecord.getServerName() == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return lastRecord.getServerName();
        }
        if (i.equalsIgnoreCase("lastexpchange")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            String expChangeStr = MessageSender.gm("&7\u65e0\u6570\u636e", player);
            if (lastRecord.getExpChange() != 0) {
                int expChange = lastRecord.getExpChange();
                expChangeStr = expChange > 0 ? MessageSender.gm("\u83b7\u5f97", player) + expChange : MessageSender.gm("\u635f\u5931", player) + -expChange;
            }
            return expChangeStr;
        }
        if (i.equalsIgnoreCase("lastarenaname")) {
            String editName;
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            String arenaName = MessageSender.gm("&7\u65e0\u6570\u636e", player);
            if (lastRecord.getArenaEditName() != null && arenaInfoCache.get(editName = lastRecord.getArenaEditName()) != null) {
                arenaName = arenaInfoCache.get(editName).getDisplayName() != null ? arenaInfoCache.get(editName).getDisplayName().replace("&", "\u00a7") : editName;
            }
            return arenaName;
        }
        if (i.equalsIgnoreCase("laststartway")) {
            if (lastRecord == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            String startWayStr = MessageSender.gm("&7\u65e0\u6570\u636e", player);
            int startWay = lastRecord.getStartWay();
            if (startWay == 1) {
                startWayStr = MessageSender.gm("\u5339\u914d\u8d5b", player);
            }
            if (startWay == 2) {
                startWayStr = MessageSender.gm("\u9080\u8bf7\u8d5b", player);
            }
            if (startWay == 3) {
                startWayStr = MessageSender.gm("\u5f3a\u5236\u8d5b", player);
            }
            return startWayStr;
        }
        if (i.equalsIgnoreCase("winning-streak")) {
            return "" + recordCache.getWinningStreakTimes(playerName);
        }
        if (i.equalsIgnoreCase("max-winning-streak")) {
            return "" + recordCache.getMaxWinningStreakTimes(playerName);
        }
        if (i.startsWith("winrank")) {
            int ranking;
            if (!i.replace("winrank", "").startsWith("value")) {
                String numberString = i.replace("winrank", "");
                int ranking2 = -1;
                try {
                    ranking2 = Integer.parseInt(numberString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ranking2 == -1) {
                    return MessageSender.gm("&7\u65e0\u6570\u636e", player);
                }
                String rankingPlayerName = rankingData.getPlayerByWinRank(ranking2);
                if (rankingPlayerName == null) {
                    return MessageSender.gm("&7\u65e0\u6570\u636e", player);
                }
                return rankingPlayerName;
            }
            String numberString = i.replace("winrankvalue", "");
            try {
                ranking = Integer.parseInt(numberString);
            }
            catch (Exception e) {
                ranking = -1;
            }
            if (ranking == -1) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            String rankingPlayerName = rankingData.getPlayerByWinRank(ranking);
            if (rankingPlayerName == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return "" + rankingData.getWinValue(rankingPlayerName);
        }
        if (i.startsWith("kdrank")) {
            int ranking;
            if (!i.replace("kdrank", "").startsWith("value")) {
                String numberString = i.replace("kdrank", "");
                int ranking3 = -1;
                try {
                    ranking3 = Integer.parseInt(numberString);
                }
                catch (Exception rankingPlayerName) {
                    // empty catch block
                }
                if (ranking3 == -1) {
                    return MessageSender.gm("&7\u65e0\u6570\u636e", player);
                }
                String rankingPlayerName = rankingData.getPlayerByKDRank(ranking3);
                if (rankingPlayerName == null) {
                    return MessageSender.gm("&7\u65e0\u6570\u636e", player);
                }
                return rankingPlayerName;
            }
            String numberString = i.replace("kdrankvalue", "");
            try {
                ranking = Integer.parseInt(numberString);
            }
            catch (Exception e) {
                ranking = -1;
            }
            if (ranking == -1) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            String rankingPlayerName = rankingData.getPlayerByKDRank(ranking);
            if (rankingPlayerName == null) {
                return MessageSender.gm("&7\u65e0\u6570\u636e", player);
            }
            return "" + rankingData.getKDValue(rankingPlayerName);
        }
        if (i.equalsIgnoreCase("servertotalgametimes")) {
            int value = recordCache.getServerTotalGameTimes();
            if (value == -1) {
                return "Loading...";
            }
            return "" + value;
        }
        if (i.equalsIgnoreCase("globaltotalgametimes")) {
            int value = Main.getInstance().getGlobalGameTimes().getValue();
            if (value == -1) {
                return "Loading...";
            }
            return "" + value;
        }
        if (i.equalsIgnoreCase("gametimesproportion")) {
            int serverValue = recordCache.getServerTotalGameTimes();
            int globalValue = Main.getInstance().getGlobalGameTimes().getValue();
            if (serverValue != -1 && globalValue != -1) {
                BigDecimal bg = BigDecimal.valueOf((double)serverValue / (double)globalValue * 100.0);
                double value = bg.setScale(4, 4).doubleValue();
                return value + "%";
            }
            return "Loading...";
        }
        DanCache danCache = cacheHandler.getDan();
        if (i.equalsIgnoreCase("expnow")) {
            return "" + danCache.get(playerName);
        }
        DanHandler danHandler = Main.getInstance().getDanHandler();
        if (i.equalsIgnoreCase("expneededtolevelup")) {
            return "" + danHandler.getNeedExpToLevelUp(playerName);
        }
        if (i.startsWith("expprogressbar1")) {
            bar = this.getExpProgressBar(player, "|", 20);
            if (i.contains("former")) {
                return bar.get(0);
            }
            if (i.contains("latter")) {
                return bar.get(1);
            }
        }
        if (i.startsWith("expprogressbar2")) {
            bar = this.getExpProgressBar(player, "\u25a0", 10);
            if (i.contains("former")) {
                return bar.get(0);
            }
            if (i.contains("latter")) {
                return bar.get(1);
            }
        }
        if (i.equalsIgnoreCase("expprogress")) {
            return "" + this.getExpProgress(player);
        }
        return "?";
    }

    private List<String> getExpProgressBar(Player player, String block, int totalNumber) {
        int n;
        int nowExpThisLevel;
        int totalExpToNext;
        DanHandler dh = Main.getInstance().getDanHandler();
        String playerName = player.getName();
        int expNow = Main.getInstance().getCacheHandler().getDan().get(playerName);
        CustomDan playerDan = dh.getPlayerDan(playerName);
        if (playerDan == null) {
            totalExpToNext = dh.getThreshold();
            nowExpThisLevel = expNow;
        } else {
            int index = dh.getCustomDans().indexOf(playerDan);
            if (index == dh.getCustomDans().size() - 1) {
                totalExpToNext = -1;
                nowExpThisLevel = -1;
            } else {
                totalExpToNext = dh.getCustomDans().get(index + 1).getExp() - playerDan.getExp();
                nowExpThisLevel = expNow - playerDan.getExp();
            }
        }
        StringBuilder barFormer = new StringBuilder();
        StringBuilder barLatter = new StringBuilder();
        int blockNumber = totalExpToNext == -1 ? totalNumber : (int)((double)nowExpThisLevel / (double)totalExpToNext * (double)totalNumber);
        for (n = 0; n < blockNumber; ++n) {
            barFormer.append(block);
        }
        for (n = 0; n < totalNumber - blockNumber; ++n) {
            barLatter.append(block);
        }
        ArrayList<String> bar = new ArrayList<String>();
        bar.add(barFormer.toString());
        bar.add(barLatter.toString());
        return bar;
    }

    private double getExpProgress(Player player) {
        DanHandler dh = Main.getInstance().getDanHandler();
        String playerName = player.getName();
        int expNow = Main.getInstance().getCacheHandler().getDan().get(playerName);
        CustomDan playerDan = dh.getPlayerDan(playerName);
        if (playerDan == null) {
            int totalExpToNext = dh.getThreshold();
            int nowExpThisLevel = expNow;
            BigDecimal bg = BigDecimal.valueOf((double)nowExpThisLevel / (double)totalExpToNext * 100.0);
            return bg.setScale(1, 4).doubleValue();
        }
        int index = dh.getCustomDans().indexOf(playerDan);
        if (index == dh.getCustomDans().size() - 1) {
            return 100.0;
        }
        int totalExpToNext = dh.getCustomDans().get(index + 1).getExp() - playerDan.getExp();
        int nowExpThisLevel = expNow - playerDan.getExp();
        BigDecimal bg = new BigDecimal((double)nowExpThisLevel / (double)totalExpToNext * 100.0);
        return bg.setScale(1, 4).doubleValue();
    }
}

