/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.queue;

import com.valorin.Main;
import com.valorin.arenas.StartGame;
import com.valorin.data.encapsulation.ArenaInfo;
import com.valorin.inventory.special.INVStart;
import com.valorin.itemstack.ArenaSelect;
import com.valorin.queue.Matching;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;

public class MatchingHandler {
    private final List<Matching> matchings = new ArrayList<Matching>();
    private final Matching randomMatching;
    private final List<String> busyPlayers = new ArrayList<String>();

    public MatchingHandler() {
        List<ArenaInfo> arenaInfoList = Main.getInstance().getCacheHandler().getArenaInfo().getArenaInfoList();
        this.randomMatching = new Matching(null, null);
        for (ArenaInfo arenaInfo : arenaInfoList) {
            this.addMatching(arenaInfo);
        }
    }

    public Matching getArenaMatching(String arenaEditName) {
        if (arenaEditName == null) {
            return this.randomMatching;
        }
        for (Matching matching : this.matchings) {
            if (!matching.getArenaEditName().equals(arenaEditName)) continue;
            return matching;
        }
        return null;
    }

    public Matching getMatchingOfPlayer(String playerName) {
        if (this.randomMatching.isEnable() && this.randomMatching.getWaiter().equals(playerName)) {
            return this.randomMatching;
        }
        for (Matching matching : this.matchings) {
            if (!matching.isEnable() || !matching.getWaiter().equals(playerName)) continue;
            return matching;
        }
        return null;
    }

    public void addMatching(ArenaInfo arenaInfo) {
        String editName = arenaInfo.getEditName();
        String displayName = arenaInfo.getDisplayName();
        displayName = displayName != null ? displayName.replace("&0", "").replace("&1", "").replace("&2", "").replace("&3", "").replace("&4", "").replace("&5", "").replace("&6", "").replace("&7", "").replace("&8", "").replace("&9", "").replace("&a", "").replace("&b", "").replace("&c", "").replace("&d", "").replace("&e", "").replace("&f", "").replace("&o", "").replace("&m", "").replace("&n", "").replace("&k", "") : editName;
        this.matchings.add(new Matching(arenaInfo.getEditName(), displayName));
    }

    public void removeMatching(ArenaInfo arenaInfo) {
        Matching matchingAboutToBeRemove = null;
        for (Matching matching : this.matchings) {
            if (!matching.getArenaEditName().equals(arenaInfo.getEditName())) continue;
            matchingAboutToBeRemove = matching;
            break;
        }
        if (matchingAboutToBeRemove != null) {
            this.matchings.remove(matchingAboutToBeRemove);
        }
    }

    public void start(String playerName) {
        Matching matching;
        ArenaSelect as = INVStart.arenaSelects.get(playerName);
        String arenaEditName = as.getSelectedArenaEditName();
        if (arenaEditName == null) {
            if (this.randomMatching.isEnable()) {
                String waiter = this.randomMatching.getWaiter();
                if (waiter != null) {
                    this.randomMatching.disable(false);
                    StartGame.start(Bukkit.getPlayerExact((String)playerName), Bukkit.getPlayerExact((String)waiter), null, null, 1);
                }
                return;
            }
            boolean success = false;
            for (Matching matching2 : this.matchings) {
                if (!matching2.isEnable()) continue;
                arenaEditName = matching2.getArenaEditName();
                success = true;
            }
            if (!success) {
                this.randomMatching.enable(playerName);
                as.cancel();
                this.busyPlayers.add(playerName);
                return;
            }
        }
        if ((matching = this.getArenaMatching(arenaEditName)) != null) {
            if (matching.isEnable()) {
                String waiterName = matching.getWaiter();
                if (waiterName != null) {
                    matching.disable(false);
                    StartGame.start(Bukkit.getPlayerExact((String)playerName), Bukkit.getPlayerExact((String)waiterName), arenaEditName, null, 1);
                }
            } else {
                if (this.randomMatching.isEnable()) {
                    String waiter = this.randomMatching.getWaiter();
                    if (waiter != null) {
                        this.randomMatching.disable(false);
                        StartGame.start(Bukkit.getPlayerExact((String)playerName), Bukkit.getPlayerExact((String)waiter), arenaEditName, null, 1);
                    }
                    return;
                }
                matching.enable(playerName);
                as.cancel();
                this.busyPlayers.add(playerName);
            }
        }
    }

    public List<Matching> getMatchingList() {
        return this.matchings;
    }

    public List<String> getBusyPlayers() {
        return this.busyPlayers;
    }

    public void removeBusyPlayer(String playerName) {
        this.busyPlayers.remove(playerName);
    }

    public boolean isPlayerBusy(String playerName) {
        return this.busyPlayers.contains(playerName);
    }
}

