/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.ranking;

import com.valorin.Main;
import com.valorin.caches.RankingCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RankingData {
    public void rank(String s, boolean isWin) {
        RankingCache cache = Main.getInstance().getCacheHandler().getRanking();
        List<String> ranking = isWin ? cache.getWin() : cache.getKD();
        if (!ranking.isEmpty()) {
            ranking.removeIf(rankingContext -> rankingContext.split("\\|")[0].equals(s.split("\\|")[0]));
            double newValue = Double.parseDouble(s.split("\\|")[1]);
            int originalSize = ranking.size();
            ranking.add("");
            int insertIndex = 0;
            for (int i = originalSize - 1; i >= 0; --i) {
                try {
                    double value = Double.parseDouble(ranking.get(i).split("\\|")[1]);
                    if (!(newValue <= value)) continue;
                    insertIndex = i + 1;
                    break;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            for (int i2 = originalSize - 1; i2 >= insertIndex; --i2) {
                ranking.set(i2 + 1, ranking.get(i2));
            }
            ranking.set(insertIndex, s);
            if (isWin) {
                cache.setWin(ranking);
            } else {
                cache.setKD(ranking);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(s);
            if (isWin) {
                cache.setWin(list);
            } else {
                cache.setKD(list);
            }
        }
    }

    public int getWinRank(String playerName) {
        int n = 0;
        List<String> ranking = Main.getInstance().getCacheHandler().getRanking().getWin();
        if (ranking.isEmpty()) {
            return n;
        }
        for (int i = 0; i < ranking.size(); ++i) {
            if (!ranking.get(i).split("\\|")[0].equals(playerName)) continue;
            n = i + 1;
        }
        return n;
    }

    public int getWinValue(String playerName) {
        int n = 0;
        List<String> ranking = Main.getInstance().getCacheHandler().getRanking().getWin();
        if (ranking.isEmpty()) {
            return n;
        }
        for (String s : ranking) {
            if (!s.split("\\|")[0].equals(playerName)) continue;
            try {
                return Integer.parseInt(s.split("\\|")[1]);
            }
            catch (Exception e) {
                return Main.getInstance().getCacheHandler().getRecord().getWins(playerName);
            }
        }
        return -1;
    }

    public String getPlayerByWinRank(int ranking) {
        List<String> rankingList = Main.getInstance().getCacheHandler().getRanking().getWin();
        if (rankingList.size() < ranking) {
            return null;
        }
        return rankingList.get(ranking - 1).split("\\|")[0];
    }

    public int getKDRank(String playerName) {
        List<String> ranking = Main.getInstance().getCacheHandler().getRanking().getKD();
        int n = 0;
        if (ranking.isEmpty()) {
            return n;
        }
        for (int i = 0; i < ranking.size(); ++i) {
            if (!ranking.get(i).split("\\|")[0].equals(playerName)) continue;
            n = i + 1;
        }
        return n;
    }

    public double getKDValue(String playerName) {
        boolean n = false;
        List<String> ranking = Main.getInstance().getCacheHandler().getRanking().getKD();
        if (ranking.isEmpty()) {
            return (double)n;
        }
        for (String s : ranking) {
            if (!s.split("\\|")[0].equals(playerName)) continue;
            try {
                BigDecimal bg = BigDecimal.valueOf(Double.parseDouble(s.split("\\|")[1]));
                return bg.setScale(2, 4).doubleValue();
            }
            catch (Exception e) {
                int wins = Main.getInstance().getCacheHandler().getRecord().getWins(playerName);
                int loses = Main.getInstance().getCacheHandler().getRecord().getLoses(playerName);
                return loses != 0 ? BigDecimal.valueOf(wins / loses).setScale(2, 4).doubleValue() : (double)wins;
            }
        }
        return -1.0;
    }

    public String getPlayerByKDRank(int ranking) {
        List<String> rankingList = Main.getInstance().getCacheHandler().getRanking().getKD();
        if (rankingList.size() < ranking) {
            return null;
        }
        return rankingList.get(ranking - 1).split("\\|")[0];
    }
}

