/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.ranking.skull;

import com.valorin.Main;
import com.valorin.caches.AreaCache;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.data.encapsulation.RankingSkull;
import com.valorin.ranking.RankingData;
import com.valorin.util.ViaVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkullManager {
    public static int refreshTaskId = -1;

    public static void initialize() {
        int interval = Main.getInstance().getConfigManager().getSkullRefreshInterval();
        interval = interval < 10 ? 200 : (interval *= 20);
        new BukkitRunnable(){

            public void run() {
                refreshTaskId = this.getTaskId();
                SkullManager.refresh(true);
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 100L, (long)interval);
    }

    public static void refresh(boolean auto) {
        AreaCache cache = Main.getInstance().getCacheHandler().getArea();
        List<RankingSkull> rankingSkullList = cache.getRankingSkullList();
        int skullNumber = rankingSkullList.size();
        if (skullNumber == 0) {
            return;
        }
        int successes = 0;
        RankingData rankingData = Main.getInstance().getRanking();
        for (RankingSkull rankingSkull : rankingSkullList) {
            Block skullBlock;
            Location location = rankingSkull.getLocation();
            if (location == null || !ViaVersion.isPlayerSkull((skullBlock = location.getBlock()).getType())) continue;
            Skull skull = (Skull)skullBlock.getState();
            String rankingType = rankingSkull.getRankingType();
            int ranking = rankingSkull.getRanking();
            String playerName = rankingType.equalsIgnoreCase("kd") ? rankingData.getPlayerByKDRank(ranking) : rankingData.getPlayerByWinRank(ranking);
            if (playerName == null) continue;
            try {
                skull.setOwningPlayer(Bukkit.getOfflinePlayer((String)playerName));
            }
            catch (NoSuchMethodError e) {
                try {
                    Method setOwnerMethod = skull.getClass().getMethod("setOwner", String.class);
                    setOwnerMethod.invoke((Object)skull, playerName);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            skull.update();
            ++successes;
        }
        if (auto) {
            Bukkit.getConsoleSender().sendMessage(MessageSender.gm("&7\u6392\u884c\u5934\u9885\u5df2\u81ea\u52a8\u5237\u65b0...\u6210\u529f\u5237\u65b0\u6570:{successes}/{total}", null, "total successes", new String[]{"" + skullNumber, "" + successes}));
        }
    }

    public static void reload() {
        if (refreshTaskId != -1) {
            Bukkit.getScheduler().cancelTask(refreshTaskId);
        }
        SkullManager.initialize();
    }
}

