/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.task;

import com.valorin.Main;
import com.valorin.arenas.Arena;
import com.valorin.caches.ArenaInfoCache;
import com.valorin.caches.DanCache;
import com.valorin.caches.PointCache;
import com.valorin.caches.RankingCache;
import com.valorin.caches.RecordCache;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.CustomDan;
import com.valorin.dan.DanHandler;
import com.valorin.dan.ExpChange;
import com.valorin.ranking.RankingData;
import com.valorin.util.SyncBroadcast;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.bukkit.entity.Player;

public class SettleEnd {
    public static void settle(Arena arena, Player winner, Player loser, boolean isDraw) {
        double loserMaxDamage;
        double loserDamage;
        double winnerMaxDamage;
        double winnerDamage;
        int time = arena.getTime();
        int startWay = arena.getStartWay();
        String winnerName = winner.getName();
        String loserName = loser.getName();
        double player1Damage = arena.getDamage(true);
        double player1MaxDamage = arena.getMaxDamage(true);
        double player2Damage = arena.getDamage(false);
        double player2MaxDamage = arena.getMaxDamage(false);
        if (arena.isp1(winnerName)) {
            winnerDamage = player1Damage;
            winnerMaxDamage = player1MaxDamage;
            loserDamage = player2Damage;
            loserMaxDamage = player2MaxDamage;
        } else {
            winnerDamage = player2Damage;
            winnerMaxDamage = player2MaxDamage;
            loserDamage = player1Damage;
            loserMaxDamage = player1MaxDamage;
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = formatter.format(cal.getTime());
        ConfigManager configManager = Main.getInstance().getConfigManager();
        DanCache danCache = Main.getInstance().getCacheHandler().getDan();
        PointCache pointCache = Main.getInstance().getCacheHandler().getPoint();
        RecordCache recordCache = Main.getInstance().getCacheHandler().getRecord();
        String server = Main.getInstance().getConfigManager().getServerName();
        int loserResult = 0;
        int winnerResult = 0;
        double pointsAwarded = 0.0;
        double pointsDeducted = 0.0;
        int winExpAwarded = 0;
        int drawExpAwarded = 0;
        int maxExpAwarded = 0;
        if (startWay == 1) {
            pointsAwarded = configManager.getPointsAwardedByPanel();
            pointsDeducted = configManager.getPointsDeductedByPanel();
            winExpAwarded = configManager.getExpAwardedByPanel();
            drawExpAwarded = configManager.getDrawExpAwardedByPanel();
            maxExpAwarded = configManager.getMaxExpAwardedByPanel();
        }
        if (startWay == 2) {
            pointsAwarded = configManager.getPointsAwardedByInviting();
            pointsDeducted = configManager.getPointsDeductedByInviting();
            winExpAwarded = configManager.getExpAwardedByInviting();
            drawExpAwarded = configManager.getDrawExpAwardedByInviting();
            maxExpAwarded = configManager.getMaxExpAwardedByInviting();
        }
        if (startWay == 3) {
            pointsAwarded = configManager.getPointsAwardedByCompulsion();
            pointsDeducted = configManager.getPointsDeductedByCompulsion();
            winExpAwarded = configManager.getExpAwardedByCompulsion();
            drawExpAwarded = configManager.getDrawExpAwardedByCompulsion();
            maxExpAwarded = configManager.getMaxExpAwardedByCompulsion();
        }
        if (!isDraw) {
            double now;
            loserResult = 1;
            winnerResult = 0;
            if (pointsAwarded != 0.0) {
                now = pointCache.get(winnerName);
                pointCache.set(winnerName, now + pointsAwarded);
                MessageSender.sm("&b\u505a\u7684\u4e0d\u9519\uff01\u5956\u52b1\u4f60 &d{points} &b\u70b9\u5355\u6311\u79ef\u5206", winner, "points", new String[]{"" + pointsAwarded});
            }
            if (pointsDeducted != 0.0) {
                double nowShowed;
                now = pointCache.get(loserName);
                double pointsDeductedShowed = pointsDeducted;
                if (now > 0.0) {
                    if (now - pointsDeducted >= 0.0) {
                        pointCache.set(loserName, now - pointsDeducted);
                        nowShowed = now - pointsDeducted;
                    } else {
                        pointCache.set(loserName, 0.0);
                        nowShowed = 0.0;
                        pointsDeductedShowed = now;
                    }
                } else {
                    nowShowed = 0.0;
                    pointsDeductedShowed = 0.0;
                }
                MessageSender.sm("&7\u4f60\u88ab\u6263\u9664\u4e86 &d{points} &7\u70b9\u5355\u6311\u79ef\u5206\uff0c\u73b0\u5728\u8fd8\u5269 &6{now} &7\u70b9", loser, "points now", new String[]{"" + pointsDeductedShowed, "" + nowShowed});
            }
            recordCache.addWins(winnerName);
            recordCache.addLoses(loserName);
        } else {
            recordCache.addDraws(winnerName);
            recordCache.addDraws(loserName);
        }
        ArenaInfoCache arenaInfoCache = Main.getInstance().getCacheHandler().getArenaInfo();
        String displayName = arenaInfoCache.get(arena.getName()).getDisplayName();
        String editName = arena.getName();
        int winnerExpChange = 0;
        int loserExpChange = 0;
        if (!isDraw) {
            int winnerExpShow;
            int loserExpShow;
            boolean protection;
            RankingCache rankingCache = Main.getInstance().getCacheHandler().getRanking();
            RankingData rankingData = Main.getInstance().getRanking();
            int winnerRank = rankingData.getWinRank(winnerName);
            int loserRank = rankingData.getWinRank(loserName);
            int winnerRank2 = rankingData.getKDRank(winnerName);
            int loserRank2 = rankingData.getKDRank(loserName);
            int winnerOrder = 0;
            if (rankingCache.getWin() != null) {
                for (int i = 0; i < rankingCache.getWin().size(); ++i) {
                    if (!rankingCache.getWin().get(i).split("\\|")[0].equals(winnerName)) continue;
                    winnerOrder = i;
                }
            }
            int loserOrder = 0;
            if (rankingCache.getWin() != null) {
                for (int i = 0; i < rankingCache.getWin().size(); ++i) {
                    if (!rankingCache.getWin().get(i).split("\\|")[0].equals(loserName)) continue;
                    loserOrder = i;
                }
            }
            if (winnerOrder <= loserOrder) {
                rankingData.rank(winnerName + "|" + recordCache.getWins(winnerName), true);
                rankingData.rank(loserName + "|" + recordCache.getWins(loserName), true);
            } else {
                rankingData.rank(loserName + "|" + recordCache.getWins(loserName), true);
                rankingData.rank(winnerName + "|" + recordCache.getWins(winnerName), true);
            }
            int winnerOrder2 = 0;
            if (rankingCache.getKD() != null) {
                for (int i = 0; i < rankingCache.getKD().size(); ++i) {
                    if (!rankingCache.getKD().get(i).split("\\|")[0].equals(winnerName)) continue;
                    winnerOrder2 = i;
                }
            }
            int loserOrder2 = 0;
            if (rankingCache.getKD() != null) {
                for (int i = 0; i < rankingCache.getKD().size(); ++i) {
                    if (!rankingCache.getKD().get(i).split("\\|")[0].equals(loserName)) continue;
                    loserOrder2 = i;
                }
            }
            if (winnerOrder2 <= loserOrder2) {
                if (recordCache.getLoses(winnerName) != 0) {
                    rankingData.rank(winnerName + "|" + (double)recordCache.getWins(winnerName) / (double)recordCache.getLoses(winnerName), false);
                } else {
                    rankingData.rank(winnerName + "|" + (double)recordCache.getWins(winnerName), false);
                }
                if (recordCache.getLoses(loserName) != 0) {
                    rankingData.rank(loserName + "|" + (double)recordCache.getWins(loserName) / (double)recordCache.getLoses(loserName), false);
                } else {
                    rankingData.rank(loserName + "|" + (double)recordCache.getWins(loserName), false);
                }
            } else {
                if (recordCache.getLoses(loserName) != 0) {
                    rankingData.rank(loserName + "|" + (double)recordCache.getWins(loserName) / (double)recordCache.getLoses(loserName), false);
                } else {
                    rankingData.rank(loserName + "|" + (double)recordCache.getWins(loserName), false);
                }
                if (recordCache.getLoses(winnerName) != 0) {
                    rankingData.rank(winnerName + "|" + (double)recordCache.getWins(winnerName) / (double)recordCache.getLoses(winnerName), false);
                } else {
                    rankingData.rank(winnerName + "|" + (double)recordCache.getWins(winnerName), false);
                }
            }
            if (winnerRank != rankingData.getWinRank(winnerName) && rankingData.getWinRank(winnerName) != 0) {
                MessageSender.sm("&b\u80dc\u573a\u6392\u540d\u53d1\u751f\u53d8\u66f4\uff01&e{before}->{now}", winner, "before now", new String[]{"" + winnerRank, "" + rankingData.getWinRank(winnerName)});
            }
            if (loserRank != rankingData.getWinRank(loserName) && rankingData.getWinRank(loserName) != 0) {
                MessageSender.sm("&b\u80dc\u573a\u6392\u540d\u53d1\u751f\u53d8\u66f4\uff01&e{before}->{now}", loser, "before now", new String[]{"" + loserRank, "" + rankingData.getWinRank(loserName)});
            }
            if (winnerRank2 != rankingData.getKDRank(winnerName) && rankingData.getWinRank(winnerName) != 0) {
                MessageSender.sm("&bKD\u6392\u540d\u53d1\u751f\u53d8\u66f4\uff01&e{before}->{now}", winner, "before now", new String[]{"" + winnerRank2, "" + rankingData.getKDRank(winnerName)});
            }
            if (loserRank2 != rankingData.getKDRank(loserName) && rankingData.getWinRank(loserName) != 0) {
                MessageSender.sm("&bKD\u6392\u540d\u53d1\u751f\u53d8\u66f4\uff01&e{before}->{now}", loser, "before now", new String[]{"" + loserRank2, "" + rankingData.getKDRank(loserName)});
            }
            boolean b1 = arena.isp1(winnerName);
            int winnerExp = Math.min(arena.getExp(b1), maxExpAwarded);
            int loserExp = (winnerExp += winExpAwarded) / 3;
            DanHandler dh = Main.getInstance().getDanHandler();
            int protectionExp = configManager.getProtectionExp();
            int winnerExpNow = danCache.get(winnerName);
            int loserExpNow = danCache.get(loserName);
            if (protectionExp == 0) {
                protection = false;
            } else {
                boolean bl = protection = winnerExpNow - loserExpNow >= protectionExp || loserExpNow - winnerExpNow >= protectionExp;
            }
            if (protection) {
                loserExpShow = 0;
                winnerExpShow = 0;
                MessageSender.sm("&c\u53cc\u65b9\u6bb5\u4f4d\u5dee\u8ddd\u8fc7\u5927\uff0c\u6bb5\u4f4d\u7ecf\u9a8c\u4e0d\u4f1a\u53d8\u66f4", winner, loser);
            } else {
                ExpChange.changeExp(winner, winnerExpNow + winnerExp);
                winnerExpChange = winnerExp;
                winnerExpShow = winnerExp;
                loserExpShow = loserExp;
                if (loserExpNow - loserExp > dh.getThreshold()) {
                    ExpChange.changeExp(loser, loserExpNow - loserExp);
                    loserExpChange = -loserExp;
                } else if (loserExpNow > dh.getThreshold()) {
                    loserExpShow = loserExpNow - dh.getThreshold();
                    ExpChange.changeExp(loser, dh.getThreshold());
                    loserExpChange = -(loserExpNow - dh.getThreshold());
                } else {
                    loserExpShow = 0;
                }
            }
            MessageSender.sml("&7============================================================| |                       &b\u6bd4\u8d5b\u7ed3\u675f\uff01|        &7\u606d\u559c\u83b7\u5f97\u4e86\u80dc\u5229\uff0c\u671f\u5f85\u4f60\u4e0b\u4e00\u6b21\u66f4\u52a0\u7cbe\u5f69\u5f97\u8868\u73b0\uff01|                  &7\u540c\u65f6\u83b7\u5f97\u4e86 &a{exp} &7\u7ecf\u9a8c| |&7============================================================", winner, "exp", new String[]{"" + winnerExpShow});
            MessageSender.sml("&7============================================================| |                     &b\u6bd4\u8d5b\u7ed3\u675f\uff01|           &7\u4f60\u6ca1\u6709\u83b7\u80dc\uff0c\u4e0d\u8981\u7070\u5fc3\uff0c\u518d\u63a5\u518d\u5389\uff01|                &7\u540c\u65f6\u635f\u5931\u4e86 &c{exp} &7\u7ecf\u9a8c| |&7============================================================", loser, "exp", new String[]{"" + loserExpShow});
            displayName = displayName == null ? arena.getName() : displayName.replace("&", "\u00a7");
            SyncBroadcast.bc(MessageSender.gm("&b[\u6218\u62a5]: &7\u73a9\u5bb6 &e{winner} &7\u5728\u5355\u6311\u8d5b\u573a&r{arenaname}&r&7\u4e0a\u4ee5 &6{time}\u79d2 &7\u51fb\u8d25\u73a9\u5bb6 &e{loser}", null, "winner arenaname time loser", new String[]{winnerName, displayName, arena.getTime() + "", loserName}), startWay);
            dh.refreshPlayerDan(winnerName);
            dh.refreshPlayerDan(loserName);
            if (arena.getDan(arena.isp1(winnerName)) != null) {
                CustomDan danNow;
                CustomDan danBefore = arena.getDan(arena.isp1(winnerName));
                if (!danBefore.equals(danNow = dh.getDanByExp(winnerExpNow + winnerExpShow))) {
                    SyncBroadcast.bc(MessageSender.gm("&a[\u606d\u559c]: &7\u73a9\u5bb6 &e{player} &7\u7684\u5355\u6311\u6bb5\u4f4d\u6210\u529f\u5347\u5230\u4e86&r{dan}", null, "player dan", new String[]{winnerName, danNow.getDisplayName()}), startWay);
                }
            } else {
                CustomDan danNow = dh.getDanByExp(winnerExpNow + winnerExpShow);
                if (danNow != null) {
                    SyncBroadcast.bc(MessageSender.gm("&a[\u606d\u559c]: &7\u73a9\u5bb6 &e{player} &7\u7a81\u7834\u4e86\u65e0\u6bb5\u4f4d\u7684\u8eab\u4efd\uff0c\u9996\u6b21\u83b7\u5f97\u4e86\u6bb5\u4f4d\uff1a&r{dan}&7\uff01\u795dTA\u5728\u5355\u6311\u6218\u6597\u7684\u8def\u4e0a\u8d8a\u8d70\u8d8a\u8fdc\uff01", null, "player dan", new String[]{winnerName, danNow.getDisplayName()}), startWay);
                }
            }
            int winTime = recordCache.getWinningStreakTimes(winnerName);
            int maxWinTime = recordCache.getMaxWinningStreakTimes(winnerName);
            recordCache.addWinningStreakTimes(winnerName);
            if (winTime + 1 > maxWinTime) {
                recordCache.addMaxWinningStreakTimes(winnerName);
            }
            recordCache.clearWinningStreakTimes(loserName);
            int reportTimes = configManager.getBroadcastWinningStreakTimes();
            if (reportTimes == 0) {
                reportTimes = 3;
            }
            if (winTime + 1 >= reportTimes) {
                SyncBroadcast.bc(MessageSender.gm("&a[\u606d\u559c]: &7\u73a9\u5bb6 &e{player} &7\u5728\u7ade\u6280\u573a\u4e0a\u5b8c\u6210\u4e86 &b{times} &7\u8fde\u80dc\uff01", null, "player times", new String[]{winnerName, winTime + 1 + ""}), startWay);
            }
        } else {
            ExpChange.changeExp(winner, danCache.get(winnerName) + drawExpAwarded);
            ExpChange.changeExp(loser, danCache.get(loserName) + drawExpAwarded);
            loserExpChange = winnerExpChange = drawExpAwarded;
            MessageSender.sml("&7============================================================| |                    &b\u6bd4\u8d5b\u7ed3\u675f\uff01|          &7\u6bd4\u8d5b\u8d85\u65f6\uff01\u672a\u51b3\u51fa\u80dc\u8d1f\uff0c\u5224\u5b9a\u4e3a\u5e73\u5c40\uff01|          &7\u540c\u65f6\u83b7\u5f97\u4e86 &a{exp} &7\u7ecf\u9a8c| |&7============================================================", winner, "exp", new String[]{"" + drawExpAwarded});
            MessageSender.sml("&7============================================================| |                    &b\u6bd4\u8d5b\u7ed3\u675f\uff01|          &7\u6bd4\u8d5b\u8d85\u65f6\uff01\u672a\u51b3\u51fa\u80dc\u8d1f\uff0c\u5224\u5b9a\u4e3a\u5e73\u5c40\uff01|          &7\u540c\u65f6\u83b7\u5f97\u4e86 &a{exp} &7\u7ecf\u9a8c| |&7============================================================", loser, "exp", new String[]{"" + drawExpAwarded});
            displayName = displayName == null ? editName : displayName.replace("&", "\u00a7");
            SyncBroadcast.bc(MessageSender.gm("&b[\u6218\u62a5]: &7\u73a9\u5bb6 &e{p1} &7\u4e0e &e{p2} &7\u5728\u5355\u6311\u8d5b\u573a&r{arenaname}&r&7\u4e0a\u6253\u6210\u5e73\u624b\uff0c\u5b9e\u4e3a\u7cbe\u5999\uff01", null, "p1 arenaname p2", new String[]{winnerName, displayName, loserName}), startWay);
        }
        try {
            Main.getInstance().getHologramManager().setIsNeedRefresh(true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        recordCache.add(loserName, date, winnerName, server, time, loserDamage, loserMaxDamage, loserResult, startWay, loserExpChange, editName);
        recordCache.add(winnerName, date, loserName, server, time, winnerDamage, winnerMaxDamage, winnerResult, startWay, winnerExpChange, editName);
        recordCache.refreshServerTotalGameTimes();
    }
}

