/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class Transform {
    public static InputStream yamlToStream(YamlConfiguration yml) throws IOException, SQLException {
        return new ByteArrayInputStream(yml.saveToString().getBytes(StandardCharsets.UTF_8));
    }

    public static Object streamToYaml(InputStream stream) throws IOException, ClassNotFoundException, SQLException {
        byte[] bytes = new byte[stream.available()];
        stream.read(bytes);
        String str = new String(bytes, StandardCharsets.UTF_8);
        YamlConfiguration yml = new YamlConfiguration();
        try {
            yml.load((Reader)new StringReader(str));
            stream.close();
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return yml;
    }

    public static Blob serialize(Object obj) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        String string = byteArrayOutputStream.toString("ISO-8859-1");
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return new SerialBlob(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Object serializeToObject(Blob blob) throws IOException, ClassNotFoundException, SQLException {
        String string = new String(blob.getBytes(1L, (int)blob.length()), StandardCharsets.UTF_8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.ISO_8859_1));
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }
}

