/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.api.enums.config;

import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;

public enum EMaxHorizontalResolution {
    BLOCK(16, 0),
    TWO_BLOCKS(8, 1),
    FOUR_BLOCKS(4, 2),
    HALF_CHUNK(2, 3),
    CHUNK(1, 4);

    public final int dataPointLengthCount;
    public final int dataPointWidth;
    public final byte detailLevel;
    public final int[] startX;
    public final int[] startZ;
    public final int[] endX;
    public final int[] endZ;
    private static EMaxHorizontalResolution[][] lowerDetailArrays;

    private EMaxHorizontalResolution(int newLengthCount, int newDetailLevel) {
        this.detailLevel = (byte)newDetailLevel;
        this.dataPointLengthCount = newLengthCount;
        this.dataPointWidth = 16 / this.dataPointLengthCount;
        this.startX = new int[this.dataPointLengthCount * this.dataPointLengthCount];
        this.endX = new int[this.dataPointLengthCount * this.dataPointLengthCount];
        this.startZ = new int[this.dataPointLengthCount * this.dataPointLengthCount];
        this.endZ = new int[this.dataPointLengthCount * this.dataPointLengthCount];
        int index = 0;
        for (int x = 0; x < newLengthCount; ++x) {
            for (int z = 0; z < newLengthCount; ++z) {
                this.startX[index] = x * this.dataPointWidth;
                this.startZ[index] = z * this.dataPointWidth;
                this.endX[index] = x * this.dataPointWidth + this.dataPointWidth;
                this.endZ[index] = z * this.dataPointWidth + this.dataPointWidth;
                ++index;
            }
        }
    }

    public static EMaxHorizontalResolution[] getSelfAndLowerDetails(EMaxHorizontalResolution detail) {
        if (lowerDetailArrays == null) {
            lowerDetailArrays = new EMaxHorizontalResolution[EMaxHorizontalResolution.values().length][];
            for (EMaxHorizontalResolution currentDetail : EMaxHorizontalResolution.values()) {
                ArrayList<EMaxHorizontalResolution> lowerDetails = new ArrayList<EMaxHorizontalResolution>();
                for (EMaxHorizontalResolution compareDetail : EMaxHorizontalResolution.values()) {
                    if (currentDetail.detailLevel > compareDetail.detailLevel) continue;
                    lowerDetails.add(compareDetail);
                }
                Collections.sort(lowerDetails);
                Collections.reverse(lowerDetails);
                EMaxHorizontalResolution.lowerDetailArrays[currentDetail.detailLevel] = lowerDetails.toArray(new EMaxHorizontalResolution[lowerDetails.size()]);
            }
        }
        return lowerDetailArrays[detail.detailLevel];
    }

    public static EMaxHorizontalResolution getDetailForDistance(EMaxHorizontalResolution maxDetailLevel, int distance, int maxDistance) {
        EMaxHorizontalResolution[] lowerDetails = EMaxHorizontalResolution.getSelfAndLowerDetails(maxDetailLevel);
        int distanceBetweenDetails = maxDistance / lowerDetails.length;
        int index = MathUtil.clamp(0, distance / distanceBetweenDetails, lowerDetails.length - 1);
        return lowerDetails[index];
    }
}

