/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.renderfile;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderLoader;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.file.DataSourceReferenceTracker;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.metaData.AbstractMetaDataContainerFile;
import com.seibel.distanthorizons.core.file.metaData.BaseMetaData;
import com.seibel.distanthorizons.core.file.renderfile.IRenderSourceProvider;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.MetaDataDto;
import com.seibel.distanthorizons.core.util.AtomicsUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.Reference;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RenderDataMetaFile
extends AbstractMetaDataContainerFile
implements IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final boolean ALWAYS_INVALIDATE_CACHE = false;
    public static final String RENDER_SOURCE_TYPE = "ColumnRenderSource";
    private DataSourceReferenceTracker.RenderDataSourceSoftRef cachedRenderDataSourceRef = new DataSourceReferenceTracker.RenderDataSourceSoftRef(this, null);
    private final AtomicReference<CompletableFuture<ColumnRenderSource>> renderSourceLoadFutureRef = new AtomicReference<Object>(null);
    private final IDhClientLevel clientLevel;
    private final IFullDataSourceProvider fullDataSourceProvider;
    private final IRenderSourceProvider renderDataSourceProvider;
    private boolean doesDtoExist;

    public static RenderDataMetaFile createNewFileForPos(IFullDataSourceProvider fullDataSourceProvider, IRenderSourceProvider renderDataSourceProvider, IDhClientLevel clientLevel, DhSectionPos pos) throws IOException {
        return new RenderDataMetaFile(fullDataSourceProvider, renderDataSourceProvider, clientLevel, pos);
    }

    private RenderDataMetaFile(IFullDataSourceProvider fullDataSourceProvider, IRenderSourceProvider renderDataSourceProvider, IDhClientLevel clientLevel, DhSectionPos pos) throws IOException {
        super(pos);
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.renderDataSourceProvider = renderDataSourceProvider;
        this.clientLevel = clientLevel;
        LodUtil.assertTrue(this.baseMetaData == null);
        this.doesDtoExist = false;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderDataFileStatus);
    }

    public static RenderDataMetaFile createFromExistingFile(IFullDataSourceProvider fullDataSourceProvider, IRenderSourceProvider renderDataSourceProvider, IDhClientLevel clientLevel, MetaDataDto metaDataDto) throws IOException {
        return new RenderDataMetaFile(fullDataSourceProvider, renderDataSourceProvider, clientLevel, metaDataDto);
    }

    private RenderDataMetaFile(IFullDataSourceProvider fullDataSourceProvider, IRenderSourceProvider renderDataSourceProvider, IDhClientLevel clientLevel, MetaDataDto metaDataDto) throws IOException {
        super(metaDataDto.baseMetaData);
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.renderDataSourceProvider = renderDataSourceProvider;
        this.clientLevel = clientLevel;
        LodUtil.assertTrue(this.baseMetaData != null);
        this.doesDtoExist = true;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderDataFileStatus);
        this.fullDataSourceProvider.onRenderDataFileLoaded(this.baseMetaData.pos);
    }

    public void updateChunkIfSourceExistsAsync(ChunkSizedFullDataAccessor chunkDataView) {
        DhSectionPos chunkSectionPos = chunkDataView.getSectionPos();
        LodUtil.assertTrue(this.pos.overlapsExactly(chunkSectionPos), "Chunk pos " + chunkSectionPos + " doesn't overlap with section " + this.pos);
        CompletableFuture<ColumnRenderSource> renderSourceLoadFuture = this.getCachedDataSourceAsync(true);
        if (renderSourceLoadFuture == null) {
            return;
        }
        renderSourceLoadFuture.thenAccept(renderSource -> {
            boolean dataUpdated = renderSource.updateWithChunkData(chunkDataView, this.clientLevel);
            boolean showRenderDataFileStatus = Config.Client.Advanced.Debugging.DebugWireframe.showRenderDataFileStatus.get();
            if (showRenderDataFileStatus) {
                float offset = new Random(System.nanoTime() ^ Thread.currentThread().getId()).nextFloat() * 16.0f;
                Color debugColor = dataUpdated ? Color.blue : Color.red;
                DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(chunkDataView.getSectionPos(), 32.0f, 64.0f + offset, 0.07f, debugColor), 2.0, 16.0f));
            }
        });
    }

    public CompletableFuture<ColumnRenderSource> getOrLoadCachedDataSourceAsync(Executor fileReaderThreads) {
        CompletableFuture<ColumnRenderSource> renderSourceLoadFuture = this.getCachedDataSourceAsync(true);
        if (renderSourceLoadFuture != null) {
            return renderSourceLoadFuture;
        }
        renderSourceLoadFuture = new CompletableFuture();
        if (!this.renderSourceLoadFutureRef.compareAndSet(null, renderSourceLoadFuture)) {
            renderSourceLoadFuture = this.renderSourceLoadFutureRef.get();
        }
        CompletableFuture<ColumnRenderSource> getSourceFuture = renderSourceLoadFuture;
        if (!this.doesDtoExist) {
            byte dataDetailLevel = (byte)(this.pos.getDetailLevel() - 6);
            int verticalSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(dataDetailLevel);
            ColumnRenderSource newColumnRenderSource = new ColumnRenderSource(this.pos, verticalSize, this.clientLevel.getMinY());
            this.baseMetaData = new BaseMetaData(newColumnRenderSource.getSectionPos(), -1, newColumnRenderSource.getDataDetailLevel(), newColumnRenderSource.worldGenStep, RENDER_SOURCE_TYPE, newColumnRenderSource.getRenderDataFormatVersion(), Long.MAX_VALUE);
            this.updateRenderCacheAsync(newColumnRenderSource).whenComplete((voidObj, ex) -> {
                this.cachedRenderDataSourceRef = new DataSourceReferenceTracker.RenderDataSourceSoftRef(this, newColumnRenderSource);
                this.renderSourceLoadFutureRef.set(null);
                getSourceFuture.complete(newColumnRenderSource);
            });
        } else {
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                ColumnRenderSource renderSource;
                if (this.baseMetaData == null) {
                    throw new IllegalStateException("Meta data not loaded!");
                }
                try (InputStream inputStream = this.getInputStream();
                     DhDataInputStream compressedInputStream = new DhDataInputStream(inputStream);){
                    renderSource = ColumnRenderLoader.INSTANCE.loadRenderSource(this, compressedInputStream, this.clientLevel);
                }
                catch (IOException ex) {
                    throw new CompletionException(ex);
                }
                return renderSource;
            }, fileReaderThreads).thenCompose(renderSource -> this.updateRenderCacheAsync((ColumnRenderSource)renderSource))).whenComplete((renderSource, ex) -> {
                if (ex != null) {
                    if (!LodUtil.isInterruptOrReject(ex)) {
                        LOGGER.error("Error loading pos: " + this.pos + ": ", ex);
                    }
                    renderSource = null;
                }
                this.renderSourceLoadFutureRef.set(null);
                this.cachedRenderDataSourceRef = new DataSourceReferenceTracker.RenderDataSourceSoftRef(this, (ColumnRenderSource)renderSource);
                getSourceFuture.complete((ColumnRenderSource)renderSource);
            });
        }
        return getSourceFuture;
    }

    private InputStream getInputStream() throws IOException {
        MetaDataDto dto = (MetaDataDto)this.renderDataSourceProvider.getRepo().getByPrimaryKey(this.pos.serialize());
        return new ByteArrayInputStream(dto.dataArray);
    }

    public CompletableFuture<ColumnRenderSource> updateRenderCacheAsync(ColumnRenderSource renderSource) {
        DebugRenderer.BoxWithLife debugBox = new DebugRenderer.BoxWithLife(new DebugRenderer.Box(renderSource.sectionPos, 74.0f, 86.0f, 0.1f, Color.red), 1.0, 32.0f, Color.green.darker());
        FullDataMetaFile dataFile = this.fullDataSourceProvider.getFileIfExist(this.pos);
        if (dataFile != null && dataFile.baseMetaData != null && (long)dataFile.baseMetaData.checksum == this.baseMetaData.dataVersion.get()) {
            LOGGER.debug("Skipping render cache update for " + this.pos);
            renderSource.localVersion.incrementAndGet();
            return CompletableFuture.completedFuture(renderSource);
        }
        Reference<Integer> renderDataVersionRef = new Reference<Integer>(Integer.MAX_VALUE);
        CompletionStage fullDataSourceFuture = ((CompletableFuture)this.fullDataSourceProvider.readAsync(renderSource.getSectionPos()).thenApply(fullDataSource -> {
            debugBox.box.color = Color.yellow.darker();
            FullDataMetaFile renderSourceMetaFile = this.fullDataSourceProvider.getFileIfExist(this.pos);
            if (renderSourceMetaFile != null && renderSourceMetaFile.baseMetaData != null) {
                renderDataVersionRef.value = renderSourceMetaFile.baseMetaData.checksum;
            }
            return fullDataSource;
        })).exceptionally(ex -> {
            LOGGER.error("Exception when getting data for updateCache()", ex);
            return null;
        });
        CompletionStage transformFuture = ((CompletableFuture)fullDataSourceFuture).handle((fullDataSource, ex) -> {
            if (ex == null) {
                ColumnRenderSource newRenderSource = null;
                try {
                    newRenderSource = FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, this.clientLevel);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to transform full data to render data for pos: " + this.pos, (Throwable)e);
                }
                try {
                    if (newRenderSource != null) {
                        renderSource.updateFromRenderSource(newRenderSource);
                        this.baseMetaData.dataVersion.set(((Integer)renderDataVersionRef.value).intValue());
                        this.baseMetaData.dataDetailLevel = renderSource.getDataDetailLevel();
                        this.baseMetaData.dataType = RENDER_SOURCE_TYPE;
                        this.baseMetaData.binaryDataFormatVersion = renderSource.getRenderDataFormatVersion();
                        this.save(renderSource);
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Exception when writing render data for pos: " + this.pos, e);
                }
            } else if (!LodUtil.isInterruptOrReject(ex)) {
                LOGGER.error("Exception when updating render file using data source: ", ex);
            }
            debugBox.close();
            return renderSource;
        });
        return transformFuture;
    }

    public CompletableFuture<Void> flushAndSaveAsync() {
        if (!this.renderDataSourceProvider.getRepo().existsWithPrimaryKey(this.pos.serialize())) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ColumnRenderSource> getSourceFuture = this.getCachedDataSourceAsync(false);
        if (getSourceFuture == null) {
            return CompletableFuture.completedFuture(null);
        }
        return getSourceFuture.thenAccept(columnRenderSource -> {});
    }

    private void save(ColumnRenderSource renderSource) {
        if (renderSource.isEmpty()) {
            this.fullDataSourceProvider.getRepo().deleteByPrimaryKey(this.pos.serialize());
            this.doesDtoExist = false;
        } else {
            try {
                super.writeToDatabase(dhDataOutputStream -> renderSource.writeData((DhDataOutputStream)dhDataOutputStream), this.renderDataSourceProvider.getRepo());
                this.doesDtoExist = true;
            }
            catch (IOException e) {
                LOGGER.error("Failed to save updated render data for pos " + this.pos, (Throwable)e);
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        if (this.cachedRenderDataSourceRef.get() != null) {
            return;
        }
        Color color = Color.black;
        if (this.renderSourceLoadFutureRef.get() != null) {
            color = Color.BLUE;
        } else if (this.doesDtoExist) {
            color = Color.RED;
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 64.0f, 72.0f, 0.05f, color));
    }

    @Nullable
    private CompletableFuture<ColumnRenderSource> getCachedDataSourceAsync(boolean updateRenderSourceCache) {
        CompletableFuture<ColumnRenderSource> renderSourceLoadFuture = this.renderSourceLoadFutureRef.get();
        if (renderSourceLoadFuture != null) {
            return renderSourceLoadFuture;
        }
        ColumnRenderSource cachedRenderDataSource = (ColumnRenderSource)this.cachedRenderDataSourceRef.get();
        if (cachedRenderDataSource == null) {
            return null;
        }
        if (!updateRenderSourceCache) {
            return CompletableFuture.completedFuture(cachedRenderDataSource);
        }
        CompletableFuture<ColumnRenderSource> newFuture = new CompletableFuture<ColumnRenderSource>();
        CompletableFuture<ColumnRenderSource> oldFuture = AtomicsUtil.compareAndExchange(this.renderSourceLoadFutureRef, null, newFuture);
        if (oldFuture != null) {
            return oldFuture;
        }
        this.updateRenderCacheAsync(cachedRenderDataSource).handle((ignoredRenderSource, ex) -> {
            newFuture.complete(cachedRenderDataSource);
            this.renderSourceLoadFutureRef.set(null);
            return null;
        });
        return newFuture;
    }
}

