/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

import com.seibel.distanthorizons.core.jar.JarUtils;
import distanthorizons.libraries.electronwill.nightconfig.core.Config;
import distanthorizons.libraries.electronwill.nightconfig.core.io.ParsingMode;
import distanthorizons.libraries.electronwill.nightconfig.json.JsonFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModJarInfo {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FILE_NAME = "build_info.json";
    public static final String Git_Branch;
    public static final String Git_Commit;
    public static final String Build_Source;

    static {
        String gitBranch = "UNKNOWN";
        String gitCommit = "UNKNOWN";
        String buildSource = "UNKNOWN";
        try {
            String jsonString = JarUtils.convertInputStreamToString(JarUtils.accessFile(FILE_NAME));
            Config jsonObject = Config.inMemory();
            JsonFormat.minimalInstance().createParser().parse(jsonString, jsonObject, ParsingMode.REPLACE);
            gitBranch = (String)jsonObject.get("info_git_branch");
            gitCommit = (String)jsonObject.get("info_git_commit");
            buildSource = (String)jsonObject.get("info_build_source");
        }
        catch (Error | Exception e) {
            LOGGER.warn("Unable to get the Git information from build_info.json");
        }
        Git_Commit = gitBranch;
        Git_Branch = gitCommit;
        Build_Source = buildSource;
    }
}

