/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers;

import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.HashSet;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_638;

public class WrapperFactory
implements IWrapperFactory {
    public static final WrapperFactory INSTANCE = new WrapperFactory();

    @Override
    public AbstractBatchGenerationEnvironmentWrapper createBatchGenerator(IDhLevel targetLevel) {
        if (targetLevel instanceof IDhServerLevel) {
            return new BatchGenerationEnvironment((IDhServerLevel)targetLevel);
        }
        throw new IllegalArgumentException("The target level must be a server-side level.");
    }

    @Override
    public IBiomeWrapper deserializeBiomeWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BiomeWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper deserializeBlockStateWrapper(String str, ILevelWrapper levelWrapper) throws IOException {
        return BlockStateWrapper.deserialize(str, levelWrapper);
    }

    @Override
    public IBlockStateWrapper getAirBlockStateWrapper() {
        return BlockStateWrapper.AIR;
    }

    @Override
    public HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        return BlockStateWrapper.getRendererIgnoredBlocks(levelWrapper);
    }

    @Override
    public IChunkWrapper createChunkWrapper(Object[] objectArray) throws ClassCastException {
        if (objectArray.length == 1 && objectArray[0] instanceof IChunkWrapper) {
            try {
                return (IChunkWrapper)objectArray[0];
            }
            catch (Exception e) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
        }
        if (objectArray.length == 2) {
            ILevelWrapper levelWrapper;
            class_1937 level;
            if (!(objectArray[0] instanceof class_2791)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            class_2791 chunk = (class_2791)objectArray[0];
            if (!(objectArray[1] instanceof class_1937)) {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            class_1937 lightSource = level = (class_1937)objectArray[1];
            if (level instanceof class_3218) {
                levelWrapper = ServerLevelWrapper.getWrapper((class_3218)level);
            } else if (level instanceof class_638) {
                levelWrapper = ClientLevelWrapper.getWrapper((class_638)level);
            } else {
                throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
            }
            return new ChunkWrapper(chunk, (class_4538)lightSource, levelWrapper);
        }
        throw new ClassCastException(WrapperFactory.createChunkWrapperErrorMessage(objectArray));
    }

    private static String createChunkWrapperErrorMessage(Object[] objectArray) {
        StringBuilder message = new StringBuilder("Chunk wrapper creation failed. \nExpected parameters: \n");
        message.append("[" + class_2791.class.getName() + "], \n");
        message.append("[" + class_3218.class.getName() + "] or [" + class_638.class.getName() + "]. \n");
        if (objectArray.length != 0) {
            message.append("Given parameters: ");
            for (Object obj : objectArray) {
                message.append("[").append(obj.getClass().getName()).append("], ");
            }
        } else {
            message.append(" No parameters given.");
        }
        return message.toString();
    }
}

