/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkLightStorage;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5742;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public class ChunkWrapper
implements IChunkWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final boolean RUN_RELATIVE_POS_INDEX_VALIDATION = ModInfo.IS_DEV_BUILD;
    private static final ThreadLocal<class_2338.class_2339> MUTABLE_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new class_2338.class_2339());
    private final class_2791 chunk;
    private final DhChunkPos chunkPos;
    private final class_4538 lightSource;
    private final ILevelWrapper wrappedLevel;
    private boolean isDhLightCorrect = false;
    private boolean isMcClientLightingCorrect = false;
    private ChunkLightStorage blockLightStorage;
    private ChunkLightStorage skyLightStorage;
    private ArrayList<DhBlockPos> blockLightPosList = null;
    private boolean useDhLighting;
    private static final ConcurrentLinkedQueue<ChunkWrapper> chunksNeedingClientLightUpdating = new ConcurrentLinkedQueue();

    public ChunkWrapper(class_2791 chunk, class_4538 lightSource, ILevelWrapper wrappedLevel) {
        boolean isDhGeneratedChunk;
        this.chunk = chunk;
        this.lightSource = lightSource;
        this.wrappedLevel = wrappedLevel;
        this.chunkPos = new DhChunkPos(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        this.useDhLighting = isDhGeneratedChunk = this.lightSource.getClass() == DhLitWorldGenRegion.class;
        chunksNeedingClientLightUpdating.add(this);
    }

    @Override
    public int getHeight() {
        return this.chunk.method_31605();
    }

    @Override
    public int getMinBuildHeight() {
        return this.chunk.method_31607();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.chunk.method_31600();
    }

    @Override
    public int getMinFilledHeight() {
        class_2826[] sections = this.chunk.method_12006();
        for (int index = 0; index < sections.length; ++index) {
            if (sections[index] == null || sections[index].method_38292()) continue;
            return this.chunk.method_31604(index) * 16;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSolidHeightMapValue(int xRel, int zRel) {
        return this.chunk.method_12032(class_2902.class_2903.field_13202).method_12603(xRel, zRel);
    }

    @Override
    public int getLightBlockingHeightMapValue(int xRel, int zRel) {
        return this.chunk.method_12032(class_2902.class_2903.field_13197).method_12603(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int relX, int relY, int relZ) {
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)this.chunk.method_16359(class_5742.method_33100((int)relX), class_5742.method_33100((int)relY), class_5742.method_33100((int)relZ)), this.wrappedLevel);
    }

    @Override
    public DhChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public class_2791 getChunk() {
        return this.chunk;
    }

    @Override
    public int getMaxBlockX() {
        return this.chunk.method_12004().method_8327();
    }

    @Override
    public int getMaxBlockZ() {
        return this.chunk.method_12004().method_8329();
    }

    @Override
    public int getMinBlockX() {
        return this.chunk.method_12004().method_8326();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunk.method_12004().method_8328();
    }

    @Override
    public long getLongChunkPos() {
        return this.chunk.method_12004().method_8324();
    }

    @Override
    public void setIsDhLightCorrect(boolean isDhLightCorrect) {
        this.isDhLightCorrect = isDhLightCorrect;
    }

    @Override
    public void setUseDhLighting(boolean useDhLighting) {
        this.useDhLighting = useDhLighting;
    }

    @Override
    public boolean isLightCorrect() {
        if (this.useDhLighting) {
            return this.isDhLightCorrect;
        }
        if (this.chunk instanceof class_2818) {
            class_2818 levelChunk = (class_2818)this.chunk;
            if (levelChunk.method_12200() instanceof class_638) {
                return this.isMcClientLightingCorrect;
            }
            return this.chunk.method_12038() && levelChunk.field_12855;
        }
        return this.chunk.method_12038();
    }

    @Override
    public int getDhBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getBlockLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhBlockLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getBlockLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getBlockLightStorage() {
        if (this.blockLightStorage == null) {
            this.blockLightStorage = new ChunkLightStorage(this.getMinBuildHeight(), this.getMaxBuildHeight());
        }
        return this.blockLightStorage;
    }

    @Override
    public int getDhSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getSkyLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhSkyLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getSkyLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getSkyLightStorage() {
        if (this.skyLightStorage == null) {
            this.skyLightStorage = new ChunkLightStorage(this.getMinBuildHeight(), this.getMaxBuildHeight());
        }
        return this.skyLightStorage;
    }

    @Override
    public int getBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getBlockLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.method_8314(class_1944.field_9282, new class_2338(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public int getSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getSkyLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.method_8314(class_1944.field_9284, new class_2338(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public ArrayList<DhBlockPos> getBlockLightPosList() {
        if (this.blockLightPosList == null) {
            this.blockLightPosList = new ArrayList();
            this.chunk.method_51524((blockPos, blockState) -> this.blockLightPosList.add(new DhBlockPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())));
        }
        return this.blockLightPosList;
    }

    @Override
    public boolean doNearbyChunksExist() {
        if (this.lightSource instanceof DhLitWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.method_8402(dx + this.chunk.method_12004().field_9181, dz + this.chunk.method_12004().field_9180, class_2806.field_12794, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public class_4538 getColorResolver() {
        return this.lightSource;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + this.chunk.method_12004();
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        class_2338.class_2339 blockPos = MUTABLE_BLOCK_POS_REF.get();
        blockPos.method_33097(relX);
        blockPos.method_33098(relY);
        blockPos.method_33099(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.method_8320((class_2338)blockPos), this.wrappedLevel);
    }

    @Override
    public boolean isStillValid() {
        return this.wrappedLevel.tryGetChunk(this.chunkPos) == this;
    }

    public static void syncedUpdateClientLightStatus() {
        ChunkWrapper chunkWrapper = chunksNeedingClientLightUpdating.poll();
        while (chunkWrapper != null) {
            chunkWrapper.updateIsClientLightingCorrect();
            chunkWrapper = chunksNeedingClientLightUpdating.poll();
        }
    }

    private void updateIsClientLightingCorrect() {
        if (this.chunk instanceof class_2818 && ((class_2818)this.chunk).method_12200() instanceof class_638) {
            class_2818 levelChunk = (class_2818)this.chunk;
            class_631 clientChunkCache = ((class_638)levelChunk.method_12200()).method_2935();
            this.isMcClientLightingCorrect = clientChunkCache.method_12246(this.chunk.method_12004().field_9181, this.chunk.method_12004().field_9180) != null && ChunkWrapper.checkLightSectionsOnChunk(levelChunk, levelChunk.method_12200().method_22336());
        }
    }

    private static boolean checkLightSectionsOnChunk(class_2818 chunk, class_3568 engine) {
        class_2826[] sections = chunk.method_12006();
        int minY = chunk.method_32891();
        int maxY = chunk.method_31597();
        for (int y = minY; y < maxY; ++y) {
            class_2826 section = sections[chunk.method_31603(y)];
            if (section.method_38292() || engine.method_51559(class_4076.method_18681((class_1923)chunk.method_12004(), (int)y))) continue;
            return false;
        }
        return true;
    }

    private void throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(int x, int y, int z) throws IndexOutOfBoundsException {
        if (!RUN_RELATIVE_POS_INDEX_VALIDATION) {
            return;
        }
        int minHeight = this.getMinBuildHeight();
        int maxHeight = this.getMaxBuildHeight() + 1;
        if (x < 0 || x >= 16 || z < 0 || z >= 16 || y < minHeight || y > maxHeight) {
            String errorMessage = "Relative position [" + x + "," + y + "," + z + "] out of bounds. \nX/Z must be between 0 and 15 (inclusive) \nY must be between [" + minHeight + "] and [" + maxHeight + "] (inclusive).";
            throw new IndexOutOfBoundsException(errorMessage);
        }
    }

    public int relativeBlockPosToIndex(int xRel, int y, int zRel) {
        int yRel = y - this.getMinBuildHeight();
        return zRel * 16 * this.getHeight() + yRel * 16 + xRel;
    }

    public DhBlockPos indexToRelativeBlockPos(int index) {
        int zRel = index / (16 * this.getHeight());
        int y = (index -= zRel * 16 * this.getHeight()) / 16;
        int yRel = y + this.getMinBuildHeight();
        int xRel = index % 16;
        return new DhBlockPos(xRel, yRel, zRel);
    }
}

