/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.commands;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.command.impl.PluginCommand;
import com.willfp.eco.core.drops.DropQueue;
import com.willfp.eco.core.items.builder.EnchantedBookBuilder;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtils;
import com.willfp.ecoenchants.display.EnchantmentFormattingKt;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.rarity.EnchantmentRarities;
import com.willfp.ecoenchants.rarity.EnchantmentRarity;
import com.willfp.ecoenchants.type.EnchantmentType;
import com.willfp.ecoenchants.type.EnchantmentTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/willfp/ecoenchants/commands/CommandGiveRandomBook;", "Lcom/willfp/eco/core/command/impl/PluginCommand;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "onExecute", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "", "tabComplete", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nCommandGiveRandomBook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandGiveRandomBook.kt\ncom/willfp/ecoenchants/commands/CommandGiveRandomBook\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n766#2:97\n857#2,2:98\n1549#2:100\n1620#2,3:101\n1549#2:104\n1620#2,3:105\n1549#2:108\n1620#2,3:109\n1549#2:112\n1620#2,3:113\n1549#2:116\n1620#2,3:117\n*S KotlinDebug\n*F\n+ 1 CommandGiveRandomBook.kt\ncom/willfp/ecoenchants/commands/CommandGiveRandomBook\n*L\n51#1:97\n51#1:98,2\n84#1:100\n84#1:101,3\n85#1:104\n85#1:105,3\n85#1:108\n85#1:109,3\n86#1:112\n86#1:113,3\n90#1:116\n90#1:117,3\n*E\n"})
public final class CommandGiveRandomBook
extends PluginCommand {
    public CommandGiveRandomBook(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        super(plugin, "giverandombook", "ecoenchants.command.giverandombook", false);
    }

    /*
     * WARNING - void declaration
     */
    public void onExecute(@NotNull CommandSender sender, @NotNull List<String> args) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        int maxLevel;
        Registrable registrable;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String playerName = (String)CollectionsKt.getOrNull(args, (int)0);
        if (playerName == null) {
            sender.sendMessage(this.getPlugin().getLangYml().getMessage("requires-player"));
            return;
        }
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            sender.sendMessage(this.getPlugin().getLangYml().getMessage("invalid-player"));
            return;
        }
        String filterName = (String)CollectionsKt.getOrNull(args, (int)1);
        if (filterName != null) {
            EnchantmentType enchantmentType = (EnchantmentType)EnchantmentTypes.INSTANCE.get(filterName);
            registrable = enchantmentType != null ? (Registrable)enchantmentType : EnchantmentRarities.INSTANCE.get(filterName);
        } else {
            registrable = null;
        }
        Registrable filter = registrable;
        Object object = (String)CollectionsKt.getOrNull(args, (int)2);
        int minLevel = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
        Object object2 = (String)CollectionsKt.getOrNull(args, (int)3);
        int n = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : (maxLevel = Integer.MAX_VALUE);
        if (minLevel > maxLevel) {
            sender.sendMessage(this.getPlugin().getLangYml().getMessage("invalid-levels"));
            return;
        }
        Iterable iterable = EcoEnchants.INSTANCE.values();
        boolean $i$f$filter = false;
        void var13_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EcoEnchant it = (EcoEnchant)element$iv$iv;
            boolean bl = false;
            Registrable registrable2 = filter;
            boolean bl2 = (registrable2 instanceof EnchantmentRarity ? Intrinsics.areEqual((Object)it.getEnchantmentRarity(), (Object)filter) : (registrable2 instanceof EnchantmentType ? Intrinsics.areEqual((Object)it.getType(), (Object)filter) : true)) && it.getMaximumLevel() >= minLevel;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        EcoEnchant ecoEnchant = (EcoEnchant)CollectionsKt.randomOrNull((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default));
        if (ecoEnchant == null) {
            CommandGiveRandomBook $this$onExecute_u24lambda_u241 = this;
            boolean bl = false;
            sender.sendMessage($this$onExecute_u24lambda_u241.getPlugin().getLangYml().getMessage("no-enchantments-found"));
            return;
        }
        EcoEnchant enchantment = ecoEnchant;
        int level = NumberUtils.randInt((int)minLevel, (int)RangesKt.coerceAtMost((int)maxLevel, (int)enchantment.getMaximumLevel()));
        ItemStack item = new EnchantedBookBuilder().addStoredEnchantment(enchantment.getEnchantment(), level).build();
        new DropQueue(player).addItem(item).forceTelekinesis().push();
        String string = this.getPlugin().getLangYml().getMessage("gave-random-book", StringUtils.FormatOption.WITHOUT_PLACEHOLDERS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String string2 = player.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        sender.sendMessage(StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%player%", (String)string2, (boolean)false, (int)4, null), (String)"%enchantment%", (String)EnchantmentFormattingKt.getFormattedName$default(enchantment, level, false, 2, null), (boolean)false, (int)4, null));
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull List<String> args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return switch (args.size()) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v0 = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getOnlinePlayers(...)");
                Iterable $this$map$iv = v0;
                boolean $i$f$map = false;
                Iterable var5_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_31 = (Player)item$iv$iv;
                    Collection var14_39 = destination$iv$iv;
                    boolean $i$a$-map-CommandGiveRandomBook$tabComplete$1 = false;
                    String v1 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                    var14_39.add(v1);
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                Collection var14_40;
                Object it;
                Set v3 = EnchantmentRarities.INSTANCE.values();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"values(...)");
                Iterable $this$map$iv = v3;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (EnchantmentRarity)item$iv$iv;
                    var14_40 = destination$iv$iv;
                    boolean $i$a$-map-CommandGiveRandomBook$tabComplete$2 = false;
                    var14_40.add(((EnchantmentRarity)it).getId());
                }
                Collection v4 = (List)destination$iv$iv;
                Set v5 = EnchantmentTypes.INSTANCE.values();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"values(...)");
                $this$map$iv = v5;
                var14_40 = v4;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (EnchantmentType)item$iv$iv;
                    Collection var15_43 = destination$iv$iv;
                    boolean $i$a$-map-CommandGiveRandomBook$tabComplete$3 = false;
                    var15_43.add(((EnchantmentType)it).getId());
                }
                yield CollectionsKt.plus((Collection)var14_40, (Iterable)((List)destination$iv$iv));
            }
            case 3 -> {
                Iterable $this$map$iv = (Iterable)new IntRange(1, 10);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator var8_25 = $this$mapTo$iv$iv.iterator();
                while (var8_25.hasNext()) {
                    int item$iv$iv;
                    int it = item$iv$iv = ((IntIterator)var8_25).nextInt();
                    Collection var14_41 = destination$iv$iv;
                    boolean $i$a$-map-CommandGiveRandomBook$tabComplete$4 = false;
                    var14_41.add(String.valueOf(it));
                }
                yield (List)destination$iv$iv;
            }
            case 4 -> {
                void $this$mapTo$iv$iv;
                Integer v6 = StringsKt.toIntOrNull((String)args.get(3));
                int startLevel = v6 != null ? v6 : 1;
                int endLevel = startLevel + 10;
                Iterable $this$map$iv = (Iterable)new IntRange(startLevel, endLevel);
                boolean $i$f$map = false;
                Iterable $i$f$mapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator var10_34 = $this$mapTo$iv$iv.iterator();
                while (var10_34.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int var12_44 = item$iv$iv = ((IntIterator)var10_34).nextInt();
                    Collection var14_42 = destination$iv$iv;
                    boolean $i$a$-map-CommandGiveRandomBook$tabComplete$5 = false;
                    var14_42.add(String.valueOf((int)it));
                }
                yield (List)destination$iv$iv;
            }
            default -> CollectionsKt.emptyList();
        };
    }
}

