/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.libreforge.Holder;
import com.willfp.libreforge.conditions.ConditionList;
import com.willfp.libreforge.effects.EffectList;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;", "Lcom/willfp/libreforge/Holder;", "enchant", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "level", "", "effects", "Lcom/willfp/libreforge/effects/EffectList;", "conditions", "Lcom/willfp/libreforge/conditions/ConditionList;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/ecoenchants/enchant/EcoEnchant;ILcom/willfp/libreforge/effects/EffectList;Lcom/willfp/libreforge/conditions/ConditionList;Lcom/willfp/eco/core/EcoPlugin;)V", "getConditions", "()Lcom/willfp/libreforge/conditions/ConditionList;", "getEffects", "()Lcom/willfp/libreforge/effects/EffectList;", "getEnchant", "()Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "id", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/NotNull;", "getId", "()Lorg/bukkit/NamespacedKey;", "getLevel", "()I", "equals", "", "other", "", "hashCode", "toString", "", "core-plugin"})
public final class EcoEnchantLevel
implements Holder {
    @NotNull
    private final EcoEnchant enchant;
    private final int level;
    @NotNull
    private final EffectList effects;
    @NotNull
    private final ConditionList conditions;
    @NotNull
    private final NamespacedKey id;

    public EcoEnchantLevel(@NotNull EcoEnchant enchant, int level, @NotNull EffectList effects, @NotNull ConditionList conditions, @NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)enchant, (String)"enchant");
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        Intrinsics.checkNotNullParameter((Object)conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.enchant = enchant;
        this.level = level;
        this.effects = effects;
        this.conditions = conditions;
        NamespacedKey namespacedKey = plugin.createNamespacedKey(this.enchant.getId() + "_" + this.level);
        Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"createNamespacedKey(...)");
        this.id = namespacedKey;
    }

    @NotNull
    public final EcoEnchant getEnchant() {
        return this.enchant;
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public EffectList getEffects() {
        return this.effects;
    }

    @NotNull
    public ConditionList getConditions() {
        return this.conditions;
    }

    @NotNull
    public NamespacedKey getId() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EcoEnchantLevel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getId(), (Object)((EcoEnchantLevel)other).getId());
    }

    @NotNull
    public String toString() {
        String string = this.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId()};
        return Objects.hash(objectArray);
    }
}

