/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant.impl.hardcoded;

import com.willfp.eco.util.DurabilityUtils;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.impl.HardcodedEcoEnchant;
import com.willfp.ecoenchants.target.EnchantFinder;
import com.willfp.libreforge.slot.impl.SlotTypeHands;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentRepairing;", "Lcom/willfp/ecoenchants/enchant/impl/HardcodedEcoEnchant;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "handleRepairing", "", "onRegister", "core-plugin"})
public final class EnchantmentRepairing
extends HardcodedEcoEnchant {
    public EnchantmentRepairing(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super("repairing", plugin);
    }

    public void onRegister() {
        long frequency = this.getConfig().getInt("frequency");
        this.getPlugin().getScheduler().runTimer(frequency, frequency, () -> EnchantmentRepairing.onRegister$lambda$0(this));
    }

    private final void handleRepairing() {
        boolean notWhileHolding = this.getConfig().getBool("not-while-holding");
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            if (!EnchantFinder.INSTANCE.hasEnchantActive((LivingEntity)player, this)) continue;
            int repairPerLevel = this.getConfig().getIntFromExpression("repair-per-level", player);
            for (Map.Entry<ItemStack, Integer> entry : EnchantFinder.INSTANCE.getItemsWithEnchantActive((LivingEntity)player, this).entrySet()) {
                ItemStack item = entry.getKey();
                int level = ((Number)entry.getValue()).intValue();
                boolean isHolding = SlotTypeHands.INSTANCE.getItems(player).contains(item);
                if (notWhileHolding && isHolding) continue;
                DurabilityUtils.repairItem((ItemStack)item, (int)(level * repairPerLevel));
            }
        }
    }

    private static final void onRegister$lambda$0(EnchantmentRepairing this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleRepairing();
    }
}

