/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant.impl.hardcoded;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.impl.HardcodedEcoEnchant;
import com.willfp.ecoenchants.target.EnchantFinder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentReplenish;", "Lcom/willfp/ecoenchants/enchant/impl/HardcodedEcoEnchant;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "handler", "Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentReplenish$ReplenishHandler;", "onRegister", "", "onRemove", "ReplenishHandler", "core-plugin"})
public final class EnchantmentReplenish
extends HardcodedEcoEnchant {
    @NotNull
    private ReplenishHandler handler;

    public EnchantmentReplenish(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super("replenish", plugin);
        this.handler = new ReplenishHandler(this, plugin);
    }

    public void onRegister() {
        this.getPlugin().getEventManager().registerListener((Listener)this.handler);
    }

    public void onRemove() {
        this.getPlugin().getEventManager().unregisterListener((Listener)this.handler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentReplenish$ReplenishHandler;", "Lorg/bukkit/event/Listener;", "enchant", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/ecoenchants/enchant/EcoEnchant;Lcom/willfp/eco/core/EcoPlugin;)V", "handle", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "core-plugin"})
    private static final class ReplenishHandler
    implements Listener {
        @NotNull
        private final EcoEnchant enchant;
        @NotNull
        private final EcoPlugin plugin;

        public ReplenishHandler(@NotNull EcoEnchant enchant, @NotNull EcoPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)enchant, (String)"enchant");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            this.enchant = enchant;
            this.plugin = plugin;
        }

        @EventHandler(ignoreCancelled=true)
        public final void handle(@NotNull BlockBreakEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            Player player2 = player;
            if (!EnchantFinder.INSTANCE.hasEnchantActive((LivingEntity)player2, this.enchant)) {
                return;
            }
            Block block = event.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            Block block2 = block;
            Material material = block2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material type = material;
            Object[] objectArray = new Material[]{Material.GLOW_BERRIES, Material.SWEET_BERRY_BUSH, Material.CACTUS, Material.BAMBOO, Material.CHORUS_FLOWER, Material.SUGAR_CANE};
            if (ArraysKt.contains((Object[])objectArray, (Object)type)) {
                return;
            }
            BlockData blockData = block2.getBlockData();
            Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
            BlockData data = blockData;
            if (!(data instanceof Ageable)) {
                return;
            }
            if (this.enchant.getConfig().getBool("consume-seeds")) {
                ItemStack item = new ItemStack(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1 -> Material.WHEAT_SEEDS;
                    case 2 -> Material.POTATO;
                    case 3 -> Material.CARROT;
                    case 4 -> Material.BEETROOT_SEEDS;
                    default -> type;
                });
                ItemStack[] itemStackArray = new ItemStack[]{item};
                boolean hasSeeds = player2.getInventory().removeItem(itemStackArray).isEmpty();
                if (!hasSeeds) {
                    return;
                }
            }
            if (((Ageable)data).getAge() != ((Ageable)data).getMaximumAge()) {
                if (this.enchant.getConfig().getBool("only-fully-grown")) {
                    return;
                }
                event.setDropItems(false);
                event.setExpToDrop(0);
            }
            ((Ageable)data).setAge(0);
            this.plugin.getScheduler().run(() -> ReplenishHandler.handle$lambda$0(block2, type, data, player2));
        }

        private static final void handle$lambda$0(Block $block, Material $type, BlockData $data, Player $player) {
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
            Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            $block.setType($type);
            $block.setBlockData($data);
            Bukkit.getPluginManager().callEvent((Event)new BlockPlaceEvent($block, $block.getState(), $block.getRelative(BlockFace.DOWN), $player.getInventory().getItemInMainHand(), $player, true, EquipmentSlot.HAND));
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Material.values().length];
                try {
                    nArray[Material.WHEAT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Material.POTATOES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Material.CARROTS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Material.BEETROOTS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

