/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.mechanics;

import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.util.NumberUtils;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.enchant.UtilKt;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.ecoenchants.target.EnchantmentTargets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/ecoenchants/mechanics/VillagerSupport;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "onTrade", "", "event", "Lorg/bukkit/event/entity/VillagerAcquireTradeEvent;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nVillagerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillagerSupport.kt\ncom/willfp/ecoenchants/mechanics/VillagerSupport\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n187#2,3:127\n800#3,11:130\n1774#3,4:141\n*S KotlinDebug\n*F\n+ 1 VillagerSupport.kt\ncom/willfp/ecoenchants/mechanics/VillagerSupport\n*L\n61#1:127,3\n70#1:130,11\n71#1:141,4\n*E\n"})
public final class VillagerSupport
implements Listener {
    @NotNull
    private final EcoEnchantsPlugin plugin;

    public VillagerSupport(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    /*
     * Could not resolve type clashes
     * WARNING - void declaration
     */
    @EventHandler
    public final void onTrade(@NotNull VillagerAcquireTradeEvent event) {
        ItemMeta meta;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.plugin.getConfigYml().getBool("villager.enabled")) {
            return;
        }
        ItemStack itemStack = event.getRecipe().getResult().clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack result = itemStack;
        if (!EnchantmentTargets.INSTANCE.isEnchantable(result)) {
            return;
        }
        Map map = FastItemStackExtensions.fast((ItemStack)result).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
        Map enchants = map;
        if (NumberUtils.randFloat((double)0.0, (double)100.0) < this.plugin.getConfigYml().getDouble("villager.pass-through-chance")) {
            return;
        }
        double multiplier = 0.01;
        if (result.getType() == Material.ENCHANTED_BOOK) {
            multiplier *= this.plugin.getConfigYml().getDouble("villager.book-multiplier");
        }
        List enchantments = CollectionsKt.shuffled((Iterable)EcoEnchants.INSTANCE.values());
        for (Object enchantment : enchantments) {
            Integer n;
            int n2;
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object object;
            boolean bl;
            block18: {
                if (!enchantment.isObtainableThroughTrading() || !enchantment.canEnchantItem(result) || NumberUtils.randFloat((double)0.0, (double)1.0) > enchantment.getEnchantmentRarity().getVillagerChance() * multiplier) continue;
                Map $this$any$iv = enchants;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = object.next();
                        boolean bl2 = false;
                        Enchantment it = (Enchantment)entry.getKey();
                        Enchantment enchantment2 = enchantment.getEnchantment();
                        Intrinsics.checkNotNull((Object)it);
                        if (!UtilKt.conflictsWithDeep(enchantment2, it)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            if (enchants.size() > AnvilSupportKt.infiniteIfNegative(this.plugin.getConfigYml().getInt("anvil.enchant-limit"))) break;
            Iterable $this$filterIsInstance$iv = enchants.keySet();
            boolean $i$f$filterIsInstance = false;
            object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EcoEnchant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    EcoEnchant it = (EcoEnchant)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)enchantment.getType()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (n2 >= enchantment.getType().getLimit()) continue;
            int maxLevel = enchantment.getMaximumLevel();
            double levelPart1 = (double)((ItemStack)event.getRecipe().getIngredients().get(0)).getAmount() / 64.0;
            double levelPart2 = NumberUtils.bias((double)levelPart1, (double)enchantment.getType().getHighLevelBias());
            double levelPart3 = NumberUtils.triangularDistribution((double)0.0, (double)1.0, (double)levelPart2);
            int level = (int)((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(Math.ceil(levelPart3 * (double)maxLevel)), (ClosedFloatingPointRange)RangesKt.rangeTo((double)1.0, (double)maxLevel)))).doubleValue();
            multiplier /= this.plugin.getConfigYml().getDouble("villager.reduction");
            if (result.getType() == Material.ENCHANTED_BOOK) {
                enchants.clear();
                n = level;
                enchants.put(enchantment.getEnchantment(), n);
                break;
            }
            n = level;
            enchants.put(enchantment.getEnchantment(), n);
        }
        if ((meta = result.getItemMeta()) instanceof EnchantmentStorageMeta) {
            for (Enchantment enchant : ((EnchantmentStorageMeta)meta).getStoredEnchants().keySet()) {
                ((EnchantmentStorageMeta)meta).removeStoredEnchant(enchant);
            }
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                level = (Integer)entry.getValue();
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
                Intrinsics.checkNotNull((Object)level);
                enchantmentStorageMeta.addStoredEnchant(enchant, level.intValue(), true);
            }
        } else {
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                level = (Integer)entry.getValue();
                meta.removeEnchant(enchant);
                Intrinsics.checkNotNull((Object)level);
                meta.addEnchant(enchant, level.intValue(), true);
            }
        }
        result.setItemMeta(meta);
        MerchantRecipe recipe = new MerchantRecipe(result, event.getRecipe().getUses(), event.getRecipe().getMaxUses(), event.getRecipe().hasExperienceReward(), event.getRecipe().getVillagerExperience(), event.getRecipe().getPriceMultiplier());
        recipe.setIngredients(event.getRecipe().getIngredients());
        event.setRecipe(recipe);
    }
}

