/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.target;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchantLevel;
import com.willfp.ecoenchants.target.EnchantmentTarget;
import com.willfp.libreforge.DispatcherKt;
import com.willfp.libreforge.Holder;
import com.willfp.libreforge.ProvidedHolder;
import com.willfp.libreforge.TypedProvidedHolder;
import com.willfp.libreforge.slot.ItemHolderFinder;
import com.willfp.libreforge.slot.SlotType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0011\u0010\u0016\u001a\u00020\u0017*\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J\u001e\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dRf\u0010\u0004\u001aZ\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*,\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/willfp/ecoenchants/target/EnchantFinder;", "Lcom/willfp/libreforge/slot/ItemHolderFinder;", "Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;", "()V", "levelCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "", "Lcom/willfp/ecoenchants/target/EnchantFinder$ProvidedLevel;", "cachedLevels", "Lorg/bukkit/entity/LivingEntity;", "getCachedLevels", "(Lorg/bukkit/entity/LivingEntity;)Ljava/util/List;", "find", "item", "Lorg/bukkit/inventory/ItemStack;", "isValidInSlot", "", "holder", "slot", "Lcom/willfp/libreforge/slot/SlotType;", "clearEnchantmentCache", "", "clearEnchantmentCache$core_plugin", "getItemsWithEnchantActive", "", "", "enchant", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "hasEnchantActive", "ProvidedLevel", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nEnchantFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantFinder.kt\ncom/willfp/ecoenchants/target/EnchantFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n766#2:77\n857#2,2:78\n1747#2,3:80\n766#2:83\n857#2,2:84\n766#2:86\n857#2,2:87\n1179#2,2:89\n1253#2,4:91\n*S KotlinDebug\n*F\n+ 1 EnchantFinder.kt\ncom/willfp/ecoenchants/target/EnchantFinder\n*L\n37#1:73\n37#1:74,3\n55#1:77\n55#1:78,2\n56#1:80,3\n61#1:83\n61#1:84,2\n62#1:86\n62#1:87,2\n63#1:89,2\n63#1:91,4\n*E\n"})
public final class EnchantFinder
extends ItemHolderFinder<EcoEnchantLevel> {
    @NotNull
    public static final EnchantFinder INSTANCE = new EnchantFinder();
    private static final Cache<UUID, List<ProvidedLevel>> levelCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    private EnchantFinder() {
    }

    @NotNull
    public List<EcoEnchantLevel> find(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Map enchantMap = FastItemStackExtensions.fast((ItemStack)item).getEnchants();
        List enchants = new ArrayList();
        Intrinsics.checkNotNull((Object)enchantMap);
        for (Map.Entry entry : enchantMap.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            if (!(enchant instanceof EcoEnchant)) continue;
            Collection collection = enchants;
            EcoEnchant ecoEnchant = (EcoEnchant)enchant;
            Intrinsics.checkNotNull((Object)level);
            collection.add(ecoEnchant.getLevel(level));
        }
        return enchants;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValidInSlot(@NotNull EcoEnchantLevel holder, @NotNull SlotType slot) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Iterable $this$map$iv = holder.getEnchant().getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EnchantmentTarget enchantmentTarget = (EnchantmentTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSlot());
        }
        return ((List)destination$iv$iv).contains(slot);
    }

    public final void clearEnchantmentCache$core_plugin(@NotNull LivingEntity $this$clearEnchantmentCache) {
        Intrinsics.checkNotNullParameter((Object)$this$clearEnchantmentCache, (String)"<this>");
        levelCache.invalidate((Object)$this$clearEnchantmentCache.getUniqueId());
    }

    private final List<ProvidedLevel> getCachedLevels(LivingEntity $this$cachedLevels) {
        Object object = levelCache.get((Object)$this$cachedLevels.getUniqueId(), arg_0 -> EnchantFinder._get_cachedLevels_$lambda$1((Function1)new Function1<UUID, List<? extends ProvidedLevel>>($this$cachedLevels){
            final /* synthetic */ LivingEntity $this_cachedLevels;
            {
                this.$this_cachedLevels = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<ProvidedLevel> invoke(UUID it) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = EnchantFinder.INSTANCE.toHolderProvider().provide(DispatcherKt.toDispatcher((Entity)((Entity)this.$this_cachedLevels)));
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ProvidedLevel providedLevel;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TypedProvidedHolder it2 = (TypedProvidedHolder)element$iv$iv;
                    boolean bl2 = false;
                    Holder holder = it2.getHolder();
                    if ((holder instanceof EcoEnchantLevel ? (EcoEnchantLevel)holder : null) == null) {
                        providedLevel = null;
                    } else {
                        EcoEnchantLevel level;
                        level = level;
                        Object object = it2.getProvider();
                        if ((object instanceof ItemStack ? (ItemStack)object : null) == null) {
                            providedLevel = null;
                        } else {
                            ItemStack item;
                            item = item;
                            providedLevel = new ProvidedLevel(level, item, (ProvidedHolder)it2);
                        }
                    }
                    if (providedLevel == null) continue;
                    ProvidedLevel it$iv$iv = providedLevel;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasEnchantActive(@NotNull LivingEntity $this$hasEnchantActive, @NotNull EcoEnchant enchant) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$hasEnchantActive, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)enchant, (String)"enchant");
            Iterable $this$filter$iv = this.getCachedLevels($this$hasEnchantActive);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProvidedLevel it = (ProvidedLevel)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getLevel().getEnchant(), (Object)enchant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProvidedLevel it = (ProvidedLevel)element$iv;
                    boolean bl3 = false;
                    if (!it.getLevel().getConditions().areMet(DispatcherKt.toDispatcher((Entity)((Entity)$this$hasEnchantActive)), it.getHolder())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ItemStack, Integer> getItemsWithEnchantActive(@NotNull LivingEntity $this$getItemsWithEnchantActive, @NotNull EcoEnchant enchant) {
        void $this$associateTo$iv$iv;
        ProvidedLevel it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getItemsWithEnchantActive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchant, (String)"enchant");
        Iterable $this$filter$iv = this.getCachedLevels($this$getItemsWithEnchantActive);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProvidedLevel)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLevel().getEnchant(), (Object)enchant)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProvidedLevel)element$iv$iv;
            boolean bl = false;
            if (!it.getLevel().getConditions().areMet(DispatcherKt.toDispatcher((Entity)((Entity)$this$getItemsWithEnchantActive)), it.getHolder())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            ProvidedLevel it2 = (ProvidedLevel)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it2.getItem(), (Object)it2.getLevel().getLevel());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final List _get_cachedLevels_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/willfp/ecoenchants/target/EnchantFinder$ProvidedLevel;", "", "level", "Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;", "item", "Lorg/bukkit/inventory/ItemStack;", "holder", "Lcom/willfp/libreforge/ProvidedHolder;", "(Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;Lorg/bukkit/inventory/ItemStack;Lcom/willfp/libreforge/ProvidedHolder;)V", "getHolder", "()Lcom/willfp/libreforge/ProvidedHolder;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getLevel", "()Lcom/willfp/ecoenchants/enchant/EcoEnchantLevel;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core-plugin"})
    private static final class ProvidedLevel {
        @NotNull
        private final EcoEnchantLevel level;
        @NotNull
        private final ItemStack item;
        @NotNull
        private final ProvidedHolder holder;

        public ProvidedLevel(@NotNull EcoEnchantLevel level, @NotNull ItemStack item, @NotNull ProvidedHolder holder) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.level = level;
            this.item = item;
            this.holder = holder;
        }

        @NotNull
        public final EcoEnchantLevel getLevel() {
            return this.level;
        }

        @NotNull
        public final ItemStack getItem() {
            return this.item;
        }

        @NotNull
        public final ProvidedHolder getHolder() {
            return this.holder;
        }

        @NotNull
        public final EcoEnchantLevel component1() {
            return this.level;
        }

        @NotNull
        public final ItemStack component2() {
            return this.item;
        }

        @NotNull
        public final ProvidedHolder component3() {
            return this.holder;
        }

        @NotNull
        public final ProvidedLevel copy(@NotNull EcoEnchantLevel level, @NotNull ItemStack item, @NotNull ProvidedHolder holder) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            return new ProvidedLevel(level, item, holder);
        }

        public static /* synthetic */ ProvidedLevel copy$default(ProvidedLevel providedLevel, EcoEnchantLevel ecoEnchantLevel, ItemStack itemStack, ProvidedHolder providedHolder, int n, Object object) {
            if ((n & 1) != 0) {
                ecoEnchantLevel = providedLevel.level;
            }
            if ((n & 2) != 0) {
                itemStack = providedLevel.item;
            }
            if ((n & 4) != 0) {
                providedHolder = providedLevel.holder;
            }
            return providedLevel.copy(ecoEnchantLevel, itemStack, providedHolder);
        }

        @NotNull
        public String toString() {
            return "ProvidedLevel(level=" + this.level + ", item=" + this.item + ", holder=" + this.holder + ")";
        }

        public int hashCode() {
            int result = this.level.hashCode();
            result = result * 31 + this.item.hashCode();
            result = result * 31 + this.holder.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProvidedLevel)) {
                return false;
            }
            ProvidedLevel providedLevel = (ProvidedLevel)other;
            if (!Intrinsics.areEqual((Object)this.level, (Object)providedLevel.level)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.item, (Object)providedLevel.item)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.holder, (Object)providedLevel.holder);
        }
    }
}

