/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.adapters.paper;

import java.util.Arrays;
import org.geysermc.geyser.adapters.paper.PaperWorldAdapter;

public final class PaperAdapters {
    private static PaperWorldAdapter worldAdapter;
    private static final int[] protocols;

    public static void registerClosestWorldAdapter(int version) throws Exception {
        if (version < protocols[0]) {
            throw new IllegalArgumentException("Java versions pre-1.20.5 should use the Spigot mapped SpigotAdapters!");
        }
        if (Arrays.stream(protocols).anyMatch(value -> version == value)) {
            PaperAdapters.registerWorldAdapter(version);
            return;
        }
        int closest = Arrays.stream(protocols).reduce((a, b) -> Math.abs(a - version) < Math.abs(b - version) ? a : b).orElse(protocols[0]);
        PaperAdapters.registerWorldAdapter(closest);
    }

    public static void registerWorldAdapter(int version) throws Exception {
        Class<?> adapterVersion = Class.forName("org.geysermc.geyser.adapters.paper.v" + version + ".WorldAdapter_v" + version);
        worldAdapter = (PaperWorldAdapter)adapterVersion.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static PaperWorldAdapter getWorldAdapter() {
        return worldAdapter;
    }

    private PaperAdapters() {
    }

    static {
        protocols = new int[]{766};
    }
}

