/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.holder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.InventoryUtils;

public class BlockInventoryHolder
extends InventoryHolder {
    private final int defaultJavaBlockState;
    private final ContainerType containerType;
    private final Set<String> validBlocks;

    public BlockInventoryHolder(String javaBlockIdentifier, ContainerType containerType, String ... validBlocks) {
        this.defaultJavaBlockState = ((Object2IntMap)BlockRegistries.JAVA_IDENTIFIER_TO_ID.get()).getInt(javaBlockIdentifier);
        this.containerType = containerType;
        if (validBlocks != null) {
            HashSet<String> validBlocksTemp = new HashSet<String>(validBlocks.length + 1);
            Collections.addAll(validBlocksTemp, validBlocks);
            validBlocksTemp.add(BlockUtils.getCleanIdentifier(javaBlockIdentifier));
            this.validBlocks = Set.copyOf(validBlocksTemp);
        } else {
            this.validBlocks = Collections.singleton(BlockUtils.getCleanIdentifier(javaBlockIdentifier));
        }
    }

    @Override
    public boolean prepareInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        Vector3i position;
        if (this.checkInteractionPosition(session)) {
            String[] javaBlockString;
            int javaBlockId = session.getGeyser().getWorldManager().getBlockAt(session, session.getLastInteractionBlockPosition());
            if (!((Int2ObjectMap)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get()).containsKey(javaBlockId) && this.isValidBlock(javaBlockString = BlockRegistries.JAVA_BLOCKS.getOrDefault(javaBlockId, BlockMapping.DEFAULT).getJavaIdentifier().split("\\["))) {
                inventory.setHolderPosition(session.getLastInteractionBlockPosition());
                ((Container)inventory).setUsingRealBlock(true, javaBlockString[0]);
                this.setCustomName(session, session.getLastInteractionBlockPosition(), inventory, javaBlockId);
                return true;
            }
        }
        if ((position = InventoryUtils.findAvailableWorldSpace(session)) == null) {
            return false;
        }
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(position);
        blockPacket.setDefinition(session.getBlockMappings().getVanillaBedrockBlock(this.defaultJavaBlockState));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
        inventory.setHolderPosition(position);
        this.setCustomName(session, position, inventory, this.defaultJavaBlockState);
        return true;
    }

    protected boolean checkInteractionPosition(GeyserSession session) {
        return session.getLastInteractionPlayerPosition().equals(session.getPlayerEntity().getPosition());
    }

    protected boolean isValidBlock(String[] javaBlockString) {
        return this.validBlocks.contains(javaBlockString[0]);
    }

    protected void setCustomName(GeyserSession session, Vector3i position, Inventory inventory, int javaBlockState) {
        NbtMap tag = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle()).build();
        BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag);
        dataPacket.setBlockPosition(position);
        session.sendUpstreamPacket(dataPacket);
    }

    @Override
    public void openInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getBedrockId());
        containerOpenPacket.setType(this.containerType);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket(containerOpenPacket);
    }

    @Override
    public void closeInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        if (inventory instanceof Container) {
            Container container = (Container)inventory;
            if (container.isUsingRealBlock() && !(inventory instanceof LecternContainer)) {
                ContainerClosePacket packet = new ContainerClosePacket();
                packet.setId((byte)inventory.getBedrockId());
                packet.setServerInitiated(true);
                session.sendUpstreamPacket(packet);
                return;
            }
        } else {
            GeyserImpl.getInstance().getLogger().warning("Tried to close a non-container inventory in a block inventory holder! ");
            if (GeyserImpl.getInstance().getLogger().isDebug()) {
                GeyserImpl.getInstance().getLogger().debug("Current inventory: " + inventory);
                GeyserImpl.getInstance().getLogger().debug("Open inventory: " + session.getOpenInventory());
            }
            session.setOpenInventory(null);
            session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
            return;
        }
        Vector3i holderPos = inventory.getHolderPosition();
        int realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos.getX(), holderPos.getY(), holderPos.getZ());
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(holderPos);
        blockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(realBlock));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
    }
}

